/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Host;

public final class BinaryDataFormat {
    private byte shortSize = 0;
    private byte intSize = 0;
    private byte longSize = 0;
    private byte longLongSize = 0;
    private byte floatSize = 0;
    private byte doubleSize = 0;
    private byte longDoubleSize = 0;
    private boolean isMBF = true;
    private boolean sameByteOrder = true;
    private boolean sameShortSize = true;
    private boolean sameIntSize = true;
    private boolean sameLongSize = true;
    private boolean sameLongLongSize = true;
    private boolean sameFloatSize = true;
    private boolean sameDoubleSize = true;
    private boolean sameLongDoubleSize = true;

    public BinaryDataFormat() {
        this.isMBF = Host.isMBFByteOrder();
        this.sameByteOrder = true;
        this.shortSize = Host.getStorageSize(1);
        this.intSize = Host.getStorageSize(2);
        this.longSize = Host.getStorageSize(3);
        this.longLongSize = Host.getStorageSize(4);
        this.floatSize = Host.getStorageSize(5);
        this.doubleSize = Host.getStorageSize(6);
        this.longDoubleSize = Host.getStorageSize(7);
        this.sameShortSize = true;
        this.sameIntSize = true;
        this.sameLongSize = true;
        this.sameLongLongSize = true;
        this.sameFloatSize = true;
        this.sameDoubleSize = true;
        this.sameLongDoubleSize = true;
    }

    public BinaryDataFormat(BinaryDataFormat format) throws NullPointerException {
        if (format == null) {
            throw new NullPointerException();
        }
        this.isMBF = format.isMBF;
        this.shortSize = format.shortSize;
        this.intSize = format.intSize;
        this.longSize = format.longSize;
        this.longLongSize = format.longLongSize;
        this.floatSize = format.floatSize;
        this.doubleSize = format.doubleSize;
        this.longDoubleSize = format.longDoubleSize;
        this.sameByteOrder = Host.isMBFByteOrder() == this.isMBF;
        this.sameShortSize = Host.getStorageSize(1) == this.shortSize;
        this.sameIntSize = Host.getStorageSize(2) == this.intSize;
        this.sameLongSize = Host.getStorageSize(3) == this.longSize;
        this.sameLongLongSize = Host.getStorageSize(4) == this.longLongSize;
        this.sameFloatSize = Host.getStorageSize(5) == this.floatSize;
        this.sameDoubleSize = Host.getStorageSize(6) == this.doubleSize;
        this.sameLongDoubleSize = Host.getStorageSize(7) == this.longDoubleSize;
    }

    public final void finalize() {
    }

    public final boolean equals(BinaryDataFormat bdf) {
        if (this.isMBF != bdf.isMBF) {
            return false;
        }
        if (this.shortSize != bdf.shortSize) {
            return false;
        }
        if (this.intSize != bdf.intSize) {
            return false;
        }
        if (this.longSize != bdf.longSize) {
            return false;
        }
        if (this.longLongSize != bdf.longLongSize) {
            return false;
        }
        if (this.floatSize != bdf.floatSize) {
            return false;
        }
        if (this.doubleSize != bdf.doubleSize) {
            return false;
        }
        return this.longDoubleSize == bdf.longDoubleSize;
    }

    public final boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BinaryDataFormat bdf = (BinaryDataFormat)obj;
        return this.equals(bdf);
    }

    public final void setMBFByteOrder() {
        this.isMBF = true;
        this.sameByteOrder = this.isMBF == Host.isMBFByteOrder();
    }

    public final void setLBFByteOrder() {
        this.isMBF = false;
        this.sameByteOrder = this.isMBF == Host.isMBFByteOrder();
    }

    public final boolean isMBFByteOrder() {
        return this.isMBF;
    }

    public final boolean isLBFByteOrder() {
        return !this.isMBF;
    }

    public final void setShortSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        this.shortSize = (byte)nBytes;
        this.sameShortSize = nBytes == Host.getStorageSize(1);
    }

    public final void setIntSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        this.intSize = (byte)nBytes;
        this.sameIntSize = nBytes == Host.getStorageSize(2);
    }

    public final void setLongSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        this.longSize = (byte)nBytes;
        this.sameLongSize = nBytes == Host.getStorageSize(3);
    }

    public final void setLongLongSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        this.longLongSize = (byte)nBytes;
        this.sameLongLongSize = nBytes == Host.getStorageSize(4);
    }

    public final void setFloatSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        if (nBytes != 4 && nBytes != 8 && nBytes != 16) {
            throw new IllegalArgumentException();
        }
        this.floatSize = (byte)nBytes;
        this.sameFloatSize = nBytes == Host.getStorageSize(5);
    }

    public final void setDoubleSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        if (nBytes != 4 && nBytes != 8 && nBytes != 16) {
            throw new IllegalArgumentException();
        }
        this.doubleSize = (byte)nBytes;
        this.sameDoubleSize = nBytes == Host.getStorageSize(6);
    }

    public final void setLongDoubleSize(int nBytes) throws IllegalArgumentException {
        if (nBytes <= 0) {
            throw new IllegalArgumentException();
        }
        if (nBytes != 4 && nBytes != 8 && nBytes != 16) {
            throw new IllegalArgumentException();
        }
        this.longDoubleSize = (byte)nBytes;
        this.sameLongDoubleSize = nBytes == Host.getStorageSize(7);
    }

    public final int getShortSize() {
        return this.shortSize;
    }

    public final int getIntSize() {
        return this.intSize;
    }

    public final int getLongSize() {
        return this.longSize;
    }

    public final int getLongLongSize() {
        return this.longLongSize;
    }

    public final int getFloatSize() {
        return this.floatSize;
    }

    public final int getDoubleSize() {
        return this.doubleSize;
    }

    public final int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    public final short shortValue(byte[] bytes) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.shortSize);
            }
            return Host.castToShort(bytes);
        }
        int nBytes = this.shortSize;
        short value = 0;
        if (this.isMBF) {
            if ((bytes[0] & 0xFFFFFF80) > 0) {
                value = -1;
            }
            int i = 0;
            while (i < nBytes) {
                value = (short)(value << 8 | bytes[i] & 0xFF);
                ++i;
            }
            return value;
        }
        if ((bytes[nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = (short)(value << 8 | bytes[i] & 0xFF);
            --i;
        }
        return value;
    }

    public final int unsignedShortValue(byte[] bytes) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.shortSize);
            }
            return Host.castToShort(bytes);
        }
        int nBytes = this.shortSize;
        int value = 0;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | bytes[i] & 0xFF;
                ++i;
            }
            return value &= ~(-1 << Host.getSignificantBits(1));
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | bytes[i] & 0xFF;
            --i;
        }
        return value &= ~(-1 << Host.getSignificantBits(1));
    }

    public final int intValue(byte[] bytes) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.intSize);
            }
            return Host.castToInt(bytes);
        }
        int nBytes = this.intSize;
        int value = 0;
        if (this.isMBF) {
            if ((bytes[0] & 0xFFFFFF80) > 0) {
                value = -1;
            }
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | bytes[i] & 0xFF;
                ++i;
            }
            return value;
        }
        if ((bytes[nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | bytes[i] & 0xFF;
            --i;
        }
        return value;
    }

    public final long unsignedIntValue(byte[] bytes) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.intSize);
            }
            return Host.castToInt(bytes);
        }
        int nBytes = this.intSize;
        long value = 0L;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[i] & 0xFFL;
                ++i;
            }
            return value &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[i] & 0xFFL;
            --i;
        }
        return value &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long longValue(byte[] bytes) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longSize);
            }
            return Host.castToLong(bytes);
        }
        int nBytes = this.longSize;
        long value = 0L;
        if (this.isMBF) {
            if ((bytes[0] & 0xFFFFFF80) > 0) {
                value = -1L;
            }
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[i] & 0xFFL;
                ++i;
            }
            return value;
        }
        if ((bytes[nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1L;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final long unsignedLongValue(byte[] bytes) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longSize);
            }
            return Host.castToLong(bytes);
        }
        int nBytes = this.longSize;
        long value = 0L;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[i] & 0xFFL;
                ++i;
            }
            return value;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final long longLongValue(byte[] bytes) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longLongSize);
            }
            return Host.castToLongLong(bytes);
        }
        int nBytes = this.longLongSize;
        long value = 0L;
        if (this.isMBF) {
            if ((bytes[0] & 0xFFFFFF80) > 0) {
                value = -1L;
            }
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[i] & 0xFFL;
                ++i;
            }
            return value;
        }
        if ((bytes[nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1L;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final long unsignedLongLongValue(byte[] bytes) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longLongSize);
            }
            return Host.castToLongLong(bytes);
        }
        int nBytes = this.longLongSize;
        long value = 0L;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[i] & 0xFFL;
                ++i;
            }
            return value;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final float floatValue(byte[] bytes) {
        if (this.sameFloatSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.floatSize);
            }
            return Host.castToFloat(bytes);
        }
        byte nBytes = this.floatSize;
        if (Host.getStorageSize(6) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return (float)Host.castToDouble(bytes);
        }
        if (Host.getStorageSize(7) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return (float)Host.castToLongDouble(bytes);
        }
        return 0.0f;
    }

    public final double doubleValue(byte[] bytes) {
        if (this.sameDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.doubleSize);
            }
            return Host.castToDouble(bytes);
        }
        byte nBytes = this.doubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return Host.castToFloat(bytes);
        }
        if (Host.getStorageSize(7) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return Host.castToLongDouble(bytes);
        }
        return 0.0;
    }

    public final double longDoubleValue(byte[] bytes) {
        if (this.sameLongDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longDoubleSize);
            }
            return Host.castToLongDouble(bytes);
        }
        byte nBytes = this.longDoubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return Host.castToFloat(bytes);
        }
        if (Host.getStorageSize(6) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return Host.castToDouble(bytes);
        }
        return 0.0;
    }

    public final short shortValue(byte[] bytes, int offset) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.shortSize);
            }
            return Host.castToShort(bytes, offset);
        }
        int nBytes = this.shortSize;
        short value = 0;
        if (this.isMBF) {
            if ((bytes[offset] & 0xFFFFFF80) > 0) {
                value = -1;
            }
            int i = 0;
            while (i < nBytes) {
                value = (short)(value << 8 | bytes[offset + i] & 0xFF);
                ++i;
            }
            return value;
        }
        if ((bytes[offset + nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = (short)(value << 8 | bytes[offset + i] & 0xFF);
            --i;
        }
        return value;
    }

    public final int unsignedShortValue(byte[] bytes, int offset) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.shortSize);
            }
            return Host.castToShort(bytes, offset);
        }
        int nBytes = this.shortSize;
        int value = 0;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | bytes[offset + i] & 0xFF;
                ++i;
            }
            return value &= ~(-1 << Host.getSignificantBits(1));
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | bytes[offset + i] & 0xFF;
            --i;
        }
        return value &= ~(-1 << Host.getSignificantBits(1));
    }

    public final int intValue(byte[] bytes, int offset) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.intSize);
            }
            return Host.castToInt(bytes, offset);
        }
        int nBytes = this.intSize;
        int value = 0;
        if (this.isMBF) {
            if ((bytes[offset] & 0xFFFFFF80) > 0) {
                value = -1;
            }
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | bytes[offset + i] & 0xFF;
                ++i;
            }
            return value;
        }
        if ((bytes[offset + nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | bytes[offset + i] & 0xFF;
            --i;
        }
        return value;
    }

    public final long unsignedIntValue(byte[] bytes, int offset) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.intSize);
            }
            return Host.castToInt(bytes, offset);
        }
        int nBytes = this.intSize;
        long value = 0L;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[offset + i] & 0xFFL;
                ++i;
            }
            return value &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[offset + i] & 0xFFL;
            --i;
        }
        return value &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long longValue(byte[] bytes, int offset) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longSize);
            }
            return Host.castToLong(bytes, offset);
        }
        int nBytes = this.longSize;
        long value = 0L;
        if (this.isMBF) {
            if ((bytes[offset] & 0xFFFFFF80) > 0) {
                value = -1L;
            }
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[offset + i] & 0xFFL;
                ++i;
            }
            return value;
        }
        if ((bytes[offset + nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1L;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[offset + i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final long unsignedLongValue(byte[] bytes, int offset) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longSize);
            }
            return Host.castToLong(bytes, offset);
        }
        int nBytes = this.longSize;
        long value = 0L;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[offset + i] & 0xFFL;
                ++i;
            }
            return value;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[offset + i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final long longLongValue(byte[] bytes, int offset) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longLongSize);
            }
            return Host.castToLongLong(bytes, offset);
        }
        int nBytes = this.longLongSize;
        long value = 0L;
        if (this.isMBF) {
            if ((bytes[offset] & 0xFFFFFF80) > 0) {
                value = -1L;
            }
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[offset + i] & 0xFFL;
                ++i;
            }
            return value;
        }
        if ((bytes[offset + nBytes - 1] & 0xFFFFFF80) > 0) {
            value = -1L;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[offset + i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final long unsignedLongLongValue(byte[] bytes, int offset) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longLongSize);
            }
            return Host.castToLongLong(bytes, offset);
        }
        int nBytes = this.longLongSize;
        long value = 0L;
        if (this.isMBF) {
            int i = 0;
            while (i < nBytes) {
                value = value << 8 | (long)bytes[offset + i] & 0xFFL;
                ++i;
            }
            return value;
        }
        int i = nBytes - 1;
        while (i >= 0) {
            value = value << 8 | (long)bytes[offset + i] & 0xFFL;
            --i;
        }
        return value;
    }

    public final float floatValue(byte[] bytes, int offset) {
        if (this.sameFloatSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.floatSize);
            }
            return Host.castToFloat(bytes, offset);
        }
        byte nBytes = this.floatSize;
        if (Host.getStorageSize(6) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return (float)Host.castToDouble(bytes, offset);
        }
        if (Host.getStorageSize(7) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return (float)Host.castToLongDouble(bytes, offset);
        }
        return 0.0f;
    }

    public final double doubleValue(byte[] bytes, int offset) {
        if (this.sameDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.doubleSize);
            }
            return Host.castToDouble(bytes, offset);
        }
        byte nBytes = this.doubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return Host.castToFloat(bytes, offset);
        }
        if (Host.getStorageSize(7) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return Host.castToLongDouble(bytes, offset);
        }
        return 0.0;
    }

    public final double longDoubleValue(byte[] bytes, int offset) {
        if (this.sameLongDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longDoubleSize);
            }
            return Host.castToLongDouble(bytes, offset);
        }
        byte nBytes = this.longDoubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return Host.castToFloat(bytes, offset);
        }
        if (Host.getStorageSize(6) == nBytes) {
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return Host.castToDouble(bytes, offset);
        }
        return 0.0;
    }

    public final void shortValues(byte[] bytes, short[] values, int nValues) {
        byte nBytes = this.shortSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.shortValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void unsignedShortValues(byte[] bytes, short[] values, int nValues) {
        byte nBytes = this.shortSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = (short)this.unsignedShortValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void intValues(byte[] bytes, int[] values, int nValues) {
        byte nBytes = this.intSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.intValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void unsignedIntValues(byte[] bytes, int[] values, int nValues) {
        byte nBytes = this.intSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = (int)this.unsignedIntValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void longValues(byte[] bytes, long[] values, int nValues) {
        byte nBytes = this.longSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.longValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void unsignedLongValues(byte[] bytes, long[] values, int nValues) {
        byte nBytes = this.longSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.unsignedLongValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void longLongValues(byte[] bytes, long[] values, int nValues) {
        byte nBytes = this.longLongSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.longLongValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void unsignedLongLongValues(byte[] bytes, long[] values, int nValues) {
        byte nBytes = this.longLongSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.unsignedLongLongValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void floatValues(byte[] bytes, float[] values, int nValues) {
        byte nBytes = this.floatSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.floatValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void doubleValues(byte[] bytes, double[] values, int nValues) {
        byte nBytes = this.doubleSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.doubleValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final void longDoubleValues(byte[] bytes, double[] values, int nValues) {
        byte nBytes = this.longDoubleSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            values[i] = this.longDoubleValue(bytes, offset);
            offset += nBytes;
            --i;
        }
    }

    public final int encodeShort(short value, byte[] bytes) {
        if (this.sameShortSize) {
            Host.copyShort(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value = (short)(value >> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value = (short)(value >> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeShort(int value, byte[] bytes) {
        if (this.sameShortSize) {
            Host.copyShort(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        short s = (short)value;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)s;
                s = (short)(s >> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)s;
            s = (short)(s >> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedShort(short value, byte[] bytes) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value = (short)(value >>> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value = (short)(value >>> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedShort(int value, byte[] bytes) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        short us = (short)value;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)us;
                us = (short)(us >>> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)us;
            us = (short)(us >>> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeInt(int value, byte[] bytes) {
        if (this.sameIntSize) {
            Host.copyInt(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.intSize);
            }
            return this.intSize;
        }
        int nBytes = this.intSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedInt(int value, byte[] bytes) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.intSize);
            }
            return this.intSize;
        }
        int nBytes = this.intSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedInt(long value, byte[] bytes) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt((int)value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.intSize);
            }
            return this.intSize;
        }
        int nBytes = this.intSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeLong(long value, byte[] bytes) {
        if (this.sameLongSize) {
            Host.copyLong(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longSize);
            }
            return this.longSize;
        }
        int nBytes = this.longSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedLong(long value, byte[] bytes) {
        if (this.sameLongSize) {
            Host.copyUnsignedLong(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longSize);
            }
            return this.longSize;
        }
        int nBytes = this.longSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeLongLong(long value, byte[] bytes) {
        if (this.sameLongLongSize) {
            Host.copyLongLong(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longLongSize);
            }
            return this.longLongSize;
        }
        int nBytes = this.longLongSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedLongLong(long value, byte[] bytes) {
        if (this.sameLongLongSize) {
            Host.copyUnsignedLongLong(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longLongSize);
            }
            return this.longLongSize;
        }
        int nBytes = this.longLongSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeFloat(float value, byte[] bytes) {
        if (this.sameFloatSize) {
            Host.copyFloat(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.floatSize);
            }
            return this.floatSize;
        }
        byte nBytes = this.floatSize;
        if (Host.getStorageSize(6) == nBytes) {
            Host.copyDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(7) == nBytes) {
            Host.copyLongDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeFloat(double value, byte[] bytes) {
        if (this.sameFloatSize) {
            Host.copyFloat((float)value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.floatSize);
            }
            return this.floatSize;
        }
        byte nBytes = this.floatSize;
        if (Host.getStorageSize(6) == nBytes) {
            Host.copyDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(7) == nBytes) {
            Host.copyLongDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeDouble(double value, byte[] bytes) {
        if (this.sameDoubleSize) {
            Host.copyDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.doubleSize);
            }
            return this.doubleSize;
        }
        byte nBytes = this.doubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            Host.copyFloat((float)value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(7) == nBytes) {
            Host.copyLongDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeLongDouble(double value, byte[] bytes) {
        if (this.sameLongDoubleSize) {
            Host.copyLongDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, this.longDoubleSize);
            }
            return this.longDoubleSize;
        }
        byte nBytes = this.longDoubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            Host.copyFloat((float)value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(6) == nBytes) {
            Host.copyDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeShort(short value, byte[] bytes, int offset) {
        if (this.sameShortSize) {
            Host.copyShort(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value = (short)(value >> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value = (short)(value >> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeShort(int value, byte[] bytes, int offset) {
        if (this.sameShortSize) {
            Host.copyShort((short)value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        short s = (short)value;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)s;
                s = (short)(s >> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)s;
            s = (short)(s >> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedShort(short value, byte[] bytes, int offset) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value = (short)(value >>> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value = (short)(value >>> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedShort(int value, byte[] bytes, int offset) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort((short)value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.shortSize);
            }
            return this.shortSize;
        }
        int nBytes = this.shortSize;
        short us = (short)value;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)us;
                us = (short)(us >>> 8);
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)us;
            us = (short)(us >>> 8);
            ++i;
        }
        return nBytes;
    }

    public final int encodeInt(int value, byte[] bytes, int offset) {
        if (this.sameIntSize) {
            Host.copyInt(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.intSize);
            }
            return this.intSize;
        }
        int nBytes = this.intSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value >>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedInt(int value, byte[] bytes, int offset) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.intSize);
            }
            return this.intSize;
        }
        int nBytes = this.intSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedInt(long value, byte[] bytes, int offset) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.intSize);
            }
            return this.intSize;
        }
        int nBytes = this.intSize;
        int v = (int)value;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)v;
                v >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)v;
            v >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeLong(long value, byte[] bytes, int offset) {
        if (this.sameLongSize) {
            Host.copyLong(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longSize);
            }
            return this.longSize;
        }
        int nBytes = this.longSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value >>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedLong(long value, byte[] bytes, int offset) {
        if (this.sameLongSize) {
            Host.copyUnsignedLong(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longSize);
            }
            return this.longSize;
        }
        int nBytes = this.longSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeLongLong(long value, byte[] bytes, int offset) {
        if (this.sameLongLongSize) {
            Host.copyLongLong(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longLongSize);
            }
            return this.longLongSize;
        }
        int nBytes = this.longLongSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value >>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value >>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeUnsignedLongLong(long value, byte[] bytes, int offset) {
        if (this.sameLongLongSize) {
            Host.copyUnsignedLongLong(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longLongSize);
            }
            return this.longLongSize;
        }
        int nBytes = this.longLongSize;
        if (this.isMBF) {
            int i = nBytes - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)value;
                value >>>= 8;
                --i;
            }
            return nBytes;
        }
        int i = 0;
        while (i < nBytes) {
            bytes[offset + i] = (byte)value;
            value >>>= 8;
            ++i;
        }
        return nBytes;
    }

    public final int encodeFloat(float value, byte[] bytes, int offset) {
        if (this.sameFloatSize) {
            Host.copyFloat(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.floatSize);
            }
            return this.floatSize;
        }
        byte nBytes = this.floatSize;
        if (Host.getStorageSize(6) == nBytes) {
            Host.copyDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(7) == nBytes) {
            Host.copyLongDouble(value, bytes);
            if (!this.sameByteOrder) {
                Host.swap(bytes, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeFloat(double value, byte[] bytes, int offset) {
        if (this.sameFloatSize) {
            Host.copyFloat((float)value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.floatSize);
            }
            return this.floatSize;
        }
        byte nBytes = this.floatSize;
        if (Host.getStorageSize(6) == nBytes) {
            Host.copyDouble(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(7) == nBytes) {
            Host.copyLongDouble(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeDouble(double value, byte[] bytes, int offset) {
        if (this.sameDoubleSize) {
            Host.copyDouble(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.doubleSize);
            }
            return this.doubleSize;
        }
        byte nBytes = this.doubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            Host.copyFloat((float)value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(7) == nBytes) {
            Host.copyLongDouble(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeLongDouble(double value, byte[] bytes, int offset) {
        if (this.sameLongDoubleSize) {
            Host.copyLongDouble(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, this.longDoubleSize);
            }
            return this.longDoubleSize;
        }
        byte nBytes = this.longDoubleSize;
        if (Host.getStorageSize(5) == nBytes) {
            Host.copyFloat((float)value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return nBytes;
        }
        if (Host.getStorageSize(6) == nBytes) {
            Host.copyDouble(value, bytes, offset);
            if (!this.sameByteOrder) {
                Host.swap(bytes, offset, nBytes);
            }
            return nBytes;
        }
        return nBytes;
    }

    public final int encodeShorts(short[] values, int nValues, byte[] bytes) {
        byte nBytes = this.shortSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeShort(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeUnsignedShorts(short[] values, int nValues, byte[] bytes) {
        byte nBytes = this.shortSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeUnsignedShort(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeInts(int[] values, int nValues, byte[] bytes) {
        byte nBytes = this.intSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeInt(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeUnsignedInts(int[] values, int nValues, byte[] bytes) {
        byte nBytes = this.intSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeUnsignedInt(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeLongs(long[] values, int nValues, byte[] bytes) {
        byte nBytes = this.longSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeLong(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeUnsignedLongs(long[] values, int nValues, byte[] bytes) {
        byte nBytes = this.longSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeUnsignedLong(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeLongLongs(long[] values, int nValues, byte[] bytes) {
        byte nBytes = this.longLongSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeLongLong(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeUnsignedLongLongs(long[] values, int nValues, byte[] bytes) {
        byte nBytes = this.longLongSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeUnsignedLongLong(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeFloats(float[] values, int nValues, byte[] bytes) {
        byte nBytes = this.floatSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeFloat(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeDoubles(double[] values, int nValues, byte[] bytes) {
        byte nBytes = this.doubleSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeDouble(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }

    public final int encodeLongDoubles(double[] values, int nValues, byte[] bytes) {
        byte nBytes = this.longDoubleSize;
        int offset = 0;
        int i = nValues - 1;
        while (i >= 0) {
            this.encodeDouble(values[i], bytes, offset);
            offset += nBytes;
            --i;
        }
        return offset;
    }
}

