/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaReader {
    private String nameSpaceURI = "http://www.w3.org/2001/XMLSchema";
    private final XPathFactory factory;
    private final Document doc;

    public SchemaReader(URL uRL) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.parse(uRL.openConnection().getInputStream());
        this.factory = XPathFactory.newInstance();
    }

    public List<String> getAllowedChoices(String string, String string2) throws Exception {
        return this.processExpression("//xsd:schema/xsd:element[@name='" + string + "']/xsd:complexType/xsd:sequence/xsd:element[@name='" + string2 + "']/xsd:simpleType/xsd:restriction/xsd:enumeration", "value");
    }

    public List<String> getChildTags(String string) throws Exception {
        if (string == null) {
            return this.processExpression("*/xsd:element", "name");
        }
        return this.processExpression("*//xsd:element[@name='" + string + "']/xsd:complexType/xsd:sequence/xsd:element", "name");
    }

    public List<String> getParents(String string) throws Exception {
        XPath xPath = this.factory.newXPath();
        xPath.setNamespaceContext(this.getXSDContext());
        XPathExpression xPathExpression = xPath.compile("*//xsd:element");
        Object object = xPathExpression.evaluate(this.doc, XPathConstants.NODESET);
        if (object == null) {
            return null;
        }
        NodeList nodeList = (NodeList)object;
        if (nodeList.getLength() < 1) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getAttributes().getNamedItem("name") != null && string.equals(node.getAttributes().getNamedItem("name").getNodeValue())) {
                try {
                    Node node2 = node.getParentNode().getParentNode().getParentNode();
                    if (node2.getAttributes().getNamedItem("name") != null) {
                        arrayList.add(node2.getAttributes().getNamedItem("name").getNodeValue());
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return arrayList;
    }

    private List<String> processExpression(String string, String string2) throws Exception {
        XPath xPath = this.factory.newXPath();
        xPath.setNamespaceContext(this.getXSDContext());
        XPathExpression xPathExpression = xPath.compile(string);
        Object object = xPathExpression.evaluate(this.doc, XPathConstants.NODESET);
        if (object == null) {
            return null;
        }
        NodeList nodeList = (NodeList)object;
        if (nodeList.getLength() < 1) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            arrayList.add(node.getAttributes().getNamedItem(string2).getNodeValue());
            ++n;
        }
        return arrayList;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    private NamespaceContext getXSDContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String string) {
                if ("xsd".equals(string)) {
                    return SchemaReader.this.nameSpaceURI;
                }
                return null;
            }

            @Override
            public String getPrefix(String string) {
                return null;
            }

            public Iterator getPrefixes(String string) {
                return null;
            }
        };
    }
}

