/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util.beans.xml;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLObjectConfigFileValidator {
    private static final Logger logger = LoggerFactory.getLogger(XMLObjectConfigFileValidator.class);
    private static final String SAX_REPORT_VALIDATION_ERRORS = "http://xml.org/sax/features/validation";
    private static final String XERCES_REPORT_SCHEMA_ERRORS = "http://apache.org/xml/features/validation/schema";
    private static final String XERCES_FULL_SCHEMA_GRAMMAR_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String XERCES_SCHEMA_WITHOUT_NAMESPACE = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String JAXP_DOCBUILDER_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String JAXP_DOCBUILDER_FACTORY_XERCES_IMPL = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final String JAXP_PROPS_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_PROPS_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3_SCHEMA_LANGUAGE_URI = "http://www.w3.org/2001/XMLSchema";
    private String SchemaUrl = null;
    private String xmlInstanceDocumentURL = null;
    private InputSource xmlInstanceDocumentSource = null;

    private boolean xerces2Validate() throws Exception {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setFeature(SAX_REPORT_VALIDATION_ERRORS, true);
        sAXParser.setFeature(XERCES_REPORT_SCHEMA_ERRORS, true);
        sAXParser.setFeature(XERCES_FULL_SCHEMA_GRAMMAR_CHECKING, true);
        sAXParser.setProperty(XERCES_SCHEMA_WITHOUT_NAMESPACE, (Object)this.SchemaUrl);
        Validator validator = new Validator();
        sAXParser.setErrorHandler((ErrorHandler)validator);
        if (this.xmlInstanceDocumentSource != null) {
            sAXParser.parse(this.xmlInstanceDocumentSource);
        } else {
            sAXParser.parse(this.xmlInstanceDocumentURL);
        }
        validator.throwIfRequired();
        return true;
    }

    private boolean jaxpValidate() throws Exception {
        System.setProperty(JAXP_DOCBUILDER_FACTORY, JAXP_DOCBUILDER_FACTORY_XERCES_IMPL);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setAttribute(JAXP_PROPS_SCHEMA_LANGUAGE, W3_SCHEMA_LANGUAGE_URI);
        documentBuilderFactory.setAttribute(JAXP_PROPS_SCHEMA_SOURCE, this.SchemaUrl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Validator validator = new Validator();
        documentBuilder.setErrorHandler(validator);
        if (this.xmlInstanceDocumentSource != null) {
            documentBuilder.parse(this.xmlInstanceDocumentSource);
        } else {
            documentBuilder.parse(this.xmlInstanceDocumentURL);
        }
        validator.throwIfRequired();
        return false;
    }

    public boolean validateFile(String string, String string2, boolean bl) throws Exception {
        this.SchemaUrl = this.getPath(string);
        this.xmlInstanceDocumentURL = this.getPath(string2);
        this.xmlInstanceDocumentSource = null;
        if (bl) {
            return this.xerces2Validate();
        }
        return this.jaxpValidate();
    }

    private String getPath(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") > -1) {
            return string;
        }
        if (string.startsWith("/")) {
            return string;
        }
        return new File(string).getAbsolutePath();
    }

    private CharArrayWriter getCharArrayWriterFromInputSource(InputSource inputSource) throws UnsupportedEncodingException {
        Closeable closeable;
        Reader reader = inputSource.getCharacterStream();
        BufferedReader bufferedReader = null;
        if (reader == null) {
            closeable = inputSource.getByteStream();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)closeable, "UTF-8"));
        } else {
            bufferedReader = new BufferedReader(reader);
        }
        try {
            closeable = new CharArrayWriter();
            try {
                int n;
                while ((n = ((Reader)bufferedReader).read()) > -1) {
                    ((CharArrayWriter)closeable).write(n);
                }
            }
            catch (IOException iOException) {
                logger.error("Cannot read file", (Throwable)iOException);
                closeable = null;
            }
            Closeable closeable2 = closeable;
            return closeable2;
        }
        finally {
            try {
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {
                logger.error("Cannot close stream", (Throwable)iOException);
            }
        }
    }

    public InputSource validateSource(String string, InputSource inputSource, boolean bl) throws Exception {
        CharArrayWriter charArrayWriter = this.getCharArrayWriterFromInputSource(inputSource);
        return this.validateSource(string, charArrayWriter.toCharArray(), bl);
    }

    public InputSource validateSource(String string, char[] cArray, boolean bl) throws Exception {
        InputSource inputSource = new InputSource(new CharArrayReader(cArray));
        this.SchemaUrl = string;
        this.xmlInstanceDocumentURL = null;
        this.xmlInstanceDocumentSource = inputSource;
        boolean bl2 = false;
        bl2 = bl ? this.xerces2Validate() : this.jaxpValidate();
        if (bl2) {
            return new InputSource(new CharArrayReader(cArray));
        }
        return null;
    }

    private class Validator
    extends DefaultHandler {
        private SAXParseException saxParseException = null;

        private Validator() {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.saxParseException = sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.saxParseException = sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.saxParseException = sAXParseException;
        }

        public void throwIfRequired() throws Exception {
            if (this.saxParseException != null) {
                throw this.saxParseException;
            }
        }
    }
}

