/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.util;

import java.util.Collection;
import java.util.HashSet;

public class ThreadManager {
    protected static Collection<String> takenNames = new HashSet<String>(89);

    public static Thread getThread() {
        Thread thread = new Thread();
        ThreadManager.createUniqueNameFromStack(thread);
        return thread;
    }

    public static Thread getThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        ThreadManager.createUniqueNameFromStack(thread);
        return thread;
    }

    public static void createUniqueNameFromStack(Thread thread) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = null;
        int n = 1;
        while (n < stackTraceElementArray.length) {
            String string2 = stackTraceElementArray[n].getClassName();
            if (!string2.equals(ThreadManager.class.getName())) {
                string = string2;
                break;
            }
            ++n;
        }
        if (string != null) {
            thread.setName(ThreadManager.getUniqueName(string));
        }
    }

    protected static String getUniqueName(String string) {
        int n = 1;
        String string2 = "GDA Thread " + string + "_" + n;
        while (takenNames.contains(string2)) {
            string2 = "GDA Thread " + string + "_" + ++n;
        }
        takenNames.add(string2);
        if (takenNames.size() > 100) {
            takenNames.clear();
        }
        return string2;
    }

    public static Thread getThread(Runnable runnable, String string) {
        return new Thread(runnable, string);
    }

    public static Thread getThread(String string) {
        return new Thread(string);
    }

    public static void main(String[] stringArray) {
        ThreadNameStackTester threadNameStackTester = new ThreadNameStackTester();
        threadNameStackTester.create();
    }

    private static class ThreadNameStackTester {
        private ThreadNameStackTester() {
        }

        void create() {
            Thread thread = ThreadManager.getThread();
            Thread thread2 = ThreadManager.getThread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Hello");
                }
            });
            Thread thread3 = ThreadManager.getThread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("you");
                }
            }, "Name1");
            Thread thread4 = ThreadManager.getThread("Name2");
            System.out.println(thread.getName());
            System.out.println(thread2.getName());
            System.out.println(thread3.getName());
            System.out.println(thread4.getName());
        }
    }
}

