/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.doe;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.doe.DOEControl;
import uk.ac.gda.doe.DOEField;
import uk.ac.gda.doe.FieldContainer;
import uk.ac.gda.doe.FieldValue;
import uk.ac.gda.doe.RangeInfo;

public class DOEUtils {
    private static final int MAX_RANGE_SIZE = 1000;

    public static List<RangeInfo> getInfoFromList(List<Object> list) throws Exception {
        ArrayList<RangeInfo> arrayList = new ArrayList<RangeInfo>(31);
        DOEUtils.getInfoFromList(list, 0, arrayList);
        return arrayList;
    }

    private static void getInfoFromList(List<Object> list, int n, List<RangeInfo> list2) throws Exception {
        if (n >= list.size()) {
            return;
        }
        Object object = list.get(n);
        if (object != null) {
            List<RangeInfo> list3 = DOEUtils.getInfo(object);
            for (RangeInfo rangeInfo : list3) {
                if (!rangeInfo.isEmpty()) {
                    list2.add(rangeInfo);
                }
                DOEUtils.getInfoFromList(list, n + 1, list2);
            }
        } else {
            DOEUtils.getInfoFromList(list, n + 1, list2);
        }
    }

    public static List<RangeInfo> getInfo(Object object) throws Exception {
        ArrayList<List<FieldContainer>> arrayList = new ArrayList<List<FieldContainer>>(11);
        int n = 0;
        while (n < 11) {
            arrayList.add(new ArrayList(7));
            ++n;
        }
        DOEUtils.readAnnotations(null, object, arrayList, -1);
        List<FieldContainer> list = DOEUtils.expandFields(arrayList);
        ArrayList<RangeInfo> arrayList2 = new ArrayList<RangeInfo>(31);
        DOEUtils.getInfo(new RangeInfo(), list, 0, arrayList2);
        return arrayList2;
    }

    protected static void getInfo(RangeInfo rangeInfo, List<FieldContainer> list, int n, List<RangeInfo> list2) throws Exception {
        if (n >= list.size()) {
            RangeInfo rangeInfo2 = BeansFactory.deepClone(rangeInfo);
            list2.add(rangeInfo2);
            return;
        }
        FieldContainer fieldContainer = list.get(n);
        Object object = fieldContainer.getOriginalObject();
        String string = (String)BeansFactory.getBeanValue(object, fieldContainer.getName());
        if (string == null) {
            DOEUtils.getInfo(rangeInfo, list, n + 1, list2);
            return;
        }
        String string2 = string.toString();
        List<? extends Number> list3 = DOEUtils.expand(string2, fieldContainer.getAnnotation().type());
        for (Number number : list3) {
            if (list3.size() > 1) {
                rangeInfo.set(new FieldValue(fieldContainer.getOriginalObject(), fieldContainer.getName(), number.toString()));
            }
            DOEUtils.getInfo(rangeInfo, list, n + 1, list2);
        }
    }

    public static List<? extends Object> expand(Object object) throws Exception {
        ArrayList<List<FieldContainer>> arrayList = new ArrayList<List<FieldContainer>>(11);
        int n = 0;
        while (n < 11) {
            arrayList.add(new ArrayList(7));
            ++n;
        }
        DOEUtils.readAnnotations(null, object, arrayList, -1);
        List<FieldContainer> list = DOEUtils.expandFields(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(31);
        Object object2 = BeansFactory.deepClone(object);
        DOEUtils.expand(object2, list, 0, arrayList2);
        return arrayList2;
    }

    private static List<FieldContainer> expandFields(List<List<FieldContainer>> list) {
        ArrayList<FieldContainer> arrayList = new ArrayList<FieldContainer>(31);
        for (List<FieldContainer> list2 : list) {
            for (FieldContainer fieldContainer : list2) {
                arrayList.add(0, fieldContainer);
            }
        }
        return arrayList;
    }

    protected static void readAnnotations(FieldContainer fieldContainer, Object object, List<List<FieldContainer>> list, int n) throws Exception {
        List<Field> list2;
        if (object.getClass().getName().startsWith("java.lang.")) {
            return;
        }
        Field[] fieldArray = null;
        if (object instanceof List) {
            list2 = (List<Field>)object;
            if (!list2.isEmpty()) {
                fieldArray = list2.get(0).getClass().getDeclaredFields();
            }
        } else {
            fieldArray = object.getClass().getDeclaredFields();
        }
        if (fieldArray == null) {
            return;
        }
        list2 = DOEUtils.getControlledFields(object, fieldArray);
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            if (list2 == null || !list2.contains(field)) {
                Object object2;
                DOEField dOEField = field.getAnnotation(DOEField.class);
                FieldContainer fieldContainer2 = new FieldContainer();
                fieldContainer2.setField(field);
                fieldContainer2.setOriginalObject(object);
                fieldContainer2.setParent(fieldContainer);
                fieldContainer2.setListIndex(n);
                fieldContainer2.setAnnotation(dOEField);
                if (dOEField != null) {
                    object2 = list.get(dOEField.value());
                    if (object instanceof List) {
                        List list3 = (List)object;
                        int n3 = 0;
                        while (n3 < list3.size()) {
                            object2.add(fieldContainer2.clone(list3.get(n3), n3));
                            ++n3;
                        }
                    } else {
                        object2.add(fieldContainer2);
                    }
                } else {
                    try {
                        if (object instanceof List) {
                            object2 = (List)object;
                            int n4 = 0;
                            while (n4 < object2.size()) {
                                DOEUtils.readAnnotations(fieldContainer2, object2.get(n4), list, n4);
                                ++n4;
                            }
                        } else {
                            object2 = BeansFactory.getBeanValue(object, field.getName());
                            if (object2 != null) {
                                DOEUtils.readAnnotations(fieldContainer2, object2, list, -1);
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++n2;
        }
    }

    private static List<Field> getControlledFields(Object object, Field[] fieldArray) throws Exception {
        if (object instanceof List) {
            return null;
        }
        ArrayList<Field> arrayList = new ArrayList<Field>(7);
        int n = 0;
        while (n < fieldArray.length) {
            String[] stringArray;
            Object object2;
            Field field = fieldArray[n];
            DOEControl dOEControl = field.getAnnotation(DOEControl.class);
            if (dOEControl != null && (object2 = BeansFactory.getBeanValue(object, field.getName())) != null && Arrays.asList(stringArray = dOEControl.values()).contains(object2)) {
                String[] stringArray2 = dOEControl.fields();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (!stringArray[n2].equals(object2)) {
                        arrayList.add(object.getClass().getDeclaredField(stringArray2[n2]));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    protected static void expand(Object object, List<FieldContainer> list, int n, List<Object> list2) throws Exception {
        if (n >= list.size()) {
            if (!list2.contains(object)) {
                list2.add(object);
            }
            return;
        }
        FieldContainer fieldContainer = list.get(n);
        Object object2 = fieldContainer.getOriginalObject();
        String string = (String)BeansFactory.getBeanValue(object2, fieldContainer.getName());
        if (string == null) {
            DOEUtils.expand(object, list, n + 1, list2);
            return;
        }
        String string2 = string.toString();
        List<? extends Number> list3 = DOEUtils.expand(string2, fieldContainer.getAnnotation().type());
        for (Number number : list3) {
            object = BeansFactory.deepClone(object);
            DOEUtils.setBeanValue(object, fieldContainer, number.toString(), fieldContainer.getListIndex());
            DOEUtils.expand(object, list, n + 1, list2);
        }
    }

    protected static void setBeanValue(Object object, FieldContainer fieldContainer, String string, int n) throws Exception {
        ArrayList<FieldContainer> arrayList = new ArrayList<FieldContainer>(3);
        FieldContainer fieldContainer2 = fieldContainer.getParent();
        while (fieldContainer2 != null) {
            arrayList.add(0, fieldContainer2);
            fieldContainer2 = fieldContainer2.getParent();
        }
        Object object2 = object;
        for (FieldContainer fieldContainer3 : arrayList) {
            object2 = object2 instanceof List ? ((List)object2).get(fieldContainer.getParent().getListIndex()) : BeansFactory.getBeanValue(object2, fieldContainer3.getName());
        }
        if (object2 instanceof List && n > -1) {
            object2 = ((List)object2).get(n);
        }
        BeansFactory.setBeanValue(object2, fieldContainer.getName(), string);
    }

    public static List<? extends Number> expand(String string) {
        return DOEUtils.expand(string, null);
    }

    public static <T extends Number> List<T> expand(String string, Class<T> clazz) {
        return DOEUtils.expand(string, null, clazz);
    }

    public static List<? extends Number> expand(String string, String string2) {
        return DOEUtils.expand(string, string2, Double.class);
    }

    private static <T extends Number> List<T> expand(String string, String string2, Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(7);
        if (DOEUtils.isList(string, string2)) {
            String[] stringArray;
            String string3 = DOEUtils.removeUnit(string, string2);
            String[] stringArray2 = stringArray = string3.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray2[n2];
                arrayList.add(DOEUtils.getValue(string4.trim(), clazz));
                ++n2;
            }
        } else if (DOEUtils.isRange(string, string2)) {
            String string5 = DOEUtils.removeUnit(string, string2);
            String[] stringArray = string5.split(";");
            double d = Double.parseDouble(stringArray[0].trim());
            double d2 = Double.parseDouble(stringArray[1].trim());
            double d3 = Double.parseDouble(stringArray[2].trim());
            if (d > d2) {
                double d4 = d;
                while (d4 >= d2) {
                    if (arrayList.size() <= 1000) {
                        arrayList.add(DOEUtils.getValue(d4, clazz));
                        d4 -= d3;
                        continue;
                    }
                    break;
                }
            } else {
                double d5 = d;
                while (d5 <= d2) {
                    if (arrayList.size() <= 1000) {
                        arrayList.add(DOEUtils.getValue(d5, clazz));
                        d5 += d3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            String string6 = DOEUtils.removeUnit(string, string2);
            arrayList.add(DOEUtils.getValue(string6.trim(), clazz));
        }
        return arrayList;
    }

    private static <T extends Number> T getValue(String string, Class<T> clazz) {
        return DOEUtils.getValue(new Double(string), clazz);
    }

    private static <T extends Number> T getValue(double d, Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)new Integer(Math.round(Math.round(d)));
        }
        if (clazz == Double.class) {
            return (T)new Double(d);
        }
        throw new ClassCastException("DOEUtils cannot expand with class " + clazz + " yet.");
    }

    public static boolean isDOE(String string) {
        return DOEUtils.isRange(string, null) || DOEUtils.isList(string, null);
    }

    public static boolean isRange(String string, String string2) {
        return DOEUtils.isRange(string, 8, string2);
    }

    public static boolean isRange(String string, int n, String string2) {
        Pattern pattern = DOEUtils.getRangePattern(n, string2);
        return pattern.matcher(string.trim()).matches();
    }

    public static Pattern getRangePattern(int n, String string) {
        String string2 = n > 0 ? "\\.?\\d{0," + n + "})" : ")";
        String string3 = "(\\-?\\d+" + string2;
        String string4 = "(" + string3 + ";\\ ?" + string3 + ";\\ ?" + string3 + ")";
        if (string == null) {
            return Pattern.compile(string4);
        }
        return Pattern.compile(String.valueOf(string4) + "\\ {1}\\Q" + string + "\\E");
    }

    public static boolean isList(String string, String string2) {
        return DOEUtils.isList(string, 8, string2);
    }

    public static boolean isList(String string, int n, String string2) {
        Pattern pattern = DOEUtils.getListPattern(n, string2);
        return pattern.matcher(string.trim()).matches();
    }

    public static Pattern getListPattern(int n, String string) {
        String string2 = n > 0 ? "\\.?\\d{0," + n + "})" : ")";
        String string3 = "(\\-?\\d+" + string2;
        String string4 = "((" + string3 + ",\\ ?)+" + string3 + ")";
        if (string == null) {
            return Pattern.compile(string4);
        }
        return Pattern.compile(String.valueOf(string4) + "\\ {1}\\Q" + string + "\\E");
    }

    public static String removeUnit(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        Pattern pattern = Pattern.compile("(.+)\\ ?\\Q" + string2 + "\\E");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return string;
    }
}

