/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class BeansFactory {
    private static final Logger logger = LoggerFactory.getLogger(BeansFactory.class);
    private static Class<?>[] CLASSES;
    private List<String> classList;

    private static void checkInit() throws NullPointerException {
        if (CLASSES == null) {
            throw new NullPointerException("BeansFactory.CLASSES is null, therefore BeansFactory has not been initialized properly");
        }
    }

    public static Object getBeanObject(String string, Object object) throws Exception {
        BeansFactory.checkInit();
        int n = 0;
        while (n < CLASSES.length) {
            if (CLASSES[n].isInstance(object)) {
                return object;
            }
            ++n;
        }
        String string2 = String.valueOf(string) + object;
        if (!string2.endsWith(".xml")) {
            string2 = String.valueOf(string2) + ".xml";
        }
        return BeansFactory.getBean(new File(string2));
    }

    public static boolean isBean(File file) throws Exception {
        BeansFactory.checkInit();
        int n = 0;
        while (n < CLASSES.length) {
            if (BeansFactory.isBean(file, CLASSES[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Object getBean(File file) throws Exception {
        BeansFactory.checkInit();
        int n = 0;
        while (n < CLASSES.length) {
            if (BeansFactory.isBean(file, CLASSES[n])) {
                return XMLHelpers.readBean(file, CLASSES[n]);
            }
            ++n;
        }
        return null;
    }

    public static String getXMLString(Object object) throws Exception {
        StringWriter stringWriter;
        block8: {
            Object object2 = object;
            if (object instanceof String) {
                object2 = BeansFactory.getBean(new File((String)object));
            }
            URL uRL = null;
            Field[] fieldArray = object2.getClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n].getName().equalsIgnoreCase("mappingurl")) {
                    uRL = (URL)fieldArray[n].get(null);
                }
                ++n;
            }
            stringWriter = new StringWriter();
            try {
                try {
                    XMLHelpers.writeToXML(uRL, object2, stringWriter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    stringWriter.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                stringWriter.close();
                throw throwable;
            }
            stringWriter.close();
        }
        return stringWriter.toString();
    }

    public static void saveBean(File file, Object object) throws Exception {
        URL uRL = null;
        Field[] fieldArray = object.getClass().getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (fieldArray[n].getName().equalsIgnoreCase("mappingurl")) {
                uRL = (URL)fieldArray[n].get(null);
                break;
            }
            ++n;
        }
        XMLHelpers.writeToXML(uRL, object, file);
    }

    public static String getFirstFileName(File file, Class<?> clazz) throws Exception {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (BeansFactory.isBean(fileArray[n], clazz)) {
                return fileArray[n].getName();
            }
            ++n;
        }
        return null;
    }

    public static boolean isBean(File file, Class<?> clazz) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        return BeansFactory.isBean(bufferedReader, clazz);
    }

    public static boolean isBean(InputStream inputStream, Class<?> clazz) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        return BeansFactory.isBean(bufferedReader, clazz);
    }

    private static boolean isBean(BufferedReader bufferedReader, Class<?> clazz) throws Exception {
        try {
            bufferedReader.readLine();
            String string = bufferedReader.readLine();
            if (string == null) {
                return false;
            }
            String string2 = clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
            if (string2 == null) {
                return false;
            }
            return string.trim().equalsIgnoreCase("<" + string2 + ">") || string.trim().equalsIgnoreCase("<" + string2 + "/>");
            {
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/nv23/workspaces/gdatrunk_sep09ws/plugins/uk.ac.gda.client.microfocus/test/uk/ac/gda/client/microfocus/util/TestFiles/");
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].isDirectory()) {
                System.out.println(fileArray[n]);
                Object object = BeansFactory.getBean(fileArray[n]);
                if (object != null) {
                    System.out.println(object.getClass());
                } else {
                    System.out.println(object);
                }
            }
            ++n;
        }
    }

    public static Class<?>[] getClasses() {
        BeansFactory.checkInit();
        return CLASSES;
    }

    public static void setClasses(Class<?>[] classArray) {
        if (classArray == null) {
            throw new NullPointerException("cLASSES must be-non null to initialzied BeansFactory");
        }
        CLASSES = classArray;
    }

    public List<String> getClassList() {
        return this.classList;
    }

    public void setClassList(List<String> list) {
        this.classList = list;
        int n = 0;
        Class[] classArray = new Class[list.size()];
        for (String string : list) {
            try {
                classArray[n] = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("Cannot load class " + string, (Throwable)classNotFoundException);
            }
            ++n;
        }
        BeansFactory.setClasses(classArray);
    }

    public static void setBeanValue(Object object, String string, Object object2) throws Exception {
        String string2 = BeansFactory.getSetterName(string);
        try {
            Method method = object2 != null ? object.getClass().getMethod(string2, object2.getClass()) : object.getClass().getMethod(string2, Object.class);
            method.invoke(object, object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            BeanMap beanMap = new BeanMap(object);
            beanMap.put((Object)string, object2);
        }
    }

    public static Object getBeanValue(Object object, String string) throws Exception {
        String string2 = BeansFactory.getGetterName(string);
        Method method = object.getClass().getMethod(string2, new Class[0]);
        return method.invoke(object, new Object[0]);
    }

    public static String getFieldWithUpperCaseFirstLetter(String string) {
        return String.valueOf(string.substring(0, 1).toUpperCase(Locale.US)) + string.substring(1);
    }

    public static String getName(String string, String string2) {
        return String.valueOf(string) + BeansFactory.getFieldWithUpperCaseFirstLetter(string2);
    }

    public static String getSetterName(String string) {
        if (string == null) {
            return null;
        }
        return BeansFactory.getName("set", string);
    }

    public static String getGetterName(String string) {
        if (string == null) {
            return null;
        }
        return BeansFactory.getName("get", string);
    }

    public static boolean isClass(Class<? extends Object> clazz) {
        BeansFactory.checkInit();
        int n = 0;
        while (n < CLASSES.length) {
            if (CLASSES[n].equals(clazz)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static <T> T deepClone(T t) throws Exception {
        return BeansFactory.deepClone(t, t.getClass().getClassLoader());
    }

    public static <T> T deepClone(T t, final ClassLoader classLoader) throws Exception {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(t);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream){

            /*
             * Unable to fully structure code
             */
            @Override
            protected Class<?> resolveClass(ObjectStreamClass var1_1) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(var1_1.getName(), false, classLoader);
                }
                catch (Exception v0) {
                    var2_2 = 0;
                    ** while (var2_2 < BeansFactory.access$0().length)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        return BeansFactory.access$0()[var2_2].getClassLoader().loadClass(var1_1.getName());
                    }
                    catch (Exception v1) {
                        ++var2_2;
                    }
                    continue;
                }
lbl11:
                // 1 sources

                return null;
            }
        };
        byteArrayInputStream.close();
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return (T)object;
    }

    static /* synthetic */ Class[] access$0() {
        return CLASSES;
    }
}

