/*
 * Decompiled with CFR 0.152.
 */
package gda.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSCommandRunner
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(OSCommandRunner.class);
    public final Integer exitValue;
    public final Exception exception;
    public final Boolean succeeded;
    public final List<String> commands;
    public final boolean keepOutput;
    private final List<String> outputLines;

    public final List<String> getOutputLines() {
        return this.outputLines;
    }

    public OSCommandRunner(String[] stringArray, boolean bl, String string, String string2) {
        this(Arrays.asList(stringArray), bl, string, string2, null, null);
    }

    public OSCommandRunner(String string, boolean bl, String string2, String string3) {
        this(Arrays.asList(string.split("[\\s]")), bl, string2, string3, null, null);
    }

    public static void runNoWait(String string, LOGOPTION lOGOPTION, String string2) {
        OSCommandRunner.runNoWait(Arrays.asList(string.split("[\\s]")), lOGOPTION, string2);
    }

    public static void runNoWait(String[] stringArray, LOGOPTION lOGOPTION, String string) {
        OSCommandRunner.runNoWait(Arrays.asList(stringArray), lOGOPTION, string);
    }

    public static void runNoWait(List<String> list, LOGOPTION lOGOPTION, String string) {
        OSCommandRunner.runNoWait(list, lOGOPTION, string, null, null);
    }

    public static void runNoWait(List<String> list, LOGOPTION lOGOPTION, String string, ExecutorService executorService) {
        OSCommandRunner._runNoWait(list, lOGOPTION, string, null, null, executorService);
    }

    public static void runNoWait(List<String> list, LOGOPTION lOGOPTION, String string, Map<? extends String, ? extends String> map, List<String> list2) {
        OSCommandRunner._runNoWait(list, lOGOPTION, string, map, list2, null);
    }

    private static void _runNoWait(final List<String> list, final LOGOPTION lOGOPTION, final String string, final Map<? extends String, ? extends String> map, final List<String> list2, ExecutorService executorService) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OSCommandRunner oSCommandRunner = new OSCommandRunner(list, lOGOPTION != LOGOPTION.NEVER, string, null, map, list2);
                if (oSCommandRunner.exception != null) {
                    String string2 = "Exception seen trying to run command " + oSCommandRunner.getCommandAsString();
                    logger.error(string2);
                    logger.error(oSCommandRunner.exception.toString());
                } else if (oSCommandRunner.exitValue != 0) {
                    String string3 = "Exit code = " + Integer.toString(oSCommandRunner.exitValue) + " returned from command " + oSCommandRunner.getCommandAsString();
                    logger.warn(string3);
                    if (lOGOPTION != LOGOPTION.NEVER) {
                        oSCommandRunner.logOutput();
                    }
                } else if (lOGOPTION == LOGOPTION.ALWAYS) {
                    oSCommandRunner.logOutput();
                }
            }
        };
        if (executorService != null) {
            executorService.submit(runnable);
        } else {
            new Thread(runnable, OSCommandRunner.class.getSimpleName()).start();
        }
    }

    public OSCommandRunner(List<String> list, boolean bl, Object object, String string) {
        this(list, bl, object, string, null, null);
    }

    public OSCommandRunner(List<String> list, boolean bl, Object object, String string, Map<? extends String, ? extends String> map, List<String> list2) {
        this(list, bl, object, string, map, list2, null);
    }

    public OSCommandRunner(List<String> list, boolean bl, Object object, String string, Map<? extends String, ? extends String> map, List<String> list2, String string2) {
        block30: {
            this.commands = list;
            this.keepOutput = bl;
            Integer n = 0;
            Exception exception = null;
            Boolean bl2 = false;
            Vector<String> vector = null;
            try {
                try {
                    Closeable closeable;
                    Object object2;
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    if (list2 != null) {
                        for (String string3 : list2) {
                            processBuilder.environment().remove(string3);
                        }
                    }
                    if (map != null) {
                        processBuilder.environment().putAll(map);
                    }
                    processBuilder.redirectErrorStream(true);
                    processBuilder.command(this.commands);
                    if (string2 != null && !string2.isEmpty()) {
                        processBuilder.directory(new File(string2));
                    }
                    Process process = processBuilder.start();
                    if (object != null) {
                        object2 = process.getOutputStream();
                        closeable = object instanceof String ? new FileInputStream((String)object) : null;
                        try {
                            byte[] byArray = new byte[4096];
                            if (closeable != null) {
                                int n2 = 0;
                                while ((n2 = ((InputStream)closeable).read(byArray)) >= 0) {
                                    ((OutputStream)object2).write(byArray, 0, n2);
                                }
                            } else {
                                String[] stringArray = (String[])object;
                                int n3 = 0;
                                while (n3 < stringArray.length) {
                                    ((OutputStream)object2).write(stringArray[n3].getBytes("UTF-8"));
                                    ((OutputStream)object2).write(10);
                                    ++n3;
                                }
                            }
                        }
                        catch (IOException iOException) {}
                        ((OutputStream)object2).close();
                        if (closeable != null) {
                            ((InputStream)closeable).close();
                        }
                    }
                    if (!this.keepOutput && string == null) {
                        OSCommandRunner.pipe(process.getInputStream(), System.out);
                    }
                    n = process.waitFor();
                    if (string != null) {
                        object2 = process.getInputStream();
                        closeable = new FileOutputStream(string);
                        byte[] byArray = new byte[4096];
                        int n4 = 0;
                        while ((n4 = ((InputStream)object2).read(byArray)) >= 0) {
                            ((OutputStream)closeable).write(byArray, 0, n4);
                        }
                        ((OutputStream)closeable).close();
                    }
                    if (this.keepOutput) {
                        object2 = null;
                        closeable = null;
                        try {
                            String string4;
                            closeable = string != null ? new FileInputStream(string) : process.getInputStream();
                            object2 = new BufferedReader(new InputStreamReader((InputStream)closeable));
                            vector = new Vector<String>();
                            while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                                vector.add(string4);
                            }
                        }
                        finally {
                            if (string != null && closeable != null) {
                                ((InputStream)closeable).close();
                            }
                        }
                    }
                    bl2 = n == 0;
                    OSCommandRunner.closeStream(process.getInputStream(), "input");
                    OSCommandRunner.closeStream(process.getOutputStream(), "output");
                    OSCommandRunner.closeStream(process.getErrorStream(), "error");
                    process.destroy();
                }
                catch (Exception exception2) {
                    this.exception = exception = exception2;
                    this.exitValue = n;
                    this.succeeded = bl2;
                    if (vector != null) {
                        this.outputLines = vector;
                        break block30;
                    }
                    this.outputLines = null;
                }
            }
            finally {
                this.exception = exception;
                this.exitValue = n;
                this.succeeded = bl2;
                this.outputLines = vector != null ? vector : null;
            }
        }
    }

    private static void closeStream(Closeable closeable, String string) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            logger.warn(String.format("Unable to close process %s stream", string), (Throwable)iOException);
        }
    }

    private static void pipe(final InputStream inputStream, final PrintStream printStream) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        printStream.write(byArray, 0, n);
                        n = inputStream.read(byArray);
                    }
                }
                catch (IOException iOException) {}
            }
        }).start();
    }

    public String getCommandAsString() {
        String string = "";
        for (String string2 : this.commands) {
            string = String.valueOf(string) + " " + string2;
        }
        return string;
    }

    public void logOutput() {
        logger.info("Output from command " + this.getCommandAsString());
        if (this.outputLines != null) {
            for (String string : this.outputLines) {
                logger.info(string);
            }
        }
    }

    public static enum LOGOPTION {
        NEVER,
        ALWAYS,
        ONLY_ON_ERROR;

    }
}

