/*
 * Decompiled with CFR 0.152.
 */
package gda.doe;

import gda.doe.TestBean;
import gda.doe.TestContainer;
import gda.doe.TestContainerContainer;
import gda.doe.TestContainerList;
import gda.doe.TestList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Test;
import uk.ac.gda.doe.DOEUtils;

public class DOETest {
    @Test
    public void testFieldWeightings() throws Throwable {
        int n;
        int n2;
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        List<? extends Object> list = DOEUtils.expand(testBean);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(27);
        int n3 = 1;
        while (n3 < 4) {
            n2 = 1;
            while (n2 < 4) {
                n = 1;
                while (n < 4) {
                    arrayList.add(new TestBean(String.valueOf(n), String.valueOf(n2) + ".0", String.valueOf(n3) + ".0"));
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        if (!list.equals(arrayList)) {
            throw new Exception("Expansion did not process weightings correctly!");
        }
        arrayList.clear();
        n3 = 1;
        while (n3 < 4) {
            n2 = 1;
            while (n2 < 4) {
                n = 1;
                while (n < 4) {
                    arrayList.add(new TestBean(String.valueOf(n3), String.valueOf(n2) + ".0", String.valueOf(n) + ".0"));
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        if (list.equals(arrayList)) {
            throw new Exception("Expansion did not process weightings correctly!");
        }
    }

    @Test
    public void testNested1() throws Throwable {
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        TestContainer testContainer = new TestContainer();
        testContainer.setTestBean(testBean);
        List<? extends Object> list = DOEUtils.expand(testContainer);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNested2() throws Throwable {
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        TestContainer testContainer = new TestContainer();
        testContainer.setTestBean(testBean);
        TestContainerContainer testContainerContainer = new TestContainerContainer();
        testContainerContainer.setTestContainer(testContainer);
        List<? extends Object> list = DOEUtils.expand(testContainerContainer);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList1() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<? extends Object> list = DOEUtils.expand(testList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList2() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0");
        testBean.setJ("4.0");
        testBean.setK("4.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<? extends Object> list = DOEUtils.expand(testList);
        for (Object object : list) {
            TestList testList2 = (TestList)object;
            if (testList2.getTestBeans().size() == 2) continue;
            throw new Exception("There should only be 2 items in the TestList object.");
        }
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList3() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0;4.5;1.0");
        testBean.setJ("4.0;4.5;1.0");
        testBean.setK("4.0;4.5;1.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<? extends Object> list = DOEUtils.expand(testList);
        for (Object object : list) {
            TestList testList2 = (TestList)object;
            if (testList2.getTestBeans().size() != 2) {
                throw new Exception("There should only be 2 items in the TestList object.");
            }
            for (TestBean testBean2 : testList2.getTestBeans()) {
                if (DOEUtils.isDOE(testBean2.getI())) {
                    throw new Exception("TestBean found not to have expanded range! " + testBean2);
                }
                if (DOEUtils.isDOE(testBean2.getJ())) {
                    throw new Exception("TestBean found not to have expanded range! " + testBean2);
                }
                if (!DOEUtils.isDOE(testBean2.getK())) continue;
                throw new Exception("TestBean found not to have expanded range! " + testBean2);
            }
        }
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedList4() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0;5;1.0");
        testBean.setJ("4.0;5;1.0");
        testBean.setK("4.0;5;1.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<? extends Object> list = DOEUtils.expand(testList);
        for (Object object : list) {
            TestList testList2 = (TestList)object;
            if (testList2.getTestBeans().size() == 2) continue;
            throw new Exception("There should only be 2 items in the TestList object.");
        }
        if (list.size() != 216) {
            throw new Exception("Three parameters, each with three values should give 216 experiments!");
        }
    }

    @Test
    public void testNestedList5() throws Throwable {
        ArrayList<TestBean> arrayList = new ArrayList<TestBean>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("4.0");
        testBean.setJ("4.0");
        testBean.setK("4.0");
        arrayList.add(testBean);
        testBean = new TestBean();
        testBean.setI("5.0");
        testBean.setJ("5.0");
        testBean.setK("5.0");
        arrayList.add(testBean);
        TestList testList = new TestList();
        testList.setTestBeans(arrayList);
        List<? extends Object> list = DOEUtils.expand(testList);
        for (Object object : list) {
            TestList testList2 = (TestList)object;
            if (testList2.getTestBeans().size() == 3) continue;
            throw new Exception("There should only be 3 items in the TestList object.");
        }
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testNestedListContainer() throws Throwable {
        ArrayList<TestContainer> arrayList = new ArrayList<TestContainer>(2);
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        TestContainer testContainer = new TestContainer();
        testContainer.setTestBean(testBean);
        arrayList.add(testContainer);
        TestContainerList testContainerList = new TestContainerList();
        testContainerList.setTestContainers(arrayList);
        List<? extends Object> list = DOEUtils.expand(testContainerList);
        if (list.size() != 27) {
            throw new Exception("Three parameters, each with three values should give 27 experiments!");
        }
    }

    @Test
    public void testInt() throws Throwable {
        TestBean testBean = new TestBean();
        testBean.setI("1;3;1");
        testBean.setJ("1;3;1");
        testBean.setK("1;3;1");
        List<? extends Object> list = DOEUtils.expand(testBean);
        TestBean testBean2 = (TestBean)list.get(0);
        if (testBean2.getI().equals("1.0")) {
            throw new Exception("i is marked as an integer and it should be '1' not '1.0' for the first bean.");
        }
    }

    @Test
    public void testPatterns() throws Throwable {
        Pattern pattern = DOEUtils.getListPattern(5, null);
        if (pattern.matcher("3.22").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("295.0, 300.12").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33,5.44").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3,4.3,5.4454").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3, 4.3, 5.4454, 4").matches()) {
            throw new Exception();
        }
        pattern = DOEUtils.getListPattern(5, "fred");
        if (pattern.matcher("3.22 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33,5.44 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3,4.3,5.4454 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3, 4.3, 5.4454, 4 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3.22,4.33 fred").matches()) {
            throw new Exception();
        }
        if (!DOEUtils.removeUnit("3.22,4.33 fred", "fred").trim().equals("3.22,4.33")) {
            throw new Exception();
        }
        pattern = DOEUtils.getRangePattern(5, "fred");
        if (pattern.matcher("3.22 fred").matches()) {
            throw new Exception();
        }
        if (pattern.matcher("3.22,4.33 fred").matches()) {
            throw new Exception();
        }
        if (pattern.matcher("3.22,4.33,5.44 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("4.3;5.4454;1 fred").matches()) {
            throw new Exception();
        }
        if (!pattern.matcher("3; 4.3; 0.1 fred").matches()) {
            throw new Exception();
        }
    }
}

