/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyShiftLeft;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.codefolding.PyEditProjection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySourceViewer
extends ProjectionViewer {
    private WeakReference<PyEdit> projection;
    private boolean isInToggleCompletionStyle;
    private PyAutoIndentStrategy pyAutoIndentStrategy;

    public PySourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, PyEditProjection projection) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.projection = new WeakReference<PyEdit>((PyEdit)projection);
    }

    public void setInToggleCompletionStyle(boolean b) {
        this.isInToggleCompletionStyle = b;
    }

    public boolean getIsInToggleCompletionStyle() {
        return this.isInToggleCompletionStyle;
    }

    public PyEdit getEdit() {
        return (PyEdit)this.projection.get();
    }

    public List<MarkerAnnotationAndPosition> getMarkersAtLine(int markerLine, String markerType) {
        ArrayList<MarkerAnnotationAndPosition> markers = new ArrayList<MarkerAnnotationAndPosition>();
        IDocumentProvider documentProvider = this.getEdit().getDocumentProvider();
        if (documentProvider == null) {
            return markers;
        }
        IEditorInput editorInput = this.getEdit().getEditorInput();
        if (editorInput == null) {
            return markers;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)editorInput);
        if (annotationModel == null) {
            return markers;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            return markers;
        }
        int lineStartOffset = -1;
        int lineEndOffset = -1;
        try {
            lineStartOffset = document.getLineOffset(markerLine);
            lineEndOffset = lineStartOffset + document.getLineLength(markerLine);
        }
        catch (BadLocationException badLocationException) {
            return markers;
        }
        Iterator<MarkerAnnotationAndPosition> it = this.getMarkerIterator();
        while (it.hasNext()) {
            String type;
            MarkerAnnotationAndPosition annotation = it.next();
            Position position = annotation.position;
            int offset = position.getOffset();
            if (offset < lineStartOffset || offset > lineEndOffset) continue;
            IMarker marker = annotation.markerAnnotation.getMarker();
            try {
                type = marker.getType();
            }
            catch (CoreException coreException) {
                continue;
            }
            if (markerType != null && !markerType.equals(type)) continue;
            markers.add(annotation);
        }
        return markers;
    }

    public Iterator<MarkerAnnotationAndPosition> getMarkerIterator() {
        final IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            final Iterator annotationIterator = annotationModel.getAnnotationIterator();
            return new Iterator<MarkerAnnotationAndPosition>(){
                private MarkerAnnotationAndPosition marker;

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    while (annotationIterator.hasNext()) {
                        if (this.marker == null) ** GOTO lbl8
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            object = annotationIterator.next();
                            if (!(object instanceof MarkerAnnotation) || (m = (MarkerAnnotation)object).isMarkedDeleted()) continue;
                            this.marker = new MarkerAnnotationAndPosition(m, annotationModel.getPosition((Annotation)m));
                            return true;
lbl8:
                            // 2 sources

                            ** while (annotationIterator.hasNext())
                        }
lbl9:
                        // 1 sources

                    }
                    return false;
                }

                @Override
                public MarkerAnnotationAndPosition next() {
                    this.hasNext();
                    MarkerAnnotationAndPosition m = this.marker;
                    this.marker = null;
                    return m;
                }

                @Override
                public void remove() {
                    throw new RuntimeException("not implemented");
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.next();
                }
            };
        }
        return new Iterator<MarkerAnnotationAndPosition>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public MarkerAnnotationAndPosition next() {
                return null;
            }

            @Override
            public void remove() {
                throw new RuntimeException("not implemented");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.next();
            }
        };
    }

    public void doOperation(int operation) {
        if (operation == 9) {
            this.doShiftLeft();
            return;
        }
        super.doOperation(operation);
    }

    private void doShiftLeft() {
        if (this.fUndoManager != null) {
            this.fUndoManager.beginCompoundChange();
        }
        IDocument d = this.getDocument();
        DocumentRewriteSession rewriteSession = null;
        try {
            if (d instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)d;
                rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            }
            PyShiftLeft pyShiftLeft = new PyShiftLeft();
            pyShiftLeft.setEditor((IEditorPart)this.getEdit());
            pyShiftLeft.run(null);
        }
        finally {
            if (d instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)d;
                extension.stopRewriteSession(rewriteSession);
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }

    protected void customizeDocumentCommand(DocumentCommand command) {
        if (this.pyAutoIndentStrategy == null) {
            this.pyAutoIndentStrategy = this.getEdit().getAutoEditStrategy();
        }
        boolean blockSelection = false;
        try {
            blockSelection = this.getTextWidget().getBlockSelection();
        }
        catch (Throwable throwable) {}
        this.pyAutoIndentStrategy.setBlockSelection(blockSelection);
        super.customizeDocumentCommand(command);
    }
}

