/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    private static final char DIGIT_KEY = '#';
    private static final char LITERAL_KEY = '\'';
    private static final char UPPERCASE_KEY = 'U';
    private static final char LOWERCASE_KEY = 'L';
    private static final char ALPHA_NUMERIC_KEY = 'A';
    private static final char CHARACTER_KEY = '?';
    private static final char ANYTHING_KEY = '*';
    private static final char HEX_KEY = 'H';
    private static final MaskCharacter[] EmptyMaskChars = new MaskCharacter[0];
    private String mask;
    private transient MaskCharacter[] maskChars;
    private String validCharacters;
    private String invalidCharacters;
    private String placeholderString;
    private char placeholder;
    private boolean containsLiteralChars;

    public MaskFormatter() {
        this.setAllowsInvalid(false);
        this.containsLiteralChars = true;
        this.maskChars = EmptyMaskChars;
        this.placeholder = (char)32;
    }

    public MaskFormatter(String string) throws ParseException {
        this();
        this.setMask(string);
    }

    public void setMask(String string) throws ParseException {
        this.mask = string;
        this.updateInternalMask();
    }

    public String getMask() {
        return this.mask;
    }

    public void setValidCharacters(String string) {
        this.validCharacters = string;
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public void setInvalidCharacters(String string) {
        this.invalidCharacters = string;
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public void setPlaceholder(String string) {
        this.placeholderString = string;
    }

    public String getPlaceholder() {
        return this.placeholderString;
    }

    public void setPlaceholderCharacter(char c) {
        this.placeholder = c;
    }

    public char getPlaceholderCharacter() {
        return this.placeholder;
    }

    public void setValueContainsLiteralCharacters(boolean bl) {
        this.containsLiteralChars = bl;
    }

    public boolean getValueContainsLiteralCharacters() {
        return this.containsLiteralChars;
    }

    public Object stringToValue(String string) throws ParseException {
        return this.stringToValue(string, true);
    }

    public String valueToString(Object object) throws ParseException {
        String string = object == null ? "" : object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getPlaceholder();
        int[] nArray = new int[]{0};
        this.append(stringBuffer, string, nArray, string2, this.maskChars);
        return stringBuffer.toString();
    }

    public void install(JFormattedTextField jFormattedTextField) {
        super.install(jFormattedTextField);
        if (jFormattedTextField != null) {
            Object object = jFormattedTextField.getValue();
            try {
                this.stringToValue(this.valueToString(object));
            }
            catch (ParseException parseException) {
                this.setEditValid(false);
            }
        }
    }

    private Object stringToValue(String string, boolean bl) throws ParseException {
        int n = -1;
        n = this.getInvalidOffset(string, bl);
        if (n == -1) {
            if (!this.getValueContainsLiteralCharacters()) {
                string = this.stripLiteralChars(string);
            }
            return super.stringToValue(string);
        }
        throw new ParseException("stringToValue passed invalid value", n);
    }

    private int getInvalidOffset(String string, boolean bl) {
        int n = string.length();
        if (n != this.getMaxLength()) {
            return n;
        }
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (this.isValidCharacter(i, c) || !bl && this.isPlaceholder(i, c)) continue;
            return i;
        }
        return -1;
    }

    private void append(StringBuffer stringBuffer, String string, int[] nArray, String string2, MaskCharacter[] maskCharacterArray) throws ParseException {
        int n = maskCharacterArray.length;
        for (int i = 0; i < n; ++i) {
            maskCharacterArray[i].append(stringBuffer, string, nArray, string2);
        }
    }

    private void updateInternalMask() throws ParseException {
        ArrayList<MaskCharacter> arrayList;
        String string = this.getMask();
        ArrayList<MaskCharacter> arrayList2 = arrayList = new ArrayList<MaskCharacter>();
        if (string != null) {
            int n = string.length();
            block10: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '#': {
                        arrayList2.add(new DigitMaskCharacter());
                        continue block10;
                    }
                    case '\'': {
                        if (++i >= n) continue block10;
                        c = string.charAt(i);
                        arrayList2.add(new LiteralCharacter(c));
                        continue block10;
                    }
                    case 'U': {
                        arrayList2.add(new UpperCaseCharacter());
                        continue block10;
                    }
                    case 'L': {
                        arrayList2.add(new LowerCaseCharacter());
                        continue block10;
                    }
                    case 'A': {
                        arrayList2.add(new AlphaNumericCharacter());
                        continue block10;
                    }
                    case '?': {
                        arrayList2.add(new CharCharacter());
                        continue block10;
                    }
                    case '*': {
                        arrayList2.add(new MaskCharacter());
                        continue block10;
                    }
                    case 'H': {
                        arrayList2.add(new HexCharacter());
                        continue block10;
                    }
                    default: {
                        arrayList2.add(new LiteralCharacter(c));
                    }
                }
            }
        }
        if (arrayList.size() == 0) {
            this.maskChars = EmptyMaskChars;
        } else {
            this.maskChars = new MaskCharacter[arrayList.size()];
            arrayList.toArray(this.maskChars);
        }
    }

    private MaskCharacter getMaskCharacter(int n) {
        if (n >= this.maskChars.length) {
            return null;
        }
        return this.maskChars[n];
    }

    private boolean isPlaceholder(int n, char c) {
        return this.getPlaceholderCharacter() == c;
    }

    private boolean isValidCharacter(int n, char c) {
        return this.getMaskCharacter(n).isValidCharacter(c);
    }

    private boolean isLiteral(int n) {
        return this.getMaskCharacter(n).isLiteral();
    }

    private int getMaxLength() {
        return this.maskChars.length;
    }

    private char getLiteral(int n) {
        return this.getMaskCharacter(n).getChar('\u0000');
    }

    private char getCharacter(int n, char c) {
        return this.getMaskCharacter(n).getChar(c);
    }

    private String stripLiteralChars(String string) {
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (!this.isLiteral(i)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                if (i > 0) {
                    stringBuffer.append(string.substring(0, i));
                }
                n = i + 1;
            } else if (n != i) {
                stringBuffer.append(string.substring(n, i));
            }
            n = i + 1;
        }
        if (stringBuffer == null) {
            return string;
        }
        if (n != string.length()) {
            if (stringBuffer == null) {
                return string.substring(n);
            }
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.updateInternalMask();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    boolean isNavigatable(int n) {
        if (!this.getAllowsInvalid()) {
            return n < this.getMaxLength() && !this.isLiteral(n);
        }
        return true;
    }

    boolean isValidEdit(DefaultFormatter.ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            String string = this.getReplaceString(replaceHolder.offset, replaceHolder.length, replaceHolder.text);
            try {
                replaceHolder.value = this.stringToValue(string, false);
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    boolean canReplace(DefaultFormatter.ReplaceHolder replaceHolder) {
        if (!this.getAllowsInvalid()) {
            int n;
            StringBuffer stringBuffer = null;
            String string = replaceHolder.text;
            int n2 = n = string != null ? string.length() : 0;
            if (n == 0 && replaceHolder.length == 1 && this.getFormattedTextField().getSelectionStart() != replaceHolder.offset) {
                while (replaceHolder.offset > 0 && this.isLiteral(replaceHolder.offset)) {
                    --replaceHolder.offset;
                }
            }
            int n3 = Math.min(this.getMaxLength() - replaceHolder.offset, Math.max(n, replaceHolder.length));
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (n4 < n && this.isValidCharacter(replaceHolder.offset + i, string.charAt(n4))) {
                    char c = string.charAt(n4);
                    if (c != this.getCharacter(replaceHolder.offset + i, c) && stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        if (n4 > 0) {
                            stringBuffer.append(string.substring(0, n4));
                        }
                    }
                    if (stringBuffer != null) {
                        stringBuffer.append(this.getCharacter(replaceHolder.offset + i, c));
                    }
                    ++n4;
                    continue;
                }
                if (this.isLiteral(replaceHolder.offset + i)) {
                    if (stringBuffer != null) {
                        stringBuffer.append(this.getLiteral(replaceHolder.offset + i));
                        if (n4 >= n) continue;
                        n3 = Math.min(n3 + 1, this.getMaxLength() - replaceHolder.offset);
                        continue;
                    }
                    if (n4 > 0) {
                        stringBuffer = new StringBuffer(n3);
                        stringBuffer.append(string.substring(0, n4));
                        stringBuffer.append(this.getLiteral(replaceHolder.offset + i));
                        if (n4 < n) {
                            n3 = Math.min(n3 + 1, this.getMaxLength() - replaceHolder.offset);
                            continue;
                        }
                        if (replaceHolder.cursorPosition != -1) continue;
                        replaceHolder.cursorPosition = replaceHolder.offset + i;
                        continue;
                    }
                    ++replaceHolder.offset;
                    --replaceHolder.length;
                    --i;
                    --n3;
                    continue;
                }
                if (n4 >= n) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        if (string != null) {
                            stringBuffer.append(string);
                        }
                    }
                    stringBuffer.append(this.getPlaceholderCharacter());
                    if (n <= 0 || replaceHolder.cursorPosition != -1) continue;
                    replaceHolder.cursorPosition = replaceHolder.offset + i;
                    continue;
                }
                return false;
            }
            if (stringBuffer != null) {
                replaceHolder.text = stringBuffer.toString();
            } else if (string != null && replaceHolder.offset + n > this.getMaxLength()) {
                replaceHolder.text = string.substring(0, this.getMaxLength() - replaceHolder.offset);
            }
            if (this.getOverwriteMode() && replaceHolder.text != null) {
                replaceHolder.length = replaceHolder.text.length();
            }
        }
        return super.canReplace(replaceHolder);
    }

    private class AlphaNumericCharacter
    extends MaskCharacter {
        private AlphaNumericCharacter() {
        }

        public boolean isValidCharacter(char c) {
            return Character.isLetterOrDigit(c) && super.isValidCharacter(c);
        }
    }

    private class CharCharacter
    extends MaskCharacter {
        private CharCharacter() {
        }

        public boolean isValidCharacter(char c) {
            return Character.isLetter(c) && super.isValidCharacter(c);
        }
    }

    private class DigitMaskCharacter
    extends MaskCharacter {
        private DigitMaskCharacter() {
        }

        public boolean isValidCharacter(char c) {
            return Character.isDigit(c) && super.isValidCharacter(c);
        }
    }

    private class HexCharacter
    extends MaskCharacter {
        private HexCharacter() {
        }

        public boolean isValidCharacter(char c) {
            return (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F') && super.isValidCharacter(c);
        }

        public char getChar(char c) {
            if (Character.isDigit(c)) {
                return c;
            }
            return Character.toUpperCase(c);
        }
    }

    private class LiteralCharacter
    extends MaskCharacter {
        private char fixedChar;

        public LiteralCharacter(char c) {
            this.fixedChar = c;
        }

        public boolean isLiteral() {
            return true;
        }

        public char getChar(char c) {
            return this.fixedChar;
        }
    }

    private class LowerCaseCharacter
    extends MaskCharacter {
        private LowerCaseCharacter() {
        }

        public boolean isValidCharacter(char c) {
            return Character.isLetter(c) && super.isValidCharacter(c);
        }

        public char getChar(char c) {
            return Character.toLowerCase(c);
        }
    }

    private class MaskCharacter {
        private MaskCharacter() {
        }

        public boolean isLiteral() {
            return false;
        }

        public boolean isValidCharacter(char c) {
            if (this.isLiteral()) {
                return this.getChar(c) == c;
            }
            c = this.getChar(c);
            String string = MaskFormatter.this.getValidCharacters();
            if (string != null && string.indexOf(c) == -1) {
                return false;
            }
            string = MaskFormatter.this.getInvalidCharacters();
            return string == null || string.indexOf(c) == -1;
        }

        public char getChar(char c) {
            return c;
        }

        public void append(StringBuffer stringBuffer, String string, int[] nArray, String string2) throws ParseException {
            char c;
            boolean bl = nArray[0] < string.length();
            char c2 = c = bl ? string.charAt(nArray[0]) : (char)'\u0000';
            if (this.isLiteral()) {
                stringBuffer.append(this.getChar(c));
                if (MaskFormatter.this.getValueContainsLiteralCharacters()) {
                    if (bl && c != this.getChar(c)) {
                        throw new ParseException("Invalid character: " + c, nArray[0]);
                    }
                    nArray[0] = nArray[0] + 1;
                }
            } else if (nArray[0] >= string.length()) {
                if (string2 != null && nArray[0] < string2.length()) {
                    stringBuffer.append(string2.charAt(nArray[0]));
                } else {
                    stringBuffer.append(MaskFormatter.this.getPlaceholderCharacter());
                }
                nArray[0] = nArray[0] + 1;
            } else if (this.isValidCharacter(c)) {
                stringBuffer.append(this.getChar(c));
                nArray[0] = nArray[0] + 1;
            } else {
                throw new ParseException("Invalid character: " + c, nArray[0]);
            }
        }
    }

    private class UpperCaseCharacter
    extends MaskCharacter {
        private UpperCaseCharacter() {
        }

        public boolean isValidCharacter(char c) {
            return Character.isLetter(c) && super.isValidCharacter(c);
        }

        public char getChar(char c) {
            return Character.toUpperCase(c);
        }
    }
}

