/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.StringUtilities;

public class Vertex
extends Location {
    private Vertex _linked;
    private LinkedList _ports;

    public Vertex(Workspace workspace) {
        super(workspace);
        this._elementName = "vertex";
    }

    public Vertex(Relation container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._elementName = "vertex";
    }

    public void addLinkedPort(Port port) {
        if (this._ports == null) {
            this._ports = new LinkedList();
        }
        this._ports.add(port);
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        if (this._isMoMLSuppressed(depth)) {
            return;
        }
        String value = this.getExpression();
        String valueTerm = "";
        if (value != null && !value.equals("")) {
            valueTerm = " value=\"" + StringUtilities.escapeForXML(value) + "\"";
        }
        output.write(String.valueOf(Vertex._getIndentPrefix(depth)) + "<" + this._elementName + " name=\"" + name + "\"" + valueTerm + ">\n");
        this._exportMoMLContents(output, depth + 1);
        output.write(String.valueOf(Vertex._getIndentPrefix(depth)) + "</" + this._elementName + ">\n");
    }

    public Vertex getLinkedVertex() {
        return this._linked;
    }

    public List linkedPorts() {
        return this._ports;
    }

    public void removeLinkedPort(Port port) {
        if (this._ports != null) {
            this._ports.remove(port);
        }
    }

    public void setLinkedVertex(Vertex vertex) {
        this._linked = vertex;
    }

    public String toString() {
        return super.toString();
    }

    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        super._exportMoMLContents(output, depth);
        if (this._linked != null) {
            output.write(Vertex._getIndentPrefix(depth));
            output.write("<pathTo=\"" + this._linked.getName() + "\"/>\n");
        }
    }
}

