/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Fraction;

public class FractionMatrixMath {
    private FractionMatrixMath() {
    }

    public static final Fraction[][] add(Fraction[][] matrix, Fraction z) {
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix)][FractionMatrixMath._columns(matrix)];
        int i = 0;
        while (i < FractionMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < FractionMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j].add(z);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] add(Fraction[][] matrix1, Fraction[][] matrix2) {
        FractionMatrixMath._checkSameDimension("add", matrix1, matrix2);
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix1)][FractionMatrixMath._columns(matrix1)];
        int i = 0;
        while (i < FractionMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < FractionMatrixMath._columns(matrix1)) {
                returnValue[i][j] = matrix1[i][j].add(matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] allocCopy(Fraction[][] matrix) {
        return FractionMatrixMath.crop(matrix, 0, 0, FractionMatrixMath._rows(matrix), FractionMatrixMath._columns(matrix));
    }

    public static final Fraction[][] crop(Fraction[][] matrix, int rowStart, int colStart, int rowSpan, int colSpan) {
        Fraction[][] returnValue = new Fraction[rowSpan][colSpan];
        int i = 0;
        while (i < rowSpan) {
            System.arraycopy(matrix[rowStart + i], colStart, returnValue[i], 0, colSpan);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] diag(Fraction[] array) {
        int n = array.length;
        Fraction[][] returnValue = new Fraction[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                returnValue[i][j] = i == j ? array[i] : new Fraction(0, 1);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] divide(Fraction[][] matrix, Fraction z) {
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix)][FractionMatrixMath._columns(matrix)];
        int i = 0;
        while (i < FractionMatrixMath._rows(matrix)) {
            int j = 0;
            while (j < FractionMatrixMath._columns(matrix)) {
                returnValue[i][j] = matrix[i][j].divide(z);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] divideElements(Fraction[][] matrix1, Fraction[][] matrix2) {
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        FractionMatrixMath._checkSameDimension("divideElements", matrix1, matrix2);
        Fraction[][] returnValue = new Fraction[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j].divide(matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] fromMatrixToArray(Fraction[][] matrix) {
        return FractionMatrixMath.fromMatrixToArray(matrix, FractionMatrixMath._rows(matrix), FractionMatrixMath._columns(matrix));
    }

    public static final Fraction[] fromMatrixToArray(Fraction[][] matrix, int maxRow, int maxCol) {
        Fraction[] returnValue = new Fraction[maxRow * maxCol];
        int i = 0;
        while (i < maxRow) {
            System.arraycopy(matrix[i], 0, returnValue, i * maxCol, maxCol);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] identity(int dim) {
        Fraction[][] returnValue = new Fraction[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                if (i == j) {
                    returnValue[i][i] = new Fraction(1, 1);
                } else {
                    returnValue[i][j] = new Fraction(0, 1);
                }
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] multiply(Fraction[][] matrix, Fraction scaleFactor) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        Fraction[][] returnValue = new Fraction[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j].multiply(scaleFactor);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] multiply(Fraction[] array, Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        if (rows != array.length) {
            throw new IllegalArgumentException("preMultiply : array does not have the same number of elements (" + array.length + ") as the number of rows " + "of the matrix (" + rows + ")");
        }
        Fraction[] returnValue = new Fraction[columns];
        int i = 0;
        while (i < columns) {
            Fraction sum = new Fraction(0, 1);
            int j = 0;
            while (j < rows) {
                sum = sum.add(matrix[j][i].multiply(array[j]));
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] multiply(Fraction[][] matrix, Fraction[] array) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        if (columns != array.length) {
            throw new IllegalArgumentException("postMultiply() : array does not have the same number of elements (" + array.length + ") as the number of " + "columns of the matrix (" + columns + ")");
        }
        Fraction[] returnValue = new Fraction[rows];
        int i = 0;
        while (i < rows) {
            Fraction sum = new Fraction(0, 1);
            int j = 0;
            while (j < columns) {
                sum = sum.add(matrix[i][j].multiply(array[j]));
                ++j;
            }
            returnValue[i] = sum;
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] multiply(Fraction[][] matrix1, Fraction[][] matrix2) throws ArithmeticException {
        if (FractionMatrixMath._columns(matrix1) != FractionMatrixMath._rows(matrix2)) {
            throw new ArithmeticException("Number of columns (" + FractionMatrixMath._columns(matrix1) + ") of matrix1 does note equal number of rows (" + FractionMatrixMath._rows(matrix2) + ") of matrix2.");
        }
        Fraction[][] returnValue = new Fraction[FractionMatrixMath._rows(matrix1)][FractionMatrixMath._columns(matrix2)];
        int i = 0;
        while (i < FractionMatrixMath._rows(matrix1)) {
            int j = 0;
            while (j < FractionMatrixMath._columns(matrix2)) {
                Fraction sum = new Fraction(0, 1);
                int k = 0;
                while (k < FractionMatrixMath._columns(matrix1)) {
                    sum = sum.add(matrix1[i][k].multiply(matrix2[k][j]));
                    ++k;
                }
                returnValue[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] multiplyElements(Fraction[][] matrix1, Fraction[][] matrix2) {
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        FractionMatrixMath._checkSameDimension("multiplyElements", matrix1, matrix2);
        Fraction[][] returnValue = new Fraction[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j].multiply(matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] negative(Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        Fraction[][] returnValue = new Fraction[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j].negate();
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] subtract(Fraction[][] matrix1, Fraction[][] matrix2) {
        FractionMatrixMath._checkSameDimension("subtract", matrix1, matrix2);
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        Fraction[][] returnValue = new Fraction[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix1[i][j].subtract(matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction sum(Fraction[][] matrix) {
        Fraction sum = new Fraction(0, 1);
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                sum = sum.add(matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static final double[][] toDoubleMatrix(Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        double[][] returnValue = new double[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[i][j] = matrix[i][j].toDouble();
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[][] toMatrixFromArray(Fraction[] array, int rows, int cols) {
        Fraction[][] returnValue = new Fraction[rows][cols];
        int i = 0;
        while (i < rows) {
            System.arraycopy(array, i * cols, returnValue[i], 0, cols);
            ++i;
        }
        return returnValue;
    }

    public static final String toString(Fraction[][] matrix) {
        return FractionMatrixMath.toString(matrix, ", ", "{", "}", "{", ", ", "}");
    }

    public static final String toString(Fraction[][] matrix, String elementDelimiter, String matrixBegin, String matrixEnd, String vectorBegin, String vectorDelimiter, String vectorEnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(matrixBegin);
        int i = 0;
        while (i < FractionMatrixMath._rows(matrix)) {
            sb.append(vectorBegin);
            int j = 0;
            while (j < FractionMatrixMath._columns(matrix)) {
                sb.append(matrix[i][j].toString());
                if (j < FractionMatrixMath._columns(matrix) - 1) {
                    sb.append(elementDelimiter);
                }
                ++j;
            }
            sb.append(vectorEnd);
            if (i < FractionMatrixMath._rows(matrix) - 1) {
                sb.append(vectorDelimiter);
            }
            ++i;
        }
        sb.append(matrixEnd);
        return new String(sb);
    }

    public static final Fraction trace(Fraction[][] matrix) {
        int dim = FractionMatrixMath._checkSquare("trace", matrix);
        Fraction sum = new Fraction(0, 1);
        int i = 0;
        while (i < dim) {
            sum = sum.add(matrix[i][i]);
            ++i;
        }
        return sum;
    }

    public static final Fraction[][] transpose(Fraction[][] matrix) {
        int rows = FractionMatrixMath._rows(matrix);
        int columns = FractionMatrixMath._columns(matrix);
        Fraction[][] returnValue = new Fraction[columns][rows];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                returnValue[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    protected static final void _checkSameDimension(String caller, Fraction[][] matrix1, Fraction[][] matrix2) {
        int rows = FractionMatrixMath._rows(matrix1);
        int columns = FractionMatrixMath._columns(matrix1);
        if (rows != FractionMatrixMath._rows(matrix2) || columns != FractionMatrixMath._columns(matrix2)) {
            throw new IllegalArgumentException("ptolemy.math.FractionMatrixMath." + caller + "() : one matrix " + FractionMatrixMath._dimensionString(matrix1) + " is not the same size as another matrix " + FractionMatrixMath._dimensionString(matrix2) + ".");
        }
    }

    protected static final int _checkSquare(String caller, Fraction[][] matrix) {
        if (FractionMatrixMath._rows(matrix) != FractionMatrixMath._columns(matrix)) {
            throw new IllegalArgumentException("ptolemy.math.FractionMatrixMath." + caller + "() : matrix argument " + FractionMatrixMath._dimensionString(matrix) + " is not a square matrix.");
        }
        return FractionMatrixMath._rows(matrix);
    }

    protected static final int _columns(Fraction[][] matrix) {
        return matrix[0].length;
    }

    protected static final String _dimensionString(Fraction[][] matrix) {
        return "[" + FractionMatrixMath._rows(matrix) + " x " + FractionMatrixMath._columns(matrix) + "]";
    }

    protected static final int _rows(Fraction[][] matrix) {
        return matrix.length;
    }
}

