/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

public class Complex {
    public final double real;
    public final double imag;
    public static double EPSILON = 1.0E-9;
    public static final Complex NEGATIVE_INFINITY = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    public static final Complex POSITIVE_INFINITY = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complex(double real) {
        this.real = real;
        this.imag = 0.0;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public static double abs(Complex x) {
        return x.magnitude();
    }

    public final Complex acos() {
        Complex c1 = new Complex(1.0 - this.real * this.real + this.imag * this.imag, -2.0 * this.real * this.imag);
        Complex c2 = c1.sqrt();
        Complex c3 = new Complex(this.real - c2.imag, this.imag + c2.real);
        Complex c4 = c3.log();
        return new Complex(c4.imag, -c4.real);
    }

    public static Complex acos(Complex z) {
        return z.acos();
    }

    public final Complex acosh() {
        Complex c1 = new Complex(this.real * this.real - this.imag * this.imag - 1.0, 2.0 * this.real * this.imag);
        Complex c2 = c1.sqrt();
        Complex c3 = this.add(c2);
        return c3.log();
    }

    public static Complex acosh(Complex z) {
        return z.acosh();
    }

    public final Complex add(Complex z) {
        return new Complex(this.real + z.real, this.imag + z.imag);
    }

    public final double angle() {
        return Math.atan2(this.imag, this.real);
    }

    public static double angle(Complex z) {
        return z.angle();
    }

    public final Complex asin() {
        Complex c1 = new Complex(1.0 - this.real * this.real + this.imag * this.imag, -2.0 * this.real * this.imag);
        Complex c2 = c1.sqrt();
        Complex c3 = new Complex(c2.real - this.imag, c2.imag + this.real);
        Complex c4 = c3.log();
        return new Complex(c4.imag, -c4.real);
    }

    public static Complex asin(Complex z) {
        return z.asin();
    }

    public final Complex asinh() {
        Complex c1 = new Complex(1.0 + this.real * this.real - this.imag * this.imag, 2.0 * this.real * this.imag);
        Complex c2 = c1.sqrt();
        Complex c3 = this.add(c2);
        return c3.log();
    }

    public static Complex asinh(Complex z) {
        return z.asinh();
    }

    public final Complex atan() {
        double denominator = this.real * this.real + (this.imag + 1.0) * (this.imag + 1.0);
        Complex c1 = new Complex((-this.real * this.real - this.imag * this.imag + 1.0) / denominator, 2.0 * this.real / denominator);
        Complex c2 = c1.log();
        return new Complex(c2.imag * 0.5, -c2.real * 0.5);
    }

    public static Complex atan(Complex z) {
        return z.atan();
    }

    public final Complex atanh() {
        double denominator = (1.0 - this.real) * (1.0 - this.real) + this.imag * this.imag;
        Complex c1 = new Complex((-this.real * this.real - this.imag * this.imag + 1.0) / denominator, 2.0 * this.imag / denominator);
        Complex c2 = c1.log();
        return new Complex(c2.real * 0.5, c2.imag * 0.5);
    }

    public static Complex atanh(Complex z) {
        return z.atanh();
    }

    public final Complex conjugate() {
        if (this.imag != 0.0) {
            return new Complex(this.real, -this.imag);
        }
        return new Complex(this.real, this.imag);
    }

    public static final Complex conjugate(Complex z) {
        return z.conjugate();
    }

    public static final Complex conjugate(double z) {
        return new Complex(z, 0.0);
    }

    public final Complex cos() {
        Complex c1 = new Complex(-this.imag, this.real);
        Complex c2 = c1.exp();
        Complex c3 = new Complex(this.imag, -this.real);
        Complex c4 = c2.add(c3.exp());
        return new Complex(c4.real * 0.5, c4.imag * 0.5);
    }

    public static Complex cos(Complex z) {
        return z.cos();
    }

    public final Complex cosh() {
        Complex c1 = this.exp();
        Complex c2 = new Complex(-this.real, -this.imag);
        Complex c3 = c1.add(c2.exp());
        return new Complex(c3.real * 0.5, c3.imag * 0.5);
    }

    public static Complex cosh(Complex z) {
        return z.cosh();
    }

    public final Complex cot() {
        Complex c1 = this.tan();
        return c1.reciprocal();
    }

    public static Complex cot(Complex z) {
        return z.cot();
    }

    public Complex csc() {
        Complex c1 = this.sin();
        return c1.reciprocal();
    }

    public static Complex csc(Complex z) {
        return z.csc();
    }

    public final Complex divide(Complex divisor) {
        double denominator = divisor.magnitudeSquared();
        return new Complex((this.real * divisor.real + this.imag * divisor.imag) / denominator, (this.imag * divisor.real - this.real * divisor.imag) / denominator);
    }

    public final boolean equals(Object z) {
        if (z instanceof Complex) {
            return ((Complex)z).real == this.real && ((Complex)z).imag == this.imag;
        }
        return false;
    }

    public final Complex exp() {
        double magnitude = Math.exp(this.real);
        return Complex.polarToComplex(magnitude, this.imag);
    }

    public static Complex exp(Complex z) {
        return z.exp();
    }

    public int hashCode() {
        return Double.valueOf(this.real).hashCode() >>> Double.valueOf(this.imag).hashCode();
    }

    public static double imag(Complex z) {
        return z.imag;
    }

    public static double imag(double z) {
        return 0.0;
    }

    public final boolean isCloseTo(Complex z) {
        return this.isCloseTo(z, EPSILON);
    }

    public final boolean isCloseTo(Complex z, double distance) {
        double distanceSquared;
        if (distance < 0.0) {
            return false;
        }
        double differenceSquared = this.subtract(z).magnitudeSquared();
        return !(differenceSquared > (distanceSquared = distance * distance));
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.real) || Double.isInfinite(this.imag);
    }

    public static boolean isInfinite(Complex z) {
        return z.isInfinite();
    }

    public final boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imag);
    }

    public static boolean isNaN(Complex z) {
        return z.isNaN();
    }

    public final Complex log() {
        return new Complex(Math.log(this.magnitude()), this.angle());
    }

    public static Complex log(Complex z) {
        return z.log();
    }

    public final double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public static double magnitude(Complex z) {
        return z.magnitude();
    }

    public double magnitudeSquared() {
        return this.real * this.real + this.imag * this.imag;
    }

    public static double magnitudeSquared(Complex z) {
        return z.magnitudeSquared();
    }

    public Complex multiply(Complex w) {
        return new Complex(w.real * this.real - w.imag * this.imag, w.real * this.imag + w.imag * this.real);
    }

    public final Complex negate() {
        double r = 0.0;
        double i = 0.0;
        if (this.real != 0.0) {
            r = -this.real;
        }
        if (this.imag != 0.0) {
            i = -this.imag;
        }
        return new Complex(r, i);
    }

    public static Complex polarToComplex(double magnitude, double angle) {
        if (magnitude < 0.0) {
            angle += Math.PI;
            magnitude = -magnitude;
        }
        if (magnitude == 0.0) {
            return ZERO;
        }
        return new Complex(magnitude * Math.cos(angle), magnitude * Math.sin(angle));
    }

    public Complex pow(double y) {
        double lnrho = Math.log(this.magnitude());
        double magnitude = Math.exp(lnrho * y);
        double angle = this.angle() * y;
        return Complex.polarToComplex(magnitude, angle);
    }

    public static Complex pow(Complex z, double y) {
        return z.pow(y);
    }

    public final Complex pow(Complex y) {
        double lnrho = Math.log(this.magnitude());
        double theta = this.angle();
        double magnitude = Math.exp(lnrho * y.real - theta * y.imag);
        double angle = lnrho * y.imag + theta * y.real;
        return Complex.polarToComplex(magnitude, angle);
    }

    public static Complex pow(Complex z, Complex y) {
        return z.pow(y);
    }

    public static Complex pow(double z, Complex y) {
        return new Complex(z, 0.0).pow(y);
    }

    public static double real(Complex z) {
        return z.real;
    }

    public static double real(double z) {
        return z;
    }

    public final Complex reciprocal() {
        double magSquared = this.magnitudeSquared();
        return new Complex(this.real / magSquared, -this.imag / magSquared);
    }

    public static Complex reciprocal(Complex z) {
        return z.reciprocal();
    }

    public final Complex[] roots(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Complex.roots(): n must be greater than or equal to one.");
        }
        Complex[] returnValue = new Complex[n];
        double oneOverN = 1.0 / (double)n;
        double twoPIOverN = Math.PI * 2 * oneOverN;
        double thetaOverN = this.angle() * oneOverN;
        double twoPIkOverN = 0.0;
        double retMag = Math.pow(this.magnitudeSquared(), 0.5 * oneOverN);
        int k = 0;
        while (k < n) {
            returnValue[k] = Complex.polarToComplex(retMag, thetaOverN + twoPIkOverN);
            twoPIkOverN += twoPIOverN;
            ++k;
        }
        return returnValue;
    }

    public static Complex[] roots(Complex z, int n) {
        return z.roots(n);
    }

    public final Complex scale(double scalar) {
        return new Complex(this.real * scalar, this.imag * scalar);
    }

    public Complex sec() {
        Complex c1 = this.cos();
        return c1.reciprocal();
    }

    public static Complex sec(Complex z) {
        return z.sec();
    }

    public final Complex sin() {
        Complex c1 = new Complex(-this.imag, this.real);
        Complex c2 = c1.exp();
        Complex c3 = new Complex(this.imag, -this.real);
        Complex c4 = c2.subtract(c3.exp());
        return new Complex(c4.imag * 0.5, -c4.real * 0.5);
    }

    public static Complex sin(Complex z) {
        return z.sin();
    }

    public final Complex sinh() {
        Complex c1 = this.exp();
        Complex c2 = new Complex(-this.real, -this.imag);
        Complex c3 = c1.subtract(c2.exp());
        return new Complex(c3.real * 0.5, c3.imag * 0.5);
    }

    public static Complex sinh(Complex z) {
        return z.sinh();
    }

    public final Complex sqrt() {
        double magnitude = Math.sqrt(this.magnitude());
        double angle = this.angle() * 0.5;
        return Complex.polarToComplex(magnitude, angle);
    }

    public static Complex sqrt(Complex z) {
        return z.sqrt();
    }

    public final Complex subtract(Complex w) {
        return new Complex(this.real - w.real, this.imag - w.imag);
    }

    public final Complex tan() {
        Complex c1 = this.sin();
        return c1.divide(this.cos());
    }

    public static Complex tan(Complex z) {
        return z.tan();
    }

    public final Complex tanh() {
        Complex c1 = this.sinh();
        return c1.divide(this.cosh());
    }

    public static Complex tanh(Complex z) {
        return z.tanh();
    }

    public final String toString() {
        if (this.imag >= 0.0) {
            return String.valueOf(Double.toString(this.real)) + " + " + Double.toString(this.imag) + "i";
        }
        return String.valueOf(Double.toString(this.real)) + " - " + Double.toString(-this.imag) + "i";
    }

    public static String toString(Complex value) {
        if (value.imag >= 0.0) {
            return String.valueOf(Double.toString(value.real)) + " + " + Double.toString(value.imag) + "i";
        }
        return String.valueOf(Double.toString(value.real)) + " - " + Double.toString(-value.imag) + "i";
    }
}

