/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.attributes;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;

public class VersionAttribute
extends StringAttribute
implements Comparable {
    public static final VersionAttribute CURRENT_VERSION;
    private List _tupleList;

    static {
        try {
            CURRENT_VERSION = new VersionAttribute("7.0.1");
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Failed to create CURRENT_VERSION: " + KernelException.stackTraceToString(ex));
        }
    }

    public VersionAttribute(String expression) throws IllegalActionException {
        this.setExpression(expression);
        this.setVisibility(Settable.NONE);
    }

    public VersionAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._tupleList = new LinkedList();
        this.setVisibility(Settable.NONE);
    }

    public int compareTo(Object object) {
        VersionAttribute version = (VersionAttribute)object;
        Iterator versionTuples = version.iterator();
        Iterator tuples = this._tupleList == null ? null : this._tupleList.iterator();
        while (versionTuples.hasNext() || tuples != null && tuples.hasNext()) {
            int versionInt;
            int tupleInt;
            block5: {
                String versionTuple = versionTuples.hasNext() ? (String)versionTuples.next() : "0";
                String tuple = tuples != null && tuples.hasNext() ? (String)tuples.next() : "0";
                try {
                    tupleInt = Integer.parseInt(tuple);
                    versionInt = Integer.parseInt(versionTuple);
                    if (tupleInt >= versionInt) break block5;
                    return -1;
                }
                catch (NumberFormatException numberFormatException) {
                    int compare = tuple.compareTo(versionTuple);
                    if (compare < 0) {
                        return -1;
                    }
                    if (compare <= 0) continue;
                    return 1;
                }
            }
            if (tupleInt <= versionInt) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this._tupleList == null) {
            return super.equals(object);
        }
        if (object instanceof VersionAttribute) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getExpression().hashCode();
    }

    public boolean isLessThan(VersionAttribute version) {
        return this.compareTo(version) < 0;
    }

    public Iterator iterator() {
        return this._tupleList.iterator();
    }

    public static String majorCurrentVersion() {
        Iterator versionTuples = CURRENT_VERSION.iterator();
        return String.valueOf((String)versionTuples.next()) + "." + (String)versionTuples.next();
    }

    public void setExpression(String expression) throws IllegalActionException {
        super.setExpression(expression);
        if (expression.indexOf(32) != -1) {
            throw new IllegalActionException((Nameable)this, "Versions cannot contain spaces: '" + expression + "'");
        }
        this._tupleList = new LinkedList();
        StringTokenizer tokenizer = new StringTokenizer(expression, ".-_");
        while (tokenizer.hasMoreTokens()) {
            this._tupleList.add(tokenizer.nextToken());
        }
    }
}

