/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.attributes;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.SingletonAttribute;

public class URIAttribute
extends SingletonAttribute {
    private URI _value;

    public URIAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setPersistent(false);
    }

    public static URI getModelURI(NamedObj container) {
        URIAttribute modelURI = null;
        while (container != null && modelURI == null) {
            try {
                modelURI = (URIAttribute)container.getAttribute("_uri", URIAttribute.class);
            }
            catch (IllegalActionException illegalActionException) {
                modelURI = null;
            }
            container = container.getContainer();
        }
        if (modelURI != null) {
            return modelURI.getURI();
        }
        return null;
    }

    public URI getURI() {
        return this._value;
    }

    public URL getURL() throws MalformedURLException {
        if (this._value == null) {
            return null;
        }
        return new URL(this._value.toString());
    }

    public void setURI(URI uri) throws IllegalActionException {
        this._value = uri;
        NamedObj container = this.getContainer();
        if (container != null) {
            container.attributeChanged(this);
        }
    }

    public void setURL(URL url) throws IllegalActionException {
        try {
            this._value = new URI(url.toExternalForm());
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                this._value = new URI(url.getProtocol(), url.getFile(), url.getRef());
            }
            catch (URISyntaxException ex2) {
                throw new InternalErrorException(this, (Throwable)ex2, "Error constructing URI from " + url);
            }
        }
        NamedObj container = this.getContainer();
        if (container != null) {
            container.attributeChanged(this);
        }
    }
}

