/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph.analysis;

import ptolemy.graph.Graph;
import ptolemy.graph.analysis.InvalidAnalyzerException;
import ptolemy.graph.analysis.analyzer.Analyzer;
import ptolemy.graph.analysis.analyzer.GraphAnalyzer;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class Analysis {
    private GraphAnalyzer _analyzer;

    public Analysis(GraphAnalyzer analyzer) {
        this._analyzer = analyzer;
        this.graph().addAnalysis(this);
    }

    public GraphAnalyzer analyzer() {
        return this._analyzer;
    }

    public void changeAnalyzer(GraphAnalyzer analyzer) {
        if (this.validAnalyzerInterface(analyzer)) {
            if (analyzer instanceof CachedStrategy && this.graph() == this.analyzer().graph()) {
                ((CachedStrategy)analyzer).setCachedResult((CachedStrategy)this._analyzer);
            }
        } else {
            throw new InvalidAnalyzerException("Invalid analyzer for the analysis:\n" + this.toString());
        }
        this._analyzer = analyzer;
    }

    public Graph graph() {
        return this._analyzer.graph();
    }

    public String toString() {
        return "Analysis using the following analyzer:\n" + this._analyzer.toString();
    }

    public boolean valid() {
        return this._analyzer.valid();
    }

    public boolean validAnalyzerInterface(Analyzer analyzer) {
        return analyzer instanceof GraphAnalyzer;
    }
}

