/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import ptolemy.graph.CPO;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;

public class Inequality {
    private InequalityTerm _lesserTerm = null;
    private InequalityTerm _greaterTerm = null;

    public Inequality(InequalityTerm lesserTerm, InequalityTerm greaterTerm) {
        if (lesserTerm == null) {
            throw new IllegalArgumentException("Inequality.Inequality: lesserTerm is null.");
        }
        if (greaterTerm == null) {
            throw new IllegalArgumentException("Inequality.Inequality: greaterTerm is null.");
        }
        this._lesserTerm = lesserTerm;
        this._greaterTerm = greaterTerm;
    }

    public InequalityTerm getGreaterTerm() {
        return this._greaterTerm;
    }

    public InequalityTerm getLesserTerm() {
        return this._lesserTerm;
    }

    public boolean isSatisfied(CPO cpo) throws IllegalActionException {
        int result = cpo.compare(this._lesserTerm.getValue(), this._greaterTerm.getValue());
        return result == -1 || result == 0;
    }

    public String toString() {
        return String.valueOf(this._lesserTerm.toString()) + " <= " + this._greaterTerm.toString();
    }
}

