/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import ptolemy.graph.CPO;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.GraphConstructionException;
import ptolemy.graph.GraphStateException;
import ptolemy.graph.Node;
import ptolemy.graph.analysis.TransitiveClosureAnalysis;
import ptolemy.graph.analysis.strategy.CachedStrategy;

public class DirectedAcyclicGraph
extends DirectedGraph
implements CPO {
    private boolean[][] _closure = null;
    private boolean[][] _tranClosureTranspose = null;
    private TransitiveClosureAnalysis _transitiveClosureAnalysis;
    private Object _bottom = null;
    private Object _top = null;

    public DirectedAcyclicGraph() {
    }

    public DirectedAcyclicGraph(int nodeCount) {
        super(nodeCount);
    }

    public Object bottom() {
        this._validate();
        return this._bottom;
    }

    public int compare(Object e1, Object e2) {
        this._validate();
        int i1 = this.nodeLabel(e1);
        int i2 = this.nodeLabel(e2);
        return this._compareNodeId(i1, i2);
    }

    public Object[] downSet(Object e) {
        this._validateDual();
        return this._upSetShared(e);
    }

    public Object greatestElement(Object[] subset) {
        this._validateDual();
        return this._leastElementShared(subset);
    }

    public Object greatestLowerBound(Object e1, Object e2) {
        this._validateDual();
        return this._lubShared(e1, e2);
    }

    public Object greatestLowerBound(Object[] subset) {
        this._validateDual();
        return this._lubShared(subset);
    }

    public boolean isLattice() {
        this._validate();
        if (this.bottom() == null || this.top() == null) {
            return false;
        }
        Object[] nodes = DirectedAcyclicGraph.weightArray(this.nodes());
        int i = 0;
        while (i < nodes.length - 1) {
            int j = i + 1;
            while (j < nodes.length) {
                if (this.leastUpperBound(nodes[i], nodes[j]) == null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Object leastElement(Object[] subset) {
        this._validate();
        return this._leastElementShared(subset);
    }

    public Object leastUpperBound(Object e1, Object e2) {
        this._validate();
        return this._lubShared(e1, e2);
    }

    public Object leastUpperBound(Object[] subset) {
        this._validate();
        return this._lubShared(subset);
    }

    public Object top() {
        this._validate();
        return this._top;
    }

    public Object[] topologicalSort() {
        this._validate();
        int size = this.nodeCount();
        int[] indeg = new int[size];
        int i = 0;
        while (i < size) {
            indeg[i] = this.inputEdgeCount(this.node(i));
            ++i;
        }
        Object[] result = new Object[size];
        boolean finished = false;
        boolean active = true;
        int nextResultIndex = 0;
        while (!finished) {
            active = false;
            finished = true;
            int id = 0;
            while (id < size) {
                if (indeg[id] > 0) {
                    active = true;
                }
                if (indeg[id] == 0) {
                    finished = false;
                    result[nextResultIndex++] = this.nodeWeight(id);
                    int n = id;
                    indeg[n] = indeg[n] - 1;
                    Iterator outputEdges = this.outputEdges(this.node(id)).iterator();
                    while (outputEdges.hasNext()) {
                        Node sink = ((Edge)outputEdges.next()).sink();
                        int n2 = this.nodeLabel(sink);
                        indeg[n2] = indeg[n2] - 1;
                    }
                }
                ++id;
            }
            if (!finished || !active) continue;
            throw new GraphStateException("DirectedAcyclicGraph.topologicalSort: Graph is cyclic.");
        }
        return result;
    }

    public Object[] topologicalSort(Object[] weights) {
        this._validate();
        int N = weights.length;
        int[] ids = new int[N];
        int i = 0;
        while (i < N) {
            ids[i] = this.nodeLabel(weights[i]);
            ++i;
        }
        i = 0;
        while (i < N - 1) {
            int j = i + 1;
            while (j < N) {
                if (this._compareNodeId(ids[i], ids[j]) == 1) {
                    int tmp = ids[i];
                    ids[i] = ids[j];
                    ids[j] = tmp;
                }
                ++j;
            }
            ++i;
        }
        Object[] result = new Object[N];
        int i2 = 0;
        while (i2 < N) {
            result[i2] = this.nodeWeight(ids[i2]);
            ++i2;
        }
        return result;
    }

    public Object[] upSet(Object e) {
        this._validate();
        return this._upSetShared(e);
    }

    protected Edge _addEdge(Node node1, Node node2, boolean weighted, Object weight) {
        if (node1 == node2) {
            throw new GraphConstructionException("Cannot add a self loop in an acyclic graph.\nA self loop was attempted on the following node.\n" + node1.toString());
        }
        return super._addEdge(node1, node2, weighted, weight);
    }

    protected void _initializeAnalyses() {
        super._initializeAnalyses();
        this._transitiveClosureAnalysis = new TransitiveClosureAnalysis(this);
    }

    private int _compareNodeId(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (this._closure[i1][i2]) {
            return -1;
        }
        if (this._closure[i2][i1]) {
            return 1;
        }
        return 2;
    }

    private Object _leastElementNodeId(int[] ids) {
        LinkedList<Integer> incomparables = new LinkedList<Integer>();
        int virtualLength = ids.length;
        while (virtualLength > 1) {
            int virtualIndex = 0;
            int numberOfRemovedElements = 0;
            int i = 0;
            while (i < virtualLength - 1) {
                switch (this._compareNodeId(ids[i++], ids[i++])) {
                    case -1: 
                    case 0: {
                        ids[virtualIndex++] = ids[i - 2];
                        ++numberOfRemovedElements;
                        break;
                    }
                    case 1: {
                        ids[virtualIndex++] = ids[i - 1];
                        ++numberOfRemovedElements;
                        break;
                    }
                    case 2: {
                        incomparables.addLast(ids[i - 2]);
                        incomparables.addLast(ids[i - 1]);
                        numberOfRemovedElements += 2;
                        break;
                    }
                    default: {
                        throw new GraphStateException("Bugs in code! Inconsistent data structure!");
                    }
                }
            }
            if (i == virtualLength - 1) {
                ids[virtualIndex] = ids[i];
            }
            virtualLength -= numberOfRemovedElements;
        }
        if (virtualLength == 0) {
            return null;
        }
        if (incomparables.size() != 0) {
            ListIterator iterator = incomparables.listIterator(0);
            while (iterator.hasNext()) {
                int result = this._compareNodeId(ids[0], (Integer)iterator.next());
                if (result != 1 && result != 2) continue;
                return null;
            }
        }
        return this.nodeWeight(ids[0]);
    }

    private Object _leastElementShared(Object[] subset) {
        if (subset.length == 1) {
            if (this.containsNodeWeight(subset[0])) {
                return subset[0];
            }
            throw new IllegalArgumentException("Object not in CPO.");
        }
        if (subset.length == 2) {
            int i2;
            int i1 = this.nodeLabel(subset[0]);
            int result = this._compareNodeId(i1, i2 = this.nodeLabel(subset[1]));
            if (result == -1 || result == 0) {
                return subset[0];
            }
            if (result == 1) {
                return subset[1];
            }
            return null;
        }
        int[] ids = new int[subset.length];
        int i = 0;
        while (i < subset.length) {
            ids[i] = this.nodeLabel(subset[i]);
            ++i;
        }
        return this._leastElementNodeId(ids);
    }

    private Object _lubShared(Object e1, Object e2) {
        int i2;
        int i1 = this.nodeLabel(e1);
        int result = this._compareNodeId(i1, i2 = this.nodeLabel(e2));
        if (result == -1 || result == 0) {
            return e2;
        }
        if (result == 1) {
            return e1;
        }
        int size = this.nodeCount();
        boolean[] isUpperBound = new boolean[size];
        int numUpperBound = 0;
        int i = 0;
        while (i < size) {
            isUpperBound[i] = false;
            if (this._closure[i1][i] && this._closure[i2][i]) {
                isUpperBound[i] = true;
                ++numUpperBound;
            }
            ++i;
        }
        if (numUpperBound == 0) {
            return null;
        }
        int[] upperBound = new int[numUpperBound];
        int count = 0;
        int i3 = 0;
        while (i3 < size) {
            if (isUpperBound[i3]) {
                upperBound[count++] = i3;
            }
            ++i3;
        }
        if (numUpperBound == 1) {
            return this.nodeWeight(upperBound[0]);
        }
        return this._leastElementNodeId(upperBound);
    }

    private Object _lubShared(Object[] subset) {
        int[] subsetId = new int[subset.length];
        int i = 0;
        while (i < subset.length) {
            subsetId[i] = this.nodeLabel(subset[i]);
            ++i;
        }
        int size = this.nodeCount();
        int numUB = 0;
        int[] ubId = new int[size];
        int i2 = 0;
        while (i2 < size) {
            boolean isUB = true;
            int j = 0;
            while (j < subsetId.length) {
                int compare = this._compareNodeId(i2, subsetId[j]);
                if (compare == -1 || compare == 2) {
                    isUB = false;
                    break;
                }
                ++j;
            }
            if (isUB) {
                ubId[numUB++] = i2;
            }
            ++i2;
        }
        int[] ids = new int[numUB];
        int i3 = 0;
        while (i3 < numUB) {
            ids[i3] = ubId[i3];
            ++i3;
        }
        return this._leastElementNodeId(ids);
    }

    private Object[] _upSetShared(Object e) {
        int id = this.nodeLabel(e);
        ArrayList<Object> upset = new ArrayList<Object>(this._closure.length);
        upset.add(e);
        int i = 0;
        while (i < this._closure.length) {
            if (this._closure[id][i]) {
                upset.add(this.nodeWeight(i));
            }
            ++i;
        }
        return upset.toArray();
    }

    private void _validate() {
        boolean[][] transitiveClosure = this.transitiveClosure();
        if (!((CachedStrategy)this._transitiveClosureAnalysis.analyzer()).obsolete() && this.isAcyclic()) {
            this._closure = transitiveClosure;
            return;
        }
        if (!this.isAcyclic()) {
            throw new GraphStateException("DirectedAcyclicGraph._validate: Graph is cyclic.");
        }
        this._bottom = null;
        int i = 0;
        while (i < this.nodeCount()) {
            if (this.inputEdgeCount(this.node(i)) == 0) {
                if (this._bottom == null) {
                    this._bottom = this.nodeWeight(i);
                } else {
                    this._bottom = null;
                    break;
                }
            }
            ++i;
        }
        this._top = null;
        i = 0;
        while (i < this.nodeCount()) {
            if (this.outputEdgeCount(this.node(i)) == 0) {
                if (this._top == null) {
                    this._top = this.nodeWeight(i);
                } else {
                    this._top = null;
                    break;
                }
            }
            ++i;
        }
        this._closure = transitiveClosure;
        this._tranClosureTranspose = null;
    }

    private void _validateDual() {
        this._validate();
        boolean[][] transitiveClosure = this.transitiveClosure();
        if (this._tranClosureTranspose == null) {
            int size = transitiveClosure.length;
            this._tranClosureTranspose = new boolean[size][size];
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size) {
                    this._tranClosureTranspose[i][j] = transitiveClosure[j][i];
                    ++j;
                }
                ++i;
            }
        }
        this._closure = this._tranClosureTranspose;
    }
}

