/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import ptolemy.data.FunctionToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class FunctionType
extends StructuredType {
    private FieldTypeTerm[] _argTypeTerms;
    private FieldTypeTerm _returnTypeTerm;
    private static FunctionType _representative = new FunctionType(new Type[0], BaseType.UNKNOWN);

    public FunctionType(Type[] types, Type returnType) {
        this._argTypeTerms = new FieldTypeTerm[types.length];
        int i = 0;
        while (i < types.length) {
            FieldTypeTerm fieldType;
            this._argTypeTerms[i] = fieldType = new FieldTypeTerm(types[i]);
            ++i;
        }
        this._returnTypeTerm = new FieldTypeTerm(returnType);
    }

    public Object clone() {
        if (this.isConstant()) {
            return this;
        }
        Type[] types = new Type[this._argTypeTerms.length];
        int i = 0;
        while (i < types.length) {
            types[i] = this.getArgType(i);
            ++i;
        }
        FunctionType newObj = new FunctionType(types, this.getReturnType());
        try {
            newObj.updateType(this);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(null, (Throwable)ex, "Failed to update new instance.");
        }
        return newObj;
    }

    public Token convert(Token token) throws IllegalActionException {
        if (!this.isCompatible(token.getType())) {
            throw new IllegalArgumentException(Token.notSupportedConversionMessage(token, this.toString()));
        }
        return token;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FunctionType)) {
            return false;
        }
        FunctionType functionType = (FunctionType)object;
        if (this.getArgCount() != functionType.getArgCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getArgCount()) {
            Type argType;
            Type myType = this.getArgType(i);
            if (!myType.equals(argType = functionType.getArgType(i))) {
                return false;
            }
            ++i;
        }
        return this.getReturnType().equals(functionType.getReturnType());
    }

    public int getArgCount() {
        return this._argTypeTerms.length;
    }

    public Type getArgType(int i) {
        if (i < 0 || i >= this._argTypeTerms.length) {
            return null;
        }
        FieldTypeTerm fieldType = this._argTypeTerms[i];
        if (fieldType == null) {
            return null;
        }
        return fieldType._resolvedType;
    }

    public Type getReturnType() {
        return this._returnTypeTerm._resolvedType;
    }

    public Class getTokenClass() {
        return FunctionToken.class;
    }

    public FieldTypeTerm getArgTypeTerm(int i) {
        return this._argTypeTerms[i];
    }

    public int hashCode() {
        return this._returnTypeTerm.hashCode() + 1;
    }

    public void initialize(Type type) {
        try {
            int i = 0;
            while (i < this.getArgCount()) {
                FieldTypeTerm fieldType = this.getArgTypeTerm(i);
                if (fieldType.isSettable()) {
                    fieldType.initialize(type);
                }
                ++i;
            }
        }
        catch (IllegalActionException iae) {
            throw new InternalErrorException("FunctionType.initialize: Cannot initialize the element type to " + type + " " + iae.getMessage());
        }
    }

    public boolean isAbstract() {
        return !this.isInstantiable();
    }

    public boolean isCompatible(Type type) {
        if (type.equals(BaseType.UNKNOWN)) {
            return true;
        }
        if (!(type instanceof FunctionType)) {
            return false;
        }
        FunctionType argumentFunctionType = (FunctionType)type;
        if (argumentFunctionType.getArgCount() != this.getArgCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getArgCount()) {
            Type thisFieldTypeTerm;
            Type argumentFieldTypeTerm = argumentFunctionType.getArgType(i);
            if (!argumentFieldTypeTerm.isCompatible(thisFieldTypeTerm = this.getArgType(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isConstant() {
        int i = 0;
        while (i < this.getArgCount()) {
            FieldTypeTerm fieldType = this.getArgTypeTerm(i);
            Type type = fieldType._declaredType;
            if (!type.isConstant()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isInstantiable() {
        int i = 0;
        while (i < this.getArgCount()) {
            Type type = this.getArgType(i);
            if (!type.isInstantiable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSubstitutionInstance(Type type) {
        if (!(type instanceof FunctionType)) {
            return false;
        }
        FunctionType functionType = (FunctionType)type;
        int argCount = this.getArgCount();
        if (functionType.getArgCount() != argCount) {
            return false;
        }
        int i = 0;
        while (i < this.getArgCount()) {
            Type argType;
            Type myArgType = this.getArgType(i);
            if (!myArgType.isSubstitutionInstance(argType = functionType.getArgType(i))) {
                return false;
            }
            ++i;
        }
        return this.getReturnType().isSubstitutionInstance(functionType.getReturnType());
    }

    public String toString() {
        StringBuffer results = new StringBuffer("(function(");
        int i = 0;
        while (i < this.getArgCount()) {
            if (i != 0) {
                results.append(", ");
            }
            results.append("a" + i + ":" + this.getArgType(i));
            ++i;
        }
        return String.valueOf(results.toString()) + ") " + this.getReturnType() + ")";
    }

    public void updateType(StructuredType newType) throws IllegalActionException {
        if (this.isConstant()) {
            if (this.equals(newType)) {
                return;
            }
            throw new IllegalActionException("FunctionType.updateType: This type is a constant and the argument is not the same as this type. This type: " + this.toString() + " argument: " + newType.toString());
        }
        if (!this.isSubstitutionInstance(newType)) {
            throw new IllegalActionException("FunctionType.updateType: Cannot update this type to the new type.");
        }
        int i = 0;
        while (i < this.getArgCount()) {
            FieldTypeTerm argTypeTerm = this.getArgTypeTerm(i);
            if (argTypeTerm.isSettable()) {
                Type newArgType = ((FunctionType)newType).getArgType(i);
                argTypeTerm.setValue(newArgType);
            }
            ++i;
        }
        if (this._returnTypeTerm.isSettable()) {
            this._returnTypeTerm.setValue(((FunctionType)newType).getReturnType());
        }
    }

    protected int _compare(StructuredType type) {
        if (!(type instanceof FunctionType)) {
            throw new IllegalArgumentException("FunctionType.compare: The argument is not a FunctionType.");
        }
        if (this.equals(type)) {
            return 0;
        }
        if (this._isLessThanOrEqualTo(this, (FunctionType)type)) {
            return -1;
        }
        if (this._isLessThanOrEqualTo((FunctionType)type, this)) {
            return 1;
        }
        return 2;
    }

    protected StructuredType _getRepresentative() {
        return _representative;
    }

    protected StructuredType _greatestLowerBound(StructuredType type) {
        if (!(type instanceof FunctionType)) {
            throw new IllegalArgumentException("FunctionType.greatestLowerBound: The argument is not a FunctionType.");
        }
        FunctionType functionType = (FunctionType)type;
        int argCount = this.getArgCount();
        if (functionType.getArgCount() != argCount) {
            throw new IllegalArgumentException("Types are not comparable because they have different numbers of arguments");
        }
        Type[] types = new Type[argCount];
        int i = 0;
        while (i < argCount) {
            Type type1 = this.getArgType(i);
            Type type2 = functionType.getArgType(i);
            types[i] = type1 == null ? type2 : (type2 == null ? type1 : (Type)TypeLattice.lattice().greatestLowerBound(type1, type2));
            ++i;
        }
        Type returnType = (Type)TypeLattice.lattice().greatestLowerBound(this.getReturnType(), functionType.getReturnType());
        return new FunctionType(types, returnType);
    }

    protected StructuredType _leastUpperBound(StructuredType type) {
        if (!(type instanceof FunctionType)) {
            throw new IllegalArgumentException("FunctionType.leastUpperBound: The argument is not a FunctionType.");
        }
        FunctionType functionType = (FunctionType)type;
        int argCount = this.getArgCount();
        if (functionType.getArgCount() != argCount) {
            throw new IllegalArgumentException("Types are not comparable because they have different numbers of arguments");
        }
        Type[] types = new Type[argCount];
        int i = 0;
        while (i < argCount) {
            Type type1 = this.getArgType(i);
            Type type2 = functionType.getArgType(i);
            types[i] = type1 == null ? type2 : (type2 == null ? type1 : (Type)TypeLattice.lattice().leastUpperBound(type1, type2));
            ++i;
        }
        Type returnType = (Type)TypeLattice.lattice().leastUpperBound(this.getReturnType(), functionType.getReturnType());
        return new FunctionType(types, returnType);
    }

    private boolean _isLessThanOrEqualTo(FunctionType t1, FunctionType t2) {
        int argCount = t1.getArgCount();
        if (t2.getArgCount() != argCount) {
            return false;
        }
        int i = 0;
        while (i < argCount) {
            Type type2;
            Type type1 = t1.getArgType(i);
            int result = TypeLattice.compare(type1, type2 = t2.getArgType(i));
            if (result == 1 || result == 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class FieldTypeTerm
    implements InequalityTerm {
        private Type _declaredType = null;
        private Type _resolvedType = null;

        private FieldTypeTerm(Type declaredType) {
            try {
                this._resolvedType = this._declaredType = (Type)declaredType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalErrorException("FunctionType.FieldTypeTerm: The specified type cannot be cloned.");
            }
        }

        public Object getAssociatedObject() {
            return FunctionType.this;
        }

        public Object getValue() {
            return this._resolvedType;
        }

        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        public void initialize(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("FunctionType$FieldTypeTerm.initialize: The type is not settable.");
            }
            if (!(e instanceof Type)) {
                throw new IllegalActionException("FieldTypeTerm.initialize: The argument is not a Type.");
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                this._resolvedType = (Type)e;
            } else {
                ((StructuredType)this._resolvedType).initialize((Type)e);
            }
        }

        public boolean isSettable() {
            return !this._declaredType.isConstant();
        }

        public boolean isValueAcceptable() {
            return this._resolvedType.isInstantiable();
        }

        public void setValue(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("FunctionType$FieldTypeTerm.setValue: The type is not settable.");
            }
            if (!this._declaredType.isSubstitutionInstance((Type)e)) {
                throw new IllegalActionException("FieldTypeTerm.setValue: Cannot update the field type of this FunctionType to the new type. Field type: " + this._declaredType.toString() + ", New type: " + e.toString());
            }
            if (this._declaredType == BaseType.UNKNOWN) {
                try {
                    this._resolvedType = (Type)((Type)e).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new InternalErrorException("FunctionType$FieldTypeTerm.setValue: The specified type cannot be cloned.");
                }
            } else {
                ((StructuredType)this._resolvedType).updateType((StructuredType)e);
            }
        }

        public String toString() {
            return "(FunctionFieldTypeTerm, " + this.getValue() + ")";
        }
    }
}

