/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import java.io.Serializable;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.type.Typeable;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class ArrayType
extends StructuredType
implements Serializable {
    public static final InequalityTerm ARRAY_BOTTOM = new ArrayBottomTypeTerm(BaseType.ARRAY_BOTTOM);
    public static final InequalityTerm ARRAY_UNSIZED_BOTTOM = new ArrayBottomTypeTerm(new ArrayType(BaseType.UNKNOWN));
    private Type _declaredElementType;
    private Type _elementType;
    private int _length;
    private ElementTypeTerm _elemTypeTerm = new ElementTypeTerm();
    private static ArrayType _representative = new ArrayType(BaseType.UNKNOWN);

    public ArrayType(Type elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("Cannot create ArrayType  with null elementType");
        }
        try {
            this._declaredElementType = (Type)elementType.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalErrorException("The specified type " + elementType + " cannot be cloned.");
        }
        this._elementType = this._declaredElementType;
        this._length = -1;
    }

    public ArrayType(Type elementType, int length) {
        this(elementType);
        if (length < 0) {
            throw new IllegalArgumentException("Cannot create ArrayType with negative length.");
        }
        this._length = length;
    }

    public static InequalityTerm arrayOf(Typeable typeable) throws IllegalActionException {
        return new TypeableArrayTypeTerm(typeable);
    }

    public static InequalityTerm arrayOf(Typeable typeable, int length) throws IllegalActionException {
        return new TypeableSizedArrayTypeTerm(typeable, length);
    }

    public Object clone() {
        ArrayType newObj = new ArrayType(this._declaredElementType);
        newObj._length = this._length;
        try {
            newObj.updateType(this);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("ArrayType.clone: Cannot update new instance. " + ex.getMessage());
        }
        return newObj;
    }

    public Token convert(Token token) throws IllegalActionException {
        Type myElementType = this.getElementType();
        if (myElementType.equals(BaseType.UNKNOWN)) {
            if (token instanceof ArrayToken) {
                return token;
            }
            throw new IllegalActionException("Cannot convert " + token + " to type {unknown}");
        }
        if (!(token instanceof ArrayToken)) {
            if (this.hasKnownLength() && this.length() != 1) {
                throw new IllegalActionException(null, Token.notSupportedConversionMessage(token, this.toString()));
            }
            Token[] contents = new Token[]{token};
            return new ArrayToken(myElementType, contents);
        }
        ArrayToken argumentArrayToken = (ArrayToken)token;
        if (this.hasKnownLength() && argumentArrayToken.length() != this.length()) {
            throw new IllegalActionException(null, Token.notSupportedConversionMessage(token, this.toString()));
        }
        if (myElementType.equals(argumentArrayToken.getElementType())) {
            return token;
        }
        Token[] argumentArray = argumentArrayToken.arrayValue();
        Token[] resultArray = new Token[argumentArray.length];
        try {
            int i = 0;
            while (i < argumentArray.length) {
                resultArray[i] = myElementType.convert(argumentArray[i]);
                ++i;
            }
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException(null, ex, Token.notSupportedConversionMessage(token, "int"));
        }
        if (resultArray.length < 1) {
            Type argumentArrayElementType = argumentArrayToken.getElementType();
            try {
                return new ArrayToken(argumentArrayElementType);
            }
            catch (Exception ex) {
                throw new IllegalActionException(null, ex, "Failed to construct an array of type " + argumentArrayElementType);
            }
        }
        return new ArrayToken(myElementType, resultArray);
    }

    public int depth() {
        int depth = 1;
        if (this._elementType instanceof StructuredType) {
            depth += ((StructuredType)this._elementType).depth();
        }
        return depth;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArrayType)) {
            return false;
        }
        ArrayType argumentType = (ArrayType)object;
        return this._elementType.equals(argumentType.getElementType()) && this._length == argumentType._length;
    }

    public static InequalityTerm elementType(Typeable typeable) throws IllegalActionException {
        typeable.setTypeAtLeast(ARRAY_BOTTOM);
        return new TypeableElementTypeTerm(typeable);
    }

    public Type getDeclaredElementType() {
        return this._declaredElementType;
    }

    public Type getElementType() {
        return this._elementType;
    }

    public InequalityTerm getElementTypeTerm() {
        return this._elemTypeTerm;
    }

    public Class getTokenClass() {
        return ArrayToken.class;
    }

    public int hashCode() {
        return this._elementType.hashCode() + 2917;
    }

    public boolean hasKnownLength() {
        return this._length >= 0;
    }

    public boolean isAbstract() {
        return this._elementType.isAbstract() || !this.hasKnownLength();
    }

    public void initialize(Type t) {
        try {
            if (!this.isConstant()) {
                this._elemTypeTerm.initialize(t);
            }
        }
        catch (IllegalActionException iae) {
            throw new InternalErrorException("ArrayType.initialize: Cannot initialize the element type to " + t + ". " + iae.getMessage());
        }
    }

    public boolean isCompatible(Type type) {
        ArrayType arrayType;
        if (type instanceof ArrayType) {
            arrayType = (ArrayType)type;
            if (this.hasKnownLength() && arrayType.hasKnownLength() && this.length() != arrayType.length()) {
                return false;
            }
        } else {
            return type.equals(BaseType.GENERAL);
        }
        Type elementType = arrayType.getElementType();
        return this._elementType.isCompatible(elementType);
    }

    public boolean isConstant() {
        return this._declaredElementType.isConstant();
    }

    public boolean isInstantiable() {
        return this._elementType.isInstantiable();
    }

    public boolean isSubstitutionInstance(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (this.hasKnownLength() && arrayType.hasKnownLength() && this.length() != arrayType.length()) {
                return false;
            }
        } else {
            return false;
        }
        Type argElemType = ((ArrayType)type).getElementType();
        return this._declaredElementType.isSubstitutionInstance(argElemType);
    }

    public int length() {
        if (!this.hasKnownLength()) {
            throw new RuntimeException("Length is not known.");
        }
        return this._length;
    }

    public void setType(Type type) throws IllegalActionException {
        if (!(type instanceof ArrayType)) {
            throw new IllegalActionException("Cannot change an array type to a non-array type.");
        }
        try {
            Type clone;
            this._elementType = clone = (Type)((ArrayType)type).getElementType().clone();
            this._declaredElementType = clone;
            this._length = ((ArrayType)type).length();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalErrorException(e);
        }
    }

    public String toString() {
        if (this.hasKnownLength()) {
            return "arrayType(" + this.getElementType().toString() + "," + this._length + ")";
        }
        return "arrayType(" + this.getElementType().toString() + ")";
    }

    public void updateType(StructuredType newType) throws IllegalActionException {
        super.updateType(newType);
        if (!this.isSubstitutionInstance(newType)) {
            throw new IllegalActionException("ArrayType.updateType: The type " + this + " cannot be updated to " + newType + ".");
        }
        ArrayType arrayType = (ArrayType)newType;
        if (!arrayType.hasKnownLength() || arrayType._length != this._length) {
            this._length = -1;
        }
        Type newElemType = ((ArrayType)newType).getElementType();
        if (this._declaredElementType.equals(BaseType.UNKNOWN)) {
            try {
                this._elementType = (Type)newElemType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalErrorException("ArrayType.updateType: The specified element type cannot be cloned: " + this._elementType);
            }
        } else if (!this._declaredElementType.equals(newElemType)) {
            ((StructuredType)this._elementType).updateType((StructuredType)newElemType);
        }
    }

    protected int _compare(StructuredType type) {
        if (!(type instanceof ArrayType)) {
            throw new IllegalArgumentException("ArrayType.compare: The argument " + type + " is not an ArrayType.");
        }
        int retval = TypeLattice.compare(this._elementType, ((ArrayType)type).getElementType());
        ArrayType arrayArgType = (ArrayType)type;
        if (this.hasKnownLength() && arrayArgType.hasKnownLength()) {
            if (this.length() != arrayArgType.length()) {
                retval = 2;
            }
        } else if (this.hasKnownLength()) {
            if (retval == 1) {
                retval = 2;
            } else if (retval == 0) {
                retval = -1;
            }
        } else if (arrayArgType.hasKnownLength()) {
            if (retval == -1) {
                retval = 2;
            } else if (retval == 0) {
                retval = 1;
            }
        }
        return retval;
    }

    protected StructuredType _getRepresentative() {
        return _representative;
    }

    protected StructuredType _greatestLowerBound(StructuredType type) {
        if (!(type instanceof ArrayType)) {
            throw new IllegalArgumentException("ArrayType.greatestLowerBound: The argument " + type + " is not an ArrayType.");
        }
        Type elementGLB = (Type)TypeLattice.lattice().greatestLowerBound(this._elementType, ((ArrayType)type).getElementType());
        ArrayType arrayArgType = (ArrayType)type;
        if (!this.hasKnownLength() && !arrayArgType.hasKnownLength()) {
            return new ArrayType(elementGLB);
        }
        if (this.hasKnownLength() && arrayArgType.hasKnownLength()) {
            this.length();
            arrayArgType.length();
        }
        if (this.hasKnownLength()) {
            return new ArrayType(elementGLB, this.length());
        }
        return new ArrayType(elementGLB, arrayArgType.length());
    }

    protected StructuredType _leastUpperBound(StructuredType type) {
        if (!(type instanceof ArrayType)) {
            throw new IllegalArgumentException("ArrayType.leastUpperBound: The argument " + type + " is not an ArrayType.");
        }
        Type elementLUB = (Type)TypeLattice.lattice().leastUpperBound(this._elementType, ((ArrayType)type).getElementType());
        ArrayType arrayArgType = (ArrayType)type;
        if (this.hasKnownLength() && arrayArgType.hasKnownLength() && this.length() == arrayArgType.length()) {
            return new ArrayType(elementLUB, this.length());
        }
        return new ArrayType(elementLUB);
    }

    private static class ArrayBottomTypeTerm
    implements InequalityTerm {
        private Type _arrayType;

        public ArrayBottomTypeTerm(Type type) {
            this._arrayType = type;
        }

        public Object getAssociatedObject() {
            return this._arrayType;
        }

        public Object getValue() throws IllegalActionException {
            return this._arrayType;
        }

        public InequalityTerm[] getVariables() {
            return new InequalityTerm[0];
        }

        public void initialize(Object e) throws IllegalActionException {
            throw new IllegalActionException("ArrayType$ArraybottomTypeTerm.setValue: Is not settable.");
        }

        public boolean isSettable() {
            return false;
        }

        public boolean isValueAcceptable() {
            return true;
        }

        public void setValue(Object type) throws IllegalActionException {
            throw new IllegalActionException("ArrayType$ArrayBottomTypeTerm.setValue: Is not settable.");
        }

        public String toString() {
            return this._arrayType.toString();
        }
    }

    private class ElementTypeTerm
    implements InequalityTerm {
        private ElementTypeTerm() {
        }

        public Object getAssociatedObject() {
            return ArrayType.this;
        }

        public Object getValue() {
            return ArrayType.this._elementType;
        }

        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        public void initialize(Object e) throws IllegalActionException {
            if (ArrayType.this.isConstant()) {
                throw new IllegalActionException("ArrayType$ElementTypeTerm.initialize: This type " + this + " is not settable.");
            }
            if (!(e instanceof Type)) {
                throw new IllegalActionException("ArrayType$ElementTypeTerm.initialize: The argument " + this + " is not a Type.");
            }
            if (ArrayType.this._declaredElementType.equals(BaseType.UNKNOWN)) {
                ArrayType.this._elementType = (Type)e;
            } else {
                ((StructuredType)ArrayType.this._elementType).initialize((Type)e);
            }
        }

        public boolean isSettable() {
            return !ArrayType.this._declaredElementType.isConstant();
        }

        public boolean isValueAcceptable() {
            return ArrayType.this._elementType.isInstantiable();
        }

        public void setValue(Object e) throws IllegalActionException {
            if (!this.isSettable()) {
                throw new IllegalActionException("ArrayType$ElementTypeTerm.setValue: This type " + e + " is not settable.");
            }
            if (!ArrayType.this._declaredElementType.isSubstitutionInstance((Type)e)) {
                throw new IllegalActionException("ArrayType$ElementTypeTerm.setValue: Cannot update the element type of this array to the new type. Element type: " + ArrayType.this._declaredElementType.toString() + ", New type: " + e.toString());
            }
            if (ArrayType.this._declaredElementType.equals(BaseType.UNKNOWN)) {
                try {
                    ArrayType.this._elementType = (Type)((Type)e).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new InternalErrorException("ArrayType$ElementTypeTerm.setValue: The specified type " + e + " cannot be cloned.");
                }
            } else {
                ((StructuredType)ArrayType.this._elementType).updateType((StructuredType)e);
            }
        }

        public String toString() {
            return "(ArrayElementType(" + this.getAssociatedObject() + "), " + this.getValue() + ")";
        }
    }

    private static class TypeableArrayTypeTerm
    implements InequalityTerm {
        private Typeable _typeable;
        private ArrayType _arrayType;

        public TypeableArrayTypeTerm(Typeable typeable) {
            this._typeable = typeable;
        }

        public Object getAssociatedObject() {
            return this._getArrayType();
        }

        public Object getValue() throws IllegalActionException {
            return this._getArrayTypeRaw();
        }

        public InequalityTerm[] getVariables() {
            return new InequalityTerm[0];
        }

        public void initialize(Object e) throws IllegalActionException {
            throw new IllegalActionException("ArrayType$TypeableArrayTypeTerm.initialize: This array type given with elements given by " + this._typeable + " is not settable.");
        }

        public boolean isSettable() {
            return false;
        }

        public boolean isValueAcceptable() {
            ArrayType type = this._getArrayType();
            return type.getElementTypeTerm().isValueAcceptable();
        }

        public void setValue(Object type) throws IllegalActionException {
            throw new IllegalActionException("ArrayType$TypeableArrayTypeTerm.setValue: The array type with element type given by " + this._typeable + " is not settable.");
        }

        public String toString() {
            try {
                return "(TypeableArrayType(" + this.getAssociatedObject() + "), " + this.getValue() + ")";
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }

        private ArrayType _getArrayType() {
            try {
                return this._getArrayTypeRaw();
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }

        private ArrayType _getArrayTypeRaw() throws IllegalActionException {
            Type type = this._typeable.getType();
            if (this._arrayType == null || !this._arrayType.getElementType().equals(type)) {
                this._arrayType = new ArrayType(type);
            }
            return this._arrayType;
        }
    }

    private static class TypeableElementTypeTerm
    implements InequalityTerm {
        private Typeable _typeable;

        public TypeableElementTypeTerm(Typeable typeable) {
            this._typeable = typeable;
        }

        public Object getAssociatedObject() {
            return this._typeable;
        }

        public Object getValue() throws IllegalActionException {
            InequalityTerm term = this._getElementTypeTerm();
            if (term == null) {
                return BaseType.UNKNOWN;
            }
            return term.getValue();
        }

        public InequalityTerm[] getVariables() {
            if (this.isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this};
                return variable;
            }
            return new InequalityTerm[0];
        }

        public void initialize(Object type) throws IllegalActionException {
            InequalityTerm term = this._getElementTypeTerm();
            if (term == null) {
                return;
            }
            term.initialize(type);
        }

        public boolean isSettable() {
            InequalityTerm term = this._getElementTypeTerm();
            if (term == null) {
                return true;
            }
            return term.isSettable();
        }

        public boolean isValueAcceptable() {
            InequalityTerm term = this._getElementTypeTerm();
            if (term == null) {
                return false;
            }
            return term.isValueAcceptable();
        }

        public void setValue(Object type) throws IllegalActionException {
            InequalityTerm term = this._getElementTypeTerm();
            if (term == null) {
                return;
            }
            term.setValue(type);
        }

        public String toString() {
            try {
                return "(ArrayElementType(" + this.getAssociatedObject() + "), " + this.getValue() + ")";
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }

        private InequalityTerm _getElementTypeTerm() {
            Type type;
            block3: {
                try {
                    type = this._typeable.getType();
                    if (type instanceof ArrayType) break block3;
                    return null;
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
            }
            return ((ArrayType)type).getElementTypeTerm();
        }
    }

    private static class TypeableSizedArrayTypeTerm
    implements InequalityTerm {
        private Typeable _typeable;
        private ArrayType _arrayType;
        private int _length;

        public TypeableSizedArrayTypeTerm(Typeable typeable, int length) {
            this._typeable = typeable;
            this._length = length;
        }

        public Object getAssociatedObject() {
            return this._getArrayType();
        }

        public Object getValue() throws IllegalActionException {
            return this._getArrayTypeRaw();
        }

        public InequalityTerm[] getVariables() {
            return new InequalityTerm[0];
        }

        public void initialize(Object e) throws IllegalActionException {
            throw new IllegalActionException("ArrayType$TypeableArrayTypeTerm.initialize: This array type given with elements given by " + this._typeable + " is not settable.");
        }

        public boolean isSettable() {
            return false;
        }

        public boolean isValueAcceptable() {
            ArrayType type = this._getArrayType();
            return type.getElementTypeTerm().isValueAcceptable();
        }

        public void setValue(Object type) throws IllegalActionException {
            throw new IllegalActionException("ArrayType$TypeableArrayTypeTerm.setValue: The array type with element type given by " + this._typeable + " is not settable.");
        }

        public String toString() {
            return this._getArrayType().toString();
        }

        private ArrayType _getArrayType() {
            try {
                return this._getArrayTypeRaw();
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }

        private ArrayType _getArrayTypeRaw() throws IllegalActionException {
            Type type = this._typeable.getType();
            if (this._arrayType == null || !this._arrayType.getElementType().equals(type)) {
                this._arrayType = new ArrayType(type, this._length);
            }
            return this._arrayType;
        }
    }
}

