/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.LinkedList;
import java.util.List;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParserScope;
import ptolemy.kernel.util.IllegalActionException;

public class ParseTreeSpecializer
extends AbstractParseTreeVisitor {
    protected List _excludedNames;
    protected ASTPtRootNode _result;
    protected ParserScope _scope;
    protected ParseTreeEvaluator _evaluator;

    public ASTPtRootNode specialize(ASTPtRootNode node, List excludedNames, ParserScope scope) throws IllegalActionException {
        this._excludedNames = excludedNames;
        this._scope = scope;
        this._evaluator = new ParseTreeEvaluator();
        try {
            this._result = (ASTPtRootNode)node.clone();
            this._result._parent = null;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalActionException(null, ex, "Failed to clone node for specialization");
        }
        this._result.visit(this);
        this._evaluator = null;
        this._scope = null;
        this._excludedNames = null;
        ASTPtRootNode result = this._result;
        this._result = null;
        return result;
    }

    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        Token value = null;
        String functionName = node.getFunctionName();
        if (this._scope != null && functionName != null && !this._excludedNames.contains(functionName)) {
            value = this._scope.get(node.getFunctionName());
        }
        if (value == null) {
            int numChildren = node.jjtGetNumChildren();
            int i = 1;
            while (i < numChildren) {
                this._visitChild(node, i);
                ++i;
            }
        } else {
            this._defaultVisit(node);
        }
    }

    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        LinkedList excludedNames = new LinkedList(this._excludedNames);
        excludedNames.addAll(node.getArgumentNameList());
        List oldExcludedNames = this._excludedNames;
        this._excludedNames = excludedNames;
        node.getExpressionTree().visit(this);
        this._excludedNames = oldExcludedNames;
    }

    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            return;
        }
        if (!this._excludedNames.contains(node.getName())) {
            Token token = null;
            if (this._scope != null) {
                token = this._scope.get(node.getName());
            }
            if (token == null) {
                token = Constants.get(node.getName());
            }
            if (token != null) {
                node.setToken(token);
                node.setConstant(true);
                node._name = null;
                return;
            }
            throw new IllegalActionException("The ID " + node.getName() + " is undefined.");
        }
    }

    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        this._defaultVisit(node);
    }

    protected boolean _childrenAreConstant(ASTPtRootNode node) {
        int numChildren = node.jjtGetNumChildren();
        int i = 0;
        while (i < numChildren) {
            ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
            if (!child.isConstant()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void _defaultVisit(ASTPtRootNode node) throws IllegalActionException {
        this._visitAllChildren(node);
        boolean isConstant = this._childrenAreConstant(node);
        if (isConstant) {
            this._replaceConstantNode(node);
        }
    }

    protected void _replaceConstantNode(ASTPtRootNode node) throws IllegalActionException {
        ASTPtLeafNode newNode = new ASTPtLeafNode(4);
        Token token = this._evaluator.evaluateParseTree(node, this._scope);
        newNode.setToken(token);
        newNode.setType(token.getType());
        newNode.setConstant(true);
        ASTPtRootNode parent = (ASTPtRootNode)node._parent;
        if (parent == null) {
            this._result = newNode;
        } else {
            newNode._parent = parent;
            int index = parent._children.indexOf(node);
            parent._children.set(index, newNode);
        }
    }
}

