/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.io.PrintStream;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.kernel.util.IllegalActionException;

public class ParseTreeDumper
extends AbstractParseTreeVisitor {
    private String _prefix;
    private PrintStream _stream = System.out;

    public void displayParseTree(ASTPtRootNode root) {
        this._prefix = "";
        try {
            root.visit(this);
        }
        catch (IllegalActionException ex) {
            this._stream.println(ex);
            ex.printStackTrace(this._stream);
        }
    }

    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        this._displayNode(node);
    }

    protected void _displayNode(ASTPtRootNode node) throws IllegalActionException {
        if (node.isEvaluated()) {
            String str = String.valueOf(node.toString(this._prefix)) + ", Token type: ";
            str = String.valueOf(str) + node.getToken().getClass().getName() + ", Value: ";
            this._stream.println(String.valueOf(str) + node.getToken().toString());
        } else {
            this._stream.println(String.valueOf(node.toString(this._prefix)) + "  _ptToken is null");
        }
        this._stream.println(" static type is " + node.getType());
        if (node.jjtGetNumChildren() > 0) {
            String oldPrefix = this._prefix;
            this._prefix = " " + oldPrefix;
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
                child.visit(this);
                ++i;
            }
            this._prefix = oldPrefix;
        }
    }
}

