/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.StringTokenizer;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.UtilityFunctions;
import ptolemy.kernel.util.IllegalActionException;

public class MatlabUtilities {
    private static long[] _engine;
    private static Class _engineClass;
    private static Method _engineClose;
    private static Method _engineEvalString;
    private static Method _engineGet;
    private static Method _engineOpen;
    private static Method _enginePut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token evaluate(String expression, Set variableNames, ParserScope scope) throws IllegalActionException {
        try {
            if (_engineClass == null) {
                MatlabUtilities._initialize();
            }
            Token result = null;
            Object matlabEngine = null;
            try {
                matlabEngine = _engineClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalActionException(null, ex, "Failed to instantiate ptolemy.matlab.Engine");
            }
            _engine = (long[])_engineOpen.invoke(matlabEngine, new Object[0]);
            try {
                long[] lArray = _engine;
                synchronized (_engine) {
                    String addPathCommand = null;
                    Token previousPath = null;
                    Token packageDirectories = null;
                    if (scope != null) {
                        packageDirectories = scope.get("packageDirectories");
                    }
                    if (packageDirectories != null && packageDirectories instanceof StringToken) {
                        StringTokenizer dirs = new StringTokenizer(((StringToken)packageDirectories).stringValue(), ",");
                        StringBuffer cellFormat = new StringBuffer(512);
                        cellFormat.append("{");
                        if (dirs.hasMoreTokens()) {
                            cellFormat.append("'" + UtilityFunctions.findFile(dirs.nextToken()) + "'");
                        }
                        while (dirs.hasMoreTokens()) {
                            cellFormat.append(",'" + UtilityFunctions.findFile(dirs.nextToken()) + "'");
                        }
                        cellFormat.append("}");
                        if (cellFormat.length() > 2) {
                            addPathCommand = "addedPath_=" + cellFormat.toString() + ";addpath(addedPath_{:});";
                            _engineEvalString.invoke(matlabEngine, _engine, "previousPath_=path");
                            previousPath = (Token)_engineGet.invoke(matlabEngine, _engine, "previousPath_");
                        }
                    }
                    _engineEvalString.invoke(matlabEngine, _engine, "clear variables;clear globals");
                    if (addPathCommand != null) {
                        _engineEvalString.invoke(matlabEngine, _engine, addPathCommand);
                    }
                    if (!variableNames.isEmpty()) {
                        for (String name : variableNames) {
                            Token token = scope.get(name);
                            if (token == null) continue;
                            _enginePut.invoke(matlabEngine, _engine, name, token);
                        }
                    }
                    _engineEvalString.invoke(matlabEngine, _engine, "result__=" + expression);
                    result = (Token)_engineGet.invoke(matlabEngine, _engine, "result__");
                    if (previousPath != null) {
                        _enginePut.invoke(matlabEngine, _engine, "previousPath_", previousPath);
                        _engineEvalString.invoke(matlabEngine, _engine, "path(previousPath_)");
                    }
                    // ** MonitorExit[var5_8] (shouldn't be in output)
                }
            }
            catch (Throwable throwable) {
                _engineClose.invoke(matlabEngine, new Object[]{_engine});
                throw throwable;
            }
            {
                _engineClose.invoke(matlabEngine, new Object[]{_engine});
                return result;
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalActionException(null, ex, "Problem invoking a method on ptolemy.matlab.Engine");
        }
        catch (InvocationTargetException ex) {
            throw new IllegalActionException(null, ex, "Problem invoking a method of ptolemy.matlab.Engine");
        }
    }

    private static void _initialize() throws IllegalActionException {
        try {
            _engineClass = Class.forName("ptolemy.matlab.Engine");
        }
        catch (Throwable throwable) {
            throw new IllegalActionException(null, throwable, "Failed to load ptolemy.matlab.Engine class");
        }
        try {
            _engineClose = _engineClass.getMethod("close", long[].class);
            _engineEvalString = _engineClass.getMethod("evalString", long[].class, String.class);
            _engineGet = _engineClass.getMethod("get", long[].class, String.class);
            _engineOpen = _engineClass.getMethod("open", new Class[0]);
            _enginePut = _engineClass.getMethod("put", long[].class, String.class, Token.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalActionException(null, ex, "Problem finding a method of ptolemy.matlab.Engine");
        }
    }
}

