/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ptolemy.data.Function;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.NamedConstantsScope;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeWriter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class ExpressionFunction
implements Function {
    private ASTPtRootNode _exprRoot;
    private List _argumentNames;
    private Type[] _argumentTypes;

    public ExpressionFunction(List argumentNames, Type[] argumentTypes, ASTPtRootNode exprRoot) {
        this._argumentNames = new ArrayList(argumentNames);
        this._argumentTypes = argumentTypes;
        this._exprRoot = exprRoot;
    }

    public Token apply(Token[] arguments) throws IllegalActionException {
        ParseTreeEvaluator parseTreeEvaluator = new ParseTreeEvaluator();
        HashMap<String, Token> map = new HashMap<String, Token>();
        int i = 0;
        while (i < arguments.length) {
            String name = (String)this._argumentNames.get(i);
            Token argument = arguments[i];
            map.put(name, argument);
            ++i;
        }
        NamedConstantsScope argumentsScope = new NamedConstantsScope(map);
        return parseTreeEvaluator.evaluateParseTree(this._exprRoot, argumentsScope);
    }

    public int getNumberOfArguments() {
        return this._argumentNames.size();
    }

    public boolean isCongruent(Function function) {
        return this.toString().compareTo(function.toString()) == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("(function(");
        int n = this._argumentNames.size();
        int i = 0;
        while (i < n) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append((String)this._argumentNames.get(i));
            Type type = this._argumentTypes[i];
            if (type != BaseType.GENERAL) {
                buffer.append(":");
                buffer.append(type.toString());
            }
            ++i;
        }
        buffer.append(") ");
        ParseTreeWriter writer = new ParseTreeWriter();
        String string = writer.printParseTree(this._exprRoot);
        buffer.append(string);
        buffer.append(")");
        return buffer.toString();
    }
}

