/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import ptolemy.data.expr.ASTPtArrayConstructNode;
import ptolemy.data.expr.ASTPtBitwiseNode;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionDefinitionNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtMatrixConstructNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtPowerNode;
import ptolemy.data.expr.ASTPtProductNode;
import ptolemy.data.expr.ASTPtRecordConstructNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ASTPtShiftNode;
import ptolemy.data.expr.ASTPtSumNode;
import ptolemy.data.expr.ASTPtUnaryNode;
import ptolemy.data.expr.AbstractParseTreeVisitor;
import ptolemy.data.expr.CachedMethod;
import ptolemy.data.expr.ParseTreeTypeInference;
import ptolemy.data.expr.Token;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class CParseTreeCodeGenerator
extends AbstractParseTreeVisitor {
    protected HashMap _nodeToLocalName;
    protected int _nodeNumber;

    public void generateCode(ASTPtRootNode node) throws IllegalActionException {
        ParseTreeTypeInference typeInference = new ParseTreeTypeInference();
        typeInference.inferTypes(node);
        this._nodeToLocalName = new HashMap();
        this._nodeNumber = 0;
        node.visit(this);
        this._nodeToLocalName = null;
    }

    public void visitArrayConstructNode(ASTPtArrayConstructNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        System.out.println(String.valueOf(nodeName) + " = FIXME:Array");
    }

    public void visitBitwiseNode(ASTPtBitwiseNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        this._assert(node.isBitwiseAnd() ^ node.isBitwiseOr() ^ node.isBitwiseXor(), node, "Invalid operation");
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        int i = 1;
        while (i < numChildren) {
            if (node.isBitwiseAnd()) {
                statement.append("&");
            } else if (node.isBitwiseOr()) {
                statement.append("|");
            } else if (node.isBitwiseXor()) {
                statement.append("^");
            } else {
                throw new RuntimeException("Unrecognized node");
            }
            statement.append(this._nodeToLocalName.get(node.jjtGetChild(i)));
            ++i;
        }
        System.out.println(statement.toString());
    }

    public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
        int numChildren = node.jjtGetNumChildren();
        int argCount = numChildren - 1;
        int i = 1;
        while (i < numChildren) {
            this._generateChild(node, i);
            ++i;
        }
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        if (this._isValidName(node.getFunctionName())) {
            if (argCount == 1) {
                System.out.println(String.valueOf(nodeName) + " = ");
                System.out.println(this._nodeToLocalName.get(node.jjtGetChild(0)) + "[" + this._nodeToLocalName.get(node.jjtGetChild(1)) + "]");
            } else if (argCount == 2) {
                System.out.println(String.valueOf(nodeName) + " = ");
                System.out.println(this._nodeToLocalName.get(node.jjtGetChild(0)) + "[" + this._nodeToLocalName.get(node.jjtGetChild(1)) + "," + this._nodeToLocalName.get(node.jjtGetChild(1)) + "]");
            } else {
                throw new IllegalActionException("Wrong number of indices when referencing " + node.getFunctionName());
            }
            return;
        }
        if (node.getFunctionName().compareTo("eval") == 0) {
            throw new IllegalActionException("unimplemented case");
        }
        if (node.getFunctionName().compareTo("matlab") == 0) {
            throw new IllegalActionException("unimplemented case");
        }
        Type[] argTypes = new Type[argCount];
        int i2 = 0;
        while (i2 < argCount) {
            argTypes[i2] = ((ASTPtRootNode)node.jjtGetChild(i2 + 1)).getType();
            ++i2;
        }
        CachedMethod cachedMethod = CachedMethod.findMethod(node.getFunctionName(), argTypes, 8);
        if (!cachedMethod.isValid()) {
            throw new IllegalActionException("Function " + cachedMethod + " not found.");
        }
        if (cachedMethod instanceof CachedMethod.BaseConvertCachedMethod || cachedMethod instanceof CachedMethod.ArrayMapCachedMethod || cachedMethod instanceof CachedMethod.MatrixMapCachedMethod) {
            throw new IllegalActionException("CodeGeneration not supported for " + cachedMethod.getClass());
        }
        Method method = cachedMethod.getMethod();
        System.out.println(String.valueOf(nodeName) + " = FIXME:method invocation of " + method.getName());
        String convertedReturnName = "FIXME";
        this._nodeToLocalName.put(node, convertedReturnName);
    }

    public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
        throw new IllegalActionException("Cannot generate code for functional if!");
    }

    public void visitFunctionDefinitionNode(ASTPtFunctionDefinitionNode node) throws IllegalActionException {
        throw new IllegalActionException("Cannot generate code for function definitions!");
    }

    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        if (node.isConstant() && node.isEvaluated()) {
            System.out.println(String.valueOf(nodeName) + " = " + node.getToken());
            return;
        }
        System.out.println(String.valueOf(nodeName) + " = " + this._getLocalNameForName(node.getName()));
    }

    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        int i = 1;
        while (i < numChildren) {
            if (node.isLogicalAnd()) {
                statement.append("&&");
            } else if (node.isLogicalOr()) {
                statement.append("||");
            } else {
                throw new RuntimeException("Unrecognized node");
            }
            statement.append(this._nodeToLocalName.get(node.jjtGetChild(i)));
            ++i;
        }
        System.out.println(statement.toString());
    }

    public void visitMatrixConstructNode(ASTPtMatrixConstructNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        System.out.println(String.valueOf(nodeName) + " = FIXME:Matrix");
    }

    public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        System.out.println(String.valueOf(nodeName) + " = FIXME:MethodCall");
    }

    public void visitPowerNode(ASTPtPowerNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        int i = 1;
        while (i < numChildren) {
            statement.append("^" + this._nodeToLocalName.get(node.jjtGetChild(i)));
            ++i;
        }
        System.out.println(statement.toString());
    }

    public void visitProductNode(ASTPtProductNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        List lexicalTokenList = node.getLexicalTokenList();
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        this._assert(numChildren == lexicalTokenList.size() + 1, node, "The number of child nodes is not equal to number of operators plus one");
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        int i = 1;
        while (i < numChildren) {
            Token operator = (Token)lexicalTokenList.get(i - 1);
            if (operator.kind == 12) {
                statement.append("*");
            } else if (operator.kind == 13) {
                statement.append("/");
            } else if (operator.kind == 14) {
                statement.append("%");
            } else {
                this._assert(false, node, "Invalid operation");
            }
            statement.append(this._nodeToLocalName.get(node.jjtGetChild(i)));
            ++i;
        }
        System.out.println(statement.toString());
    }

    public void visitRecordConstructNode(ASTPtRecordConstructNode node) throws IllegalActionException {
        throw new IllegalActionException("Cannot generate code for records!");
    }

    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren == 2, node, "The number of child nodes must be two");
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        Token operator = node.getOperator();
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        if (operator.kind == 33) {
            statement.append("==");
        } else if (operator.kind == 32) {
            statement.append("!=");
        } else if (operator.kind == 30) {
            statement.append(">=");
        } else if (operator.kind == 28) {
            statement.append(">");
        } else if (operator.kind == 31) {
            statement.append("<=");
        } else if (operator.kind == 29) {
            statement.append("<");
        } else {
            throw new IllegalActionException("Invalid operation " + operator.image);
        }
        statement.append(this._nodeToLocalName.get(node.jjtGetChild(1)));
        System.out.println(statement.toString());
    }

    public void visitShiftNode(ASTPtShiftNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren == 2, node, "The number of child nodes must be two");
        Token operator = node.getOperator();
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        if (operator.kind == 41) {
            statement.append("<<");
        } else if (operator.kind == 42) {
            statement.append(">>");
        } else if (operator.kind == 43) {
            statement.append("<");
        } else {
            this._assert(false, node, "Invalid operation");
        }
        statement.append(this._nodeToLocalName.get(node.jjtGetChild(1)));
        System.out.println(statement.toString());
    }

    public void visitSumNode(ASTPtSumNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        List lexicalTokenList = node.getLexicalTokenList();
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, node, "The number of child nodes must be greater than zero");
        this._assert(numChildren == lexicalTokenList.size() + 1, node, "The number of child nodes is not equal to number of operators plus one");
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = " + this._nodeToLocalName.get(node.jjtGetChild(0)));
        int i = 1;
        while (i < numChildren) {
            Token operator = (Token)lexicalTokenList.get(i - 1);
            if (operator.kind == 10) {
                statement.append("+");
            } else if (operator.kind == 11) {
                statement.append("-");
            } else {
                this._assert(false, node, "Invalid operation");
            }
            statement.append(this._nodeToLocalName.get(node.jjtGetChild(i)));
            ++i;
        }
        System.out.println(statement.toString());
    }

    public void visitUnaryNode(ASTPtUnaryNode node) throws IllegalActionException {
        this._generateAllChildren(node);
        this._assert(node.jjtGetNumChildren() == 1, node, "Unary node must have exactly one child!");
        String nodeName = "node" + this._nodeNumber++;
        this._nodeToLocalName.put(node, nodeName);
        StringBuffer statement = new StringBuffer(String.valueOf(nodeName) + " = ");
        if (node.isMinus()) {
            statement.append("-" + this._nodeToLocalName.get(node.jjtGetChild(0)));
        } else if (node.isNot()) {
            statement.append("!" + this._nodeToLocalName.get(node.jjtGetChild(0)));
        } else if (node.isBitwiseNot()) {
            statement.append("~" + this._nodeToLocalName.get(node.jjtGetChild(0)));
        } else {
            this._assert(false, node, "Unrecognized unary node");
        }
        System.out.println(statement.toString());
    }

    protected void _assert(boolean flag, ASTPtRootNode node, String message) {
        if (!flag) {
            throw new InternalErrorException(String.valueOf(message) + ": " + node.toString());
        }
    }

    protected void _generateAllChildren(ASTPtRootNode node) throws IllegalActionException {
        int numChildren = node.jjtGetNumChildren();
        int i = 0;
        while (i < numChildren) {
            this._generateChild(node, i);
            ++i;
        }
    }

    protected void _generateChild(ASTPtRootNode node, int i) throws IllegalActionException {
        ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(i);
        child.visit(this);
    }

    protected String _getLocalNameForName(String name) throws IllegalActionException {
        throw new IllegalActionException("The ID " + name + " is undefined.");
    }

    protected boolean _isValidName(String name) throws IllegalActionException {
        return false;
    }
}

