/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.math.ComplexMatrixMath;

public class ComplexMatrixToken
extends MatrixToken {
    private Complex[][] _value = null;
    private int _rowCount = 0;
    private int _columnCount = 0;

    public ComplexMatrixToken() {
        this._rowCount = 1;
        this._columnCount = 1;
        this._value = new Complex[1][1];
        this._value[0][0] = Complex.ZERO;
    }

    public ComplexMatrixToken(Complex[][] value) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("ComplexMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, 0);
    }

    public ComplexMatrixToken(Complex[][] value, int copy) throws IllegalActionException {
        if (value == null) {
            throw new IllegalActionException("ComplexMatrixToken: The specified matrix is null.");
        }
        this._initialize(value, copy);
    }

    public ComplexMatrixToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof ComplexMatrixToken)) {
            throw new IllegalActionException("A ComplexMatrixToken cannot be created from the expression '" + init + "'");
        }
        Complex[][] value = ((ComplexMatrixToken)token).complexMatrix();
        this._initialize(value, 0);
    }

    public ComplexMatrixToken(Token[] tokens, int rows, int columns) throws IllegalActionException {
        if (tokens == null) {
            throw new IllegalActionException("ComplexMatrixToken: The specified array is null.");
        }
        if (tokens.length != rows * columns) {
            throw new IllegalActionException("ComplexMatrixToken: The specified array is not of the correct length");
        }
        this._rowCount = rows;
        this._columnCount = columns;
        this._value = new Complex[rows][columns];
        int i = 0;
        while (i < tokens.length) {
            Token token = tokens[i];
            if (token instanceof ScalarToken) {
                this._value[i / columns][i % columns] = ((ScalarToken)token).complexValue();
            } else if (token == null) {
                this._value[i / columns][i % columns] = Complex.ZERO;
            } else {
                throw new IllegalActionException("ComplexMatrixToken: Element " + i + " in the array with value " + token + " is not a ScalarToken");
            }
            ++i;
        }
    }

    public Complex[][] complexMatrix() {
        return ComplexMatrixMath.allocCopy(this._value);
    }

    public static ComplexMatrixToken convert(Token token) throws IllegalActionException {
        if (token instanceof ComplexMatrixToken) {
            return (ComplexMatrixToken)token;
        }
        int compare = TypeLattice.compare((Type)BaseType.COMPLEX_MATRIX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(ComplexMatrixToken.notSupportedIncomparableConversionMessage(token, "[complex]"));
        }
        compare = TypeLattice.compare((Type)BaseType.DOUBLE_MATRIX, token);
        if (compare == 0 || compare == 1) {
            DoubleMatrixToken tem = DoubleMatrixToken.convert(token);
            return new ComplexMatrixToken(tem.complexMatrix());
        }
        throw new IllegalActionException(ComplexMatrixToken.notSupportedConversionMessage(token, "[complex]"));
    }

    public MatrixToken crop(int rowStart, int colStart, int rowSpan, int colSpan) throws IllegalActionException {
        Complex[][] value = this.complexMatrix();
        try {
            Complex[][] result = new Complex[rowSpan][colSpan];
            int i = 0;
            while (i < rowSpan) {
                System.arraycopy(value[rowStart + i], colStart, result[i], 0, colSpan);
                ++i;
            }
            return new ComplexMatrixToken(result);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalActionException("Matrix crop indices out of bounds (rowStart = " + rowStart + ", colStart = " + colStart + ", rowSpan = " + rowSpan + ", colSpan = " + colSpan + ").");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ComplexMatrixToken matrixArgument = (ComplexMatrixToken)object;
        if (this._rowCount != matrixArgument.getRowCount()) {
            return false;
        }
        if (this._columnCount != matrixArgument.getColumnCount()) {
            return false;
        }
        Complex[][] matrix = matrixArgument.complexMatrix();
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                if (!this._value[i][j].equals(matrix[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public Token getElementAsToken(int row, int column) throws ArrayIndexOutOfBoundsException {
        return new ComplexToken(this._value[row][column]);
    }

    public Complex getElementAt(int row, int column) {
        return this._value[row][column];
    }

    public Type getElementType() {
        return BaseType.COMPLEX;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Type getType() {
        return BaseType.COMPLEX_MATRIX;
    }

    public int hashCode() {
        Complex sum = new Complex(0.0);
        int i = 0;
        while (i < this._rowCount) {
            int j = 0;
            while (j < this._columnCount) {
                sum = sum.add(this._value[i][j]);
                ++j;
            }
            ++i;
        }
        return (int)sum.magnitude();
    }

    public MatrixToken join(MatrixToken[][] matrices) throws IllegalActionException {
        if (matrices == null || matrices.length == 0 || matrices[0].length == 0) {
            throw new IllegalActionException("matrixJoin: No input matrices.");
        }
        int rows = 0;
        int columns = 0;
        int i = 0;
        while (i < matrices.length) {
            rows += matrices[i][0].getRowCount();
            ++i;
        }
        int j = 0;
        while (j < matrices[0].length) {
            columns += matrices[0][j].getColumnCount();
            ++j;
        }
        Complex[][] tiled = new Complex[rows][columns];
        int row = 0;
        int i2 = 0;
        while (i2 < matrices.length) {
            int column = 0;
            int j2 = 0;
            while (j2 < matrices[i2].length) {
                int columnCount;
                if (!(matrices[i2][j2] instanceof ComplexMatrixToken)) {
                    throw new IllegalActionException("matrixJoin: matrices not all of the same type.");
                }
                int rowCount = matrices[i2][j2].getRowCount();
                if (row + rowCount > rows) {
                    rowCount = rows - row;
                }
                if (column + (columnCount = matrices[i2][j2].getColumnCount()) > columns) {
                    columnCount = columns - column;
                }
                ComplexMatrixMath.matrixCopy(matrices[i2][j2].complexMatrix(), 0, 0, tiled, row, column, rowCount, columnCount);
                column += matrices[0][j2].getColumnCount();
                ++j2;
            }
            row += matrices[i2][0].getRowCount();
            ++i2;
        }
        return new ComplexMatrixToken(tiled);
    }

    public MatrixToken[][] split(int[] rows, int[] columns) {
        MatrixToken[][] result = new MatrixToken[rows.length][columns.length];
        Complex[][] source = this.complexMatrix();
        int row = 0;
        int i = 0;
        while (i < rows.length) {
            int column = 0;
            int j = 0;
            while (j < columns.length) {
                int columnspan;
                Complex[][] contents = new Complex[rows[i]][columns[j]];
                int rowspan = rows[i];
                if (row + rowspan > source.length) {
                    rowspan = source.length - row;
                }
                if (column + (columnspan = columns[j]) > source[0].length) {
                    columnspan = source[0].length - column;
                }
                if (columnspan > 0 && rowspan > 0) {
                    ComplexMatrixMath.matrixCopy(source, row, column, contents, 0, 0, rowspan, columnspan);
                }
                column += columns[j];
                try {
                    result[i][j] = new ComplexMatrixToken(contents);
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
                ++j;
            }
            row += rows[i];
            ++i;
        }
        return result;
    }

    public Token one() {
        try {
            return new ComplexMatrixToken(ComplexMatrixMath.identity(this._rowCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("ComplexMatrixToken.one: Cannot create identity matrix.");
        }
    }

    public Token oneRight() {
        try {
            return new ComplexMatrixToken(ComplexMatrixMath.identity(this._columnCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("ComplexMatrixToken.oneRight: Cannot create identity matrix.");
        }
    }

    public Token zero() {
        try {
            return new ComplexMatrixToken(ComplexMatrixMath.zero(this._rowCount, this._columnCount), 1);
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException("ComplexMatrixToken.zero: Cannot create zero matrix.");
        }
    }

    protected MatrixToken _add(MatrixToken rightArgument) throws IllegalActionException {
        ComplexMatrixToken convertedArgument = (ComplexMatrixToken)rightArgument;
        Complex[][] result = ComplexMatrixMath.add(this._value, convertedArgument._getInternalComplexMatrix());
        return new ComplexMatrixToken(result);
    }

    protected MatrixToken _addElement(Token rightArgument) throws IllegalActionException {
        Complex scalar;
        if (rightArgument instanceof ComplexMatrixToken) {
            if (((ComplexMatrixToken)rightArgument).getRowCount() != 1 || ((ComplexMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((ComplexMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((ComplexToken)rightArgument).complexValue();
        }
        Complex[][] result = ComplexMatrixMath.add(this._value, scalar);
        return new ComplexMatrixToken(result);
    }

    protected MatrixToken _divideElement(Token rightArgument) throws IllegalActionException {
        Complex scalar;
        if (rightArgument instanceof ComplexMatrixToken) {
            if (((ComplexMatrixToken)rightArgument).getRowCount() != 1 || ((ComplexMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((ComplexMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((ComplexToken)rightArgument).complexValue();
        }
        Complex[][] result = ComplexMatrixMath.divide(this._value, scalar);
        return new ComplexMatrixToken(result);
    }

    protected Complex[][] _getInternalComplexMatrix() {
        return this._value;
    }

    protected MatrixToken _multiply(MatrixToken rightArgument) throws IllegalActionException {
        ComplexMatrixToken convertedArgument = (ComplexMatrixToken)rightArgument;
        Complex[][] result = ComplexMatrixMath.multiply(this._value, convertedArgument._getInternalComplexMatrix());
        return new ComplexMatrixToken(result);
    }

    protected MatrixToken _multiplyElement(Token rightArgument) throws IllegalActionException {
        Complex scalar;
        if (rightArgument instanceof ComplexMatrixToken) {
            if (((ComplexMatrixToken)rightArgument).getRowCount() != 1 || ((ComplexMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((ComplexMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((ComplexToken)rightArgument).complexValue();
        }
        Complex[][] result = ComplexMatrixMath.multiply(this._value, scalar);
        return new ComplexMatrixToken(result);
    }

    protected MatrixToken _subtract(MatrixToken rightArgument) throws IllegalActionException {
        ComplexMatrixToken convertedArgument = (ComplexMatrixToken)rightArgument;
        Complex[][] result = ComplexMatrixMath.subtract(this._value, convertedArgument._getInternalComplexMatrix());
        return new ComplexMatrixToken(result);
    }

    protected MatrixToken _subtractElement(Token rightArgument) throws IllegalActionException {
        Complex scalar;
        if (rightArgument instanceof ComplexMatrixToken) {
            if (((ComplexMatrixToken)rightArgument).getRowCount() != 1 || ((ComplexMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((ComplexMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((ComplexToken)rightArgument).complexValue();
        }
        Complex[][] result = ComplexMatrixMath.add(this._value, scalar.negate());
        return new ComplexMatrixToken(result);
    }

    protected MatrixToken _subtractElementReverse(Token rightArgument) throws IllegalActionException {
        Complex scalar;
        if (rightArgument instanceof ComplexMatrixToken) {
            if (((ComplexMatrixToken)rightArgument).getRowCount() != 1 || ((ComplexMatrixToken)rightArgument).getColumnCount() != 1) {
                return super._moduloElement(rightArgument);
            }
            scalar = ((ComplexMatrixToken)rightArgument).getElementAt(0, 0);
        } else {
            scalar = ((ComplexToken)rightArgument).complexValue();
        }
        Complex[][] result = ComplexMatrixMath.negative(ComplexMatrixMath.add(this._value, scalar.negate()));
        return new ComplexMatrixToken(result);
    }

    private void _initialize(Complex[][] value, int copy) {
        this._rowCount = value.length;
        this._columnCount = value[0].length;
        if (copy == 1) {
            this._value = value;
        } else {
            this._value = new Complex[value.length][value[0].length];
            int i = 0;
            while (i < value.length) {
                int j = 0;
                while (j < value[0].length) {
                    this._value[i][j] = value[i][j] != null ? value[i][j] : Complex.ZERO;
                    ++j;
                }
                ++i;
            }
        }
    }
}

