/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.actor.util.DependencyDeclaration;
import ptolemy.actor.util.ExplicitChangeContext;
import ptolemy.data.Token;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.Variable;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Node;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class ConstVariableModelAnalysis {
    private DirectedGraph _dependencyGraph;
    private Map _variableToChangeContext = new HashMap();

    public ConstVariableModelAnalysis() {
    }

    public ConstVariableModelAnalysis(Entity model) throws IllegalActionException {
        this(model, Collections.EMPTY_SET);
    }

    public ConstVariableModelAnalysis(Entity model, Set variableSet) throws IllegalActionException {
        for (Variable variable : variableSet) {
            this._variableToChangeContext.put(variable, model);
        }
        this._dependencyGraph = new DirectedGraph();
        this._collectConstraints(model);
        this._analyzeAllVariables();
    }

    public void addDependencyDeclaration(DependencyDeclaration declaration) {
        this._addDependencyDeclaration(declaration);
        this._analyzeAllVariables();
    }

    public static ConstVariableModelAnalysis getAnalysis(NamedObj object) throws IllegalActionException {
        if (object.toplevel() instanceof CompositeActor) {
            CompositeActor toplevel = (CompositeActor)object.toplevel();
            Manager manager = toplevel.getManager();
            ConstVariableModelAnalysis analysis = (ConstVariableModelAnalysis)manager.getAnalysis("ConstVariableModelAnalysis");
            if (analysis == null) {
                analysis = new ConstVariableModelAnalysis(toplevel);
                manager.addAnalysis("ConstVariableModelAnalysis", analysis);
            }
            return analysis;
        }
        return new ConstVariableModelAnalysis();
    }

    public Entity getChangeContext(Variable variable) {
        return (Entity)this._variableToChangeContext.get(variable);
    }

    public Token getConstantValue(Variable variable) throws IllegalActionException {
        if (!this.isConstant(variable)) {
            throw new IllegalActionException((Nameable)variable, "This variable does not have a constant value.");
        }
        return variable.getToken();
    }

    public Set getConstVariables(NamedObj container) {
        List variables = container.attributeList(Variable.class);
        variables.removeAll(this._variableToChangeContext.keySet());
        return new HashSet(variables);
    }

    public DirectedGraph getDependencyGraph() {
        return this._dependencyGraph;
    }

    public Set getNotConstVariables(NamedObj container) {
        List variables = container.attributeList(Variable.class);
        variables.removeAll(this.getConstVariables(container));
        return new HashSet(variables);
    }

    public Set getVariablesWithChangeContext(NamedObj container) {
        HashSet variableSet = new HashSet();
        for (Object key : this._variableToChangeContext.keySet()) {
            Object value = this._variableToChangeContext.get(key);
            if (value != container) continue;
            variableSet.add(key);
        }
        return variableSet;
    }

    public boolean isConstant(Variable variable) {
        return !this._variableToChangeContext.keySet().contains(variable);
    }

    public boolean isIndependent(Variable variable) {
        return this._dependencyGraph.backwardReachableNodes(this._dependencyGraph.node(variable)).size() <= 0;
    }

    private void _addDependencyDeclaration(DependencyDeclaration declaration) {
        Variable variable = (Variable)declaration.getContainer();
        Node targetNode = this._getNode(variable);
        for (Variable dependent : declaration.getDependents()) {
            Node dependentNode = this._getNode(dependent);
            this._dependencyGraph.addEdge(dependentNode, targetNode);
        }
    }

    private void _collectVariableConstraints(Variable variable) {
        Node targetNode = this._getNode(variable);
        try {
            Set freeIdentifiers = variable.getFreeIdentifiers();
            for (String name : freeIdentifiers) {
                Variable dependent = ModelScope.getScopedVariable(variable, variable, name);
                if (dependent == null) continue;
                Node dependentNode = this._getNode(dependent);
                this._dependencyGraph.addEdge(dependentNode, targetNode);
            }
        }
        catch (IllegalActionException illegalActionException) {
            this._updateChangeContext(variable, (Entity)variable.toplevel());
        }
    }

    private void _collectConstraints(NamedObj container) throws IllegalActionException {
        PortParameter parameter;
        Port port2;
        if (container instanceof Variable) {
            Variable variable = (Variable)container;
            this._collectVariableConstraints(variable);
        }
        if (container instanceof DependencyDeclaration) {
            DependencyDeclaration declaration = (DependencyDeclaration)container;
            this._addDependencyDeclaration(declaration);
        }
        if (container instanceof PortParameter && (port2 = (parameter = (PortParameter)container).getPort()) != null && port2.getWidth() > 0) {
            this._updateChangeContext(parameter, (Entity)parameter.getContainer());
        }
        if (container instanceof ExplicitChangeContext) {
            List list = ((ExplicitChangeContext)((Object)container)).getModifiedVariables();
            for (Variable variable : list) {
                this._updateChangeContext(variable, ((ExplicitChangeContext)((Object)container)).getContext());
            }
        }
        for (Attribute attribute : container.attributeList()) {
            this._collectConstraints(attribute);
        }
        if (container instanceof CompositeEntity) {
            CompositeEntity composite = (CompositeEntity)container;
            Iterator entities = composite.entityList().iterator();
            while (entities.hasNext()) {
                this._collectConstraints((Entity)entities.next());
            }
        }
        if (container instanceof Entity) {
            for (Port port2 : ((Entity)container).portList()) {
                this._collectConstraints(port2);
            }
        }
    }

    private void _analyzeAllVariables() {
        LinkedList workList = new LinkedList(this._variableToChangeContext.keySet());
        while (!workList.isEmpty()) {
            Variable variable = (Variable)workList.removeFirst();
            Node node = this._dependencyGraph.node(variable);
            Entity changeContext = (Entity)this._variableToChangeContext.get(variable);
            Iterator outputEdges = this._dependencyGraph.outputEdges(node).iterator();
            while (outputEdges.hasNext()) {
                Node sinkNode = ((Edge)outputEdges.next()).sink();
                Variable targetVariable = (Variable)sinkNode.getWeight();
                if (!this._updateChangeContext(targetVariable, changeContext) || workList.contains(targetVariable)) continue;
                workList.addLast(targetVariable);
            }
        }
    }

    private Node _getNode(Variable variable) {
        if (this._dependencyGraph.containsNodeWeight(variable)) {
            return this._dependencyGraph.node(variable);
        }
        return this._dependencyGraph.addNodeWeight(variable);
    }

    private final boolean _updateChangeContext(Variable variable, Entity changeContext) {
        if (this._variableToChangeContext.keySet().contains(variable)) {
            Entity oldChangeContext = (Entity)this._variableToChangeContext.get(variable);
            Entity newChangeContext = this._computeBound(changeContext, oldChangeContext);
            if (newChangeContext != oldChangeContext) {
                this._variableToChangeContext.put(variable, newChangeContext);
                return true;
            }
            return false;
        }
        this._variableToChangeContext.put(variable, changeContext);
        return true;
    }

    private final Entity _computeBound(Entity entity1, Entity entity2) {
        if (entity1 == null || entity2 == null) {
            return null;
        }
        if (entity2.equals(entity1)) {
            return entity1;
        }
        if (entity2.deepContains(entity1)) {
            return entity1;
        }
        if (entity1.deepContains(entity2)) {
            return entity2;
        }
        return null;
    }
}

