/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import java.util.HashSet;
import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.BranchController;
import ptolemy.actor.process.MailboxBoundaryReceiver;
import ptolemy.actor.process.ProcessDirector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.actor.util.Time;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class CompositeProcessDirector
extends ProcessDirector {
    private boolean _onFirstIteration = true;
    private BranchController _inputBranchController;
    private BranchController _outputBranchController;
    private boolean _inputControllerIsBlocked = true;
    private boolean _outputControllerIsBlocked = true;
    private HashSet _blockedReceivers = new HashSet();
    private Object _branchControllerLock = new Object();

    public CompositeProcessDirector() {
    }

    public CompositeProcessDirector(Workspace workspace) {
        super(workspace);
    }

    public CompositeProcessDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        CompositeProcessDirector newObj = (CompositeProcessDirector)super.clone(workspace);
        newObj._onFirstIteration = true;
        newObj._inputBranchController = null;
        newObj._outputBranchController = null;
        newObj._blockedReceivers = new HashSet();
        newObj._branchControllerLock = new Object();
        return newObj;
    }

    public void createBranchController(Iterator ports) throws IllegalActionException {
        IOPort port = null;
        while (ports.hasNext()) {
            port = (IOPort)ports.next();
            if (!port.isOpaque()) {
                throw new IllegalActionException((Nameable)this, port, "port argument is not an opaque port.");
            }
            if (port.isInput()) {
                this._inputBranchController.addBranches(port);
            }
            if (!port.isOutput()) continue;
            this._outputBranchController.addBranches(port);
        }
    }

    public BranchController getInputController() {
        return this._inputBranchController;
    }

    public BranchController getOutputController() {
        return this._outputBranchController;
    }

    public void initialize() throws IllegalActionException {
        CompositeActor container = (CompositeActor)this.getContainer();
        if (container != null) {
            CompositeActor containersContainer = (CompositeActor)container.getContainer();
            if (containersContainer == null) {
                this.setModelTime(new Time(this));
            } else {
                Time currentTime = containersContainer.getDirector().getModelTime();
                this.setModelTime(currentTime);
            }
        }
        this._blockedReceivers.clear();
        this._inputBranchController = new BranchController(container);
        this._outputBranchController = new BranchController(container);
        if (container != null) {
            Iterator ports = container.portList().iterator();
            this.createBranchController(ports);
        }
        this._inputControllerIsBlocked = this._inputBranchController.isBlocked();
        this._outputControllerIsBlocked = this._outputBranchController.isBlocked();
        super.initialize();
    }

    public Receiver newReceiver() {
        return new MailboxBoundaryReceiver();
    }

    public boolean prefire() throws IllegalActionException {
        super.prefire();
        Thread thread = null;
        if (this._inputBranchController.hasBranches() && this._onFirstIteration) {
            thread = new Thread(this._inputBranchController);
            thread.start();
        }
        if (this._outputBranchController.hasBranches() && this._onFirstIteration) {
            thread = new Thread(this._outputBranchController);
            thread.start();
        }
        this._onFirstIteration = false;
        return true;
    }

    public void setModelTime(Time newTime) throws IllegalActionException {
        if (this._debugging) {
            this._debug("----- Setting current time to " + newTime);
        }
        this._currentTime = newTime;
    }

    public void stopInputBranchController() {
        Workspace workspace = this.workspace();
        if (this._inputBranchController == null) {
            return;
        }
        if (!this._inputBranchController.hasBranches()) {
            return;
        }
        this._inputBranchController.deactivateBranches();
        while (!this._inputBranchController.isBlocked()) {
            try {
                workspace.wait(this);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void stopOutputBranchController() {
        Workspace workspace = this.workspace();
        if (this._outputBranchController == null) {
            return;
        }
        if (!this._outputBranchController.hasBranches()) {
            return;
        }
        this._outputBranchController.deactivateBranches();
        while (!this._outputBranchController.isBlocked()) {
            try {
                workspace.wait(this);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public synchronized void threadBlocked(Thread thread, ProcessReceiver receiver) {
        if (receiver != null) {
            this._blockedReceivers.add(receiver);
        }
        super.threadBlocked(thread, receiver);
    }

    public synchronized void threadUnblocked(Thread thread, ProcessReceiver receiver) {
        if (receiver != null) {
            this._blockedReceivers.remove(receiver);
        }
        super.threadUnblocked(thread, receiver);
    }

    public void wrapup() throws IllegalActionException {
        this.stopInputBranchController();
        this.stopOutputBranchController();
        if (this._debugging) {
            this._debug("Finished deactivating branches.");
        }
        super.wrapup();
    }

    protected boolean _areActorsExternallyBlocked() {
        for (ProcessReceiver receiver : this._blockedReceivers) {
            if (!receiver.isConnectedToBoundaryInside()) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean _areThreadsDeadlocked() {
        if (this._debugging) {
            this._debug("Checking for deadlock:");
            this._debug("There are " + this._getBlockedThreadsCount() + " Blocked actors, " + this._getStoppedThreadsCount() + " Stopped actors, and " + this._getActiveThreadsCount() + " active threads.");
        }
        return this._getBlockedThreadsCount() >= this._getActiveThreadsCount();
    }

    protected synchronized void _controllerBlocked(BranchController controller) {
        if (controller == this._inputBranchController) {
            this._inputControllerIsBlocked = controller.isBlocked();
        }
        if (controller == this._outputBranchController) {
            this._outputControllerIsBlocked = controller.isBlocked();
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _controllerUnBlocked(BranchController controller) {
        Object object = this._branchControllerLock;
        synchronized (object) {
            if (controller == this._inputBranchController) {
                this._inputControllerIsBlocked = controller.isBlocked();
            }
            if (controller == this._outputBranchController) {
                this._outputControllerIsBlocked = controller.isBlocked();
            }
        }
    }

    protected synchronized boolean _isInputControllerBlocked() {
        return this._inputControllerIsBlocked;
    }

    protected synchronized boolean _isOutputControllerBlocked() {
        return this._outputControllerIsBlocked;
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized boolean _resolveDeadlock() throws IllegalActionException {
        block17: {
            block18: {
                if (this._debugging) {
                    this._debug("Resolving Deadlock");
                }
                execDir = ((Actor)this.getContainer()).getExecutiveDirector();
                workspace = this.workspace();
                if (!this._areThreadsDeadlocked()) break block17;
                if (!this._areActorsExternallyBlocked()) break block18;
                if (this._inputBranchController.isBlocked()) {
                    while (!this._outputBranchController.isBlocked()) {
                        try {
                            workspace.wait(this);
                        }
                        catch (InterruptedException v0) {
                            throw new IllegalActionException((Nameable)this, "Interrupted.");
                        }
                    }
                    this.stopInputBranchController();
                    this.stopOutputBranchController();
                    if (execDir == null) {
                        throw new IllegalActionException((Nameable)this, "No executive director exists yet this director's composite actor is externally deadlocked.");
                    }
                    if (execDir instanceof CompositeProcessDirector) {
                        ((CompositeProcessDirector)execDir).threadBlocked(Thread.currentThread(), null);
                        return true;
                    }
                    return true;
                }
                if (this._outputBranchController.isBlocked()) {
                    this.stopInputBranchController();
                    this.stopOutputBranchController();
                    if (execDir == null) {
                        throw new IllegalActionException((Nameable)this, "No executive director exists yet this director's composite actor is externally deadlocked.");
                    }
                    if (execDir instanceof CompositeProcessDirector) {
                        ((CompositeProcessDirector)execDir).threadBlocked(Thread.currentThread(), null);
                        return true;
                    }
                    return true;
                }
                break block17;
            }
            if (this._inputBranchController.isBlocked()) {
                while (!this._outputBranchController.isBlocked()) {
                    try {
                        workspace.wait(this);
                    }
                    catch (InterruptedException v1) {
                        throw new IllegalActionException((Nameable)this, "Interrupted.");
                    }
                }
                this.stopInputBranchController();
                this.stopOutputBranchController();
                return this._resolveInternalDeadlock();
            }
            if (!this._outputBranchController.isBlocked()) ** GOTO lbl52
            this.stopInputBranchController();
            this.stopOutputBranchController();
            return this._resolveInternalDeadlock();
lbl-1000:
            // 1 sources

            {
                try {
                    workspace.wait(this);
                    continue;
                }
                catch (InterruptedException v2) {
                    throw new IllegalActionException((Nameable)this, "Interrupted.");
                }
lbl52:
                // 2 sources

                ** while (!this._outputBranchController.isBlocked())
            }
lbl53:
            // 1 sources

            this.stopInputBranchController();
            this.stopOutputBranchController();
            return this._resolveInternalDeadlock();
        }
        return false;
    }

    protected boolean _resolveInternalDeadlock() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Failed To Resolve Internal Deadlock: stopping");
        }
        return false;
    }
}

