/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.process;

import ptolemy.actor.process.BranchController;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class Branch
implements Runnable {
    private boolean _active = false;
    private BranchController _controller;
    private ProcessReceiver _producerReceiver;
    private ProcessReceiver _consumerReceiver;

    public Branch(BranchController controller) throws IllegalActionException {
        this._controller = controller;
    }

    public Branch(ProcessReceiver producerReceiver, ProcessReceiver consumerReceiver, BranchController controller) throws IllegalActionException {
        this._controller = controller;
        if (producerReceiver == null || consumerReceiver == null) {
            throw new IllegalActionException("The boundary receivers of this branch are null.");
        }
        if (!producerReceiver.isProducerReceiver()) {
            String name = consumerReceiver.getContainer().getFullName();
            throw new IllegalActionException("Receiver in the port: " + name + " is not a producer receiver");
        }
        this._producerReceiver = producerReceiver;
        if (!consumerReceiver.isConsumerReceiver()) {
            String name = consumerReceiver.getContainer().getFullName();
            throw new IllegalActionException("Receiver in the port: " + name + " is not a consumer receiver");
        }
        this._consumerReceiver = consumerReceiver;
    }

    public ProcessReceiver getConsumerReceiver() {
        return this._consumerReceiver;
    }

    public ProcessReceiver getProducerReceiver() {
        return this._producerReceiver;
    }

    public boolean isActive() {
        return this._active;
    }

    public void run() {
        try {
            try {
                this.setActive(true);
                while (this.isActive()) {
                    this.transferToken();
                }
            }
            catch (IllegalActionException exception) {
                throw new InternalErrorException(exception);
            }
        }
        finally {
            this._controller._getDirector().removeThread(Thread.currentThread());
        }
    }

    public void setActive(boolean value) {
        this._active = value;
    }

    public void transferToken() throws IllegalActionException {
        if (this._producerReceiver == null) {
            return;
        }
        if (this._consumerReceiver == null) {
            return;
        }
        Token token = this._producerReceiver.get();
        this._consumerReceiver.put(token);
    }
}

