/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Executable;
import ptolemy.actor.Initializable;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ScopeExtendingAttribute;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class ParameterSet
extends ScopeExtendingAttribute
implements Executable {
    public Parameter checkForFileUpdates;
    public FileParameter fileOrURL = new FileParameter(this, "fileOrURL");
    private long _date = 0L;
    private String _fileName;
    private transient List<Initializable> _initializables;
    private Properties _properties;

    public ParameterSet(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.fileOrURL.setExpression("");
        this.checkForFileUpdates = new Parameter(this, "checkForFileUpdates");
        this.checkForFileUpdates.setExpression("false");
        this.checkForFileUpdates.setTypeEquals(BaseType.BOOLEAN);
        StringParameter initialDefaultContents = new StringParameter(this, "initialDefaultContents");
        initialDefaultContents.setExpression("# This file defines parameters in the current container.\n# Each non-comment line in the file is interpreted as a separate assignment.\n# The lines are of the form:\n# attributeName = value\n# where variableName is the name of the attribute\n# in a format suitable for ptolemy.kernel.util.NamedObj.setName()\n# (i.e., does not contain periods) and value is\n# the expression in the Ptolemy expression language.\n# Comments are lines that begin with the # character.\n# FIXME: After saving, you need to update the fileOrURLParameter by hand.\n# Sample line (remove the leading #):\n# foo = \"bar\"\n");
        initialDefaultContents.setPersistent(false);
        initialDefaultContents.setVisibility(Settable.EXPERT);
    }

    public void addInitializable(Initializable initializable) {
        if (this._initializables == null) {
            this._initializables = new LinkedList<Initializable>();
        }
        this._initializables.add(initializable);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileOrURL) {
            if (!this.fileOrURL.getExpression().equals(this._fileName)) {
                try {
                    this.read();
                }
                catch (Exception exception) {
                    throw new IllegalActionException((Nameable)this, exception, "Failed to read file: " + this.fileOrURL.getExpression());
                }
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
    }

    public void initialize() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.initialize();
            }
        }
    }

    public boolean isFireFunctional() {
        return true;
    }

    public boolean isStrict() {
        return false;
    }

    public int iterate(int count) throws IllegalActionException {
        if (((BooleanToken)this.checkForFileUpdates.getToken()).booleanValue()) {
            this._reReadIfNeeded();
        }
        return 0;
    }

    public boolean postfire() {
        return true;
    }

    public boolean prefire() throws IllegalActionException {
        if (((BooleanToken)this.checkForFileUpdates.getToken()).booleanValue()) {
            this._reReadIfNeeded();
        }
        return true;
    }

    public void preinitialize() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.preinitialize();
            }
        }
        this._reReadIfNeeded();
    }

    public void read() throws IllegalActionException, NameDuplicationException, IOException {
        this._fileName = this.fileOrURL.getExpression();
        if (this._fileName == null || this._fileName.trim().equals("")) {
            if (this._properties != null) {
                for (String string : this._properties.keySet()) {
                    this.getAttribute(string).setContainer(null);
                }
                this._properties = null;
            }
            return;
        }
        URL url = this.fileOrURL.asURL();
        if (url == null) {
            throw new IOException("Could not convert \"" + this.fileOrURL.getExpression() + "\" with base \"" + this.fileOrURL.getBaseDirectory() + "\" to a URL.");
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            properties.load(url.openStream());
            this._date = connection.getDate();
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (this._properties != null) {
            for (String string : this._properties.keySet()) {
                if (properties.containsKey(string)) continue;
                this.getAttribute(string).setContainer(null);
            }
        }
        this._properties = properties;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String attributeName = (String)entry.getKey();
            String attributeValue = (String)entry.getValue();
            Variable variable = (Variable)this.getAttribute(attributeName);
            if (variable == null) {
                variable = new Variable(this, attributeName);
            }
            variable.setExpression(attributeValue);
        }
        this.validateSettables();
    }

    public void removeInitializable(Initializable initializable) {
        if (this._initializables != null) {
            this._initializables.remove(initializable);
            if (this._initializables.size() == 0) {
                this._initializables = null;
            }
        }
    }

    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        NamedObj previousContainer;
        if (container != this.getContainer() && (previousContainer = this.getContainer()) instanceof CompositeActor) {
            ((CompositeActor)previousContainer).removePiggyback(this);
        }
        super.setContainer(container);
        while (container != null) {
            if (container instanceof CompositeActor && ((CompositeActor)container).isOpaque()) {
                ((CompositeActor)container).addPiggyback(this);
                break;
            }
            container = container.getContainer();
        }
    }

    public void stop() {
    }

    public void stopFire() {
    }

    public void terminate() {
    }

    public void wrapup() throws IllegalActionException {
        if (this._initializables != null) {
            for (Initializable initializable : this._initializables) {
                initializable.preinitialize();
            }
        }
        this._reReadIfNeeded();
    }

    private void _reReadIfNeeded() throws IllegalActionException {
        try {
            String currentFileName = this.fileOrURL.getExpression();
            if (!currentFileName.equals(this._fileName)) {
                this.read();
                return;
            }
            URL url = this.fileOrURL.asURL();
            if (url == null) {
                throw new IOException("Could not convert \"" + this.fileOrURL.getExpression() + "\" with base \"" + this.fileOrURL.getBaseDirectory() + "\" to a URL.");
            }
            long date = url.openConnection().getDate();
            if (date == 0L || date != this._date) {
                this.read();
            }
        }
        catch (NameDuplicationException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to re-read parameter set, problem with dupliate names.");
        }
        catch (IOException ex2) {
            throw new IllegalActionException((Nameable)this, ex2, "Failed to re-read parameter set.");
        }
    }
}

