/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.LongToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Sleep
extends Transformer {
    public PortParameter sleepTime = new PortParameter(this, "sleepTime");
    private boolean _wasSleepCalledInFireYet = false;

    public Sleep(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.sleepTime.setExpression("0L");
        this.sleepTime.setTypeEquals(BaseType.LONG);
        ParameterPort sleepPort = this.sleepTime.getPort();
        StringAttribute sleepCardinal = new StringAttribute(sleepPort, "_cardinal");
        sleepCardinal.setExpression("SOUTH");
        this.input.setMultiport(true);
        this.output.setMultiport(true);
        this.output.setTypeAtLeast(this.input);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Sleep newObject = (Sleep)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        if (!this._wasSleepCalledInFireYet) {
            this._wasSleepCalledInFireYet = true;
            super.fire();
            this.sleepTime.update();
            int inputWidth = this.input.getWidth();
            Token[] inputs = new Token[inputWidth];
            int i = 0;
            while (i < inputWidth) {
                if (this.input.hasToken(i)) {
                    inputs[i] = this.input.get(i);
                }
                ++i;
            }
            try {
                long sleepTimeValue = ((LongToken)this.sleepTime.getToken()).longValue();
                if (this._debugging) {
                    this._debug(String.valueOf(this.getName()) + ": Wait for " + sleepTimeValue + " milliseconds.");
                }
                Thread.sleep(sleepTimeValue);
            }
            catch (InterruptedException interruptedException) {}
            int outputWidth = this.output.getWidth();
            int i2 = 0;
            while (i2 < inputWidth) {
                if (inputs[i2] != null && i2 < outputWidth) {
                    this.output.send(i2, inputs[i2]);
                }
                ++i2;
            }
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._wasSleepCalledInFireYet = false;
    }

    public boolean postfire() throws IllegalActionException {
        this._wasSleepCalledInFireYet = false;
        return super.postfire();
    }
}

