/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.util.Time;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class SequentialClock
extends TypedAtomicActor
implements SequenceActor {
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public Parameter offsets;
    public Parameter period = new Parameter((NamedObj)this, "period", new DoubleToken(2.0));
    public Parameter values;
    private transient Token _currentValue;
    private transient Time _cycleStartTime;
    private boolean _firstFiring = true;
    private transient double[] _offsets;
    private transient int _phase;

    public SequentialClock(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.period.setTypeEquals(BaseType.DOUBLE);
        this.offsets = new Parameter(this, "offsets");
        this.offsets.setExpression("{0.0, 1.0}");
        this.offsets.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.attributeChanged(this.offsets);
        Token[] defaultValues = new IntToken[]{new IntToken(1), new IntToken(0)};
        ArrayToken defaultValueToken = new ArrayToken(BaseType.INT, defaultValues);
        this.values = new Parameter((NamedObj)this, "values", defaultValueToken);
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
        this.attributeChanged(this.values);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.offsets) {
            ArrayToken offsetsValue = (ArrayToken)this.offsets.getToken();
            this._offsets = new double[offsetsValue.length()];
            double previous = 0.0;
            int i = 0;
            while (i < offsetsValue.length()) {
                this._offsets[i] = ((DoubleToken)offsetsValue.getElement(i)).doubleValue();
                if (this._offsets[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of offsets is not nondecreasing and nonnegative.");
                }
                previous = this._offsets[i];
                ++i;
            }
        } else if (attribute == this.period) {
            double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
            if (periodValue <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Period is required to be positive.  Period given: " + periodValue);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SequentialClock newObject = (SequentialClock)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.output.send(0, this._currentValue);
    }

    public synchronized void initialize() throws IllegalActionException {
        super.initialize();
        this._firstFiring = true;
        this._phase = 0;
        Time currentTime = this.getDirector().getModelTime();
        Time nextFiringTime = currentTime.add(this._offsets[0]);
        this.getDirector().fireAt((Actor)this, nextFiringTime);
    }

    public boolean postfire() throws IllegalActionException {
        double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
        if (this._firstFiring) {
            this._cycleStartTime = this.getDirector().getModelTime();
            this._firstFiring = false;
        }
        ++this._phase;
        if (this._phase >= this._offsets.length) {
            this._phase = 0;
            this._cycleStartTime = this._cycleStartTime.add(periodValue);
        }
        if (this._offsets[this._phase] >= periodValue) {
            throw new IllegalActionException((Nameable)this, "Offset number " + this._phase + " with value " + this._offsets[this._phase] + " must be less than the " + "period, which is " + periodValue);
        }
        Time nextIterationTime = this._cycleStartTime.add(this._offsets[this._phase]);
        this.getDirector().fireAt((Actor)this, nextIterationTime);
        return true;
    }

    public boolean prefire() throws IllegalActionException {
        ArrayToken val = (ArrayToken)this.values.getToken();
        if (val == null || val.length() <= this._phase) {
            throw new IllegalActionException((Nameable)this, "Offsets and values parameters lengths do not match.");
        }
        this._currentValue = val.getElement(this._phase);
        return true;
    }
}

