/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class RecursiveLattice
extends Transformer {
    public Parameter reflectionCoefficients;
    private double[] _backward = null;
    private double[] _backwardCache = null;
    private double[] _forward = null;
    private double[] _forwardCache = null;
    private double[] _reflectionCoefs = null;

    public RecursiveLattice(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.reflectionCoefficients = new Parameter(this, "reflectionCoefficients");
        this.reflectionCoefficients.setExpression("{0.804534, -0.820577, 0.521934, -0.205}");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.reflectionCoefficients) {
            ArrayToken value = (ArrayToken)this.reflectionCoefficients.getToken();
            int valueLength = value.length();
            if (this._backward == null || valueLength != this._backward.length - 1) {
                this._backward = new double[valueLength + 1];
                this._backwardCache = new double[valueLength + 1];
                this._forward = new double[valueLength + 1];
                this._forwardCache = new double[valueLength + 1];
                this._reflectionCoefs = new double[valueLength];
            }
            int i = 0;
            while (i < valueLength) {
                this._reflectionCoefs[i] = ((DoubleToken)value.getElement(i)).doubleValue();
                ++i;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            double k;
            DoubleToken inputValue = (DoubleToken)this.input.get(0);
            int M = this._backward.length - 1;
            this._forwardCache[0] = inputValue.doubleValue();
            int i = 1;
            while (i <= M) {
                k = this._reflectionCoefs[M - i];
                this._forwardCache[i] = k * this._backwardCache[i] + this._forwardCache[i - 1];
                ++i;
            }
            this.output.broadcast(new DoubleToken(this._forwardCache[M]));
            i = 1;
            while (i < M) {
                k = -this._reflectionCoefs[M - 1 - i];
                this._backwardCache[i] = this._backwardCache[i + 1] + k * this._forwardCache[i + 1];
                ++i;
            }
            this._backwardCache[M] = this._forwardCache[M];
        }
    }

    public void initialize() throws IllegalActionException {
        int i = 0;
        while (i < this._forward.length) {
            this._forward[i] = 0.0;
            this._forwardCache[i] = 0.0;
            this._backward[i] = 0.0;
            this._backwardCache[i] = 0.0;
            ++i;
        }
    }

    public boolean postfire() throws IllegalActionException {
        System.arraycopy(this._backwardCache, 0, this._backward, 0, this._backwardCache.length);
        System.arraycopy(this._forwardCache, 0, this._forward, 0, this._forwardCache.length);
        return super.postfire();
    }

    public boolean prefire() throws IllegalActionException {
        System.arraycopy(this._backward, 0, this._backwardCache, 0, this._backwardCache.length);
        System.arraycopy(this._forward, 0, this._forwardCache, 0, this._forwardCache.length);
        return super.prefire();
    }
}

