/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class Average
extends Transformer {
    public TypedIOPort reset = new TypedIOPort(this, "reset", true, false);
    private Token _sum;
    private Token _latestSum;
    private int _count = 0;
    private int _latestCount;

    public Average(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.reset.setTypeEquals(BaseType.BOOLEAN);
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this._latestSum = this._sum;
        this._latestCount = this._count;
        int i = 0;
        while (i < this.reset.getWidth()) {
            BooleanToken r;
            if (this.reset.hasToken(i) && (r = (BooleanToken)this.reset.get(i)).booleanValue()) {
                this._latestSum = null;
                this._latestCount = 0;
            }
            ++i;
        }
        if (this.input.hasToken(0)) {
            Token in = this.input.get(0);
            ++this._latestCount;
            this._latestSum = this._latestSum == null ? in : this._latestSum.add(in);
            Token out = this._latestSum.divide(new IntToken(this._latestCount));
            this.output.broadcast(out);
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._count = 0;
        this._sum = null;
    }

    public boolean postfire() throws IllegalActionException {
        this._sum = this._latestSum;
        this._count = this._latestCount;
        return super.postfire();
    }
}

