/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.ActorFiringListener;
import ptolemy.actor.Director;
import ptolemy.actor.Executable;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.FiringsRecordable;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.Initializable;
import ptolemy.actor.Manager;
import ptolemy.actor.Receiver;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.util.FunctionDependency;
import ptolemy.actor.util.FunctionDependencyOfCompositeActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class CompositeActor
extends CompositeEntity
implements Actor,
FiringsRecordable {
    protected LinkedList _actorFiringListeners = null;
    protected FunctionDependency _functionDependency;
    protected transient List<Initializable> _initializables;
    protected boolean _notifyingActorFiring = false;
    protected boolean _stopRequested = false;
    private Director _director;
    private boolean _inConnectionsChanged = false;
    private Manager _manager;
    private transient long _inputPortsVersion = -1L;
    private transient List _cachedInputPorts;
    private transient long _outputPortsVersion = -1L;
    private transient List _cachedOutputPorts;
    private transient List _piggybacks;
    private long _receiversVersion = -1L;

    public CompositeActor() {
    }

    public CompositeActor(Workspace workspace) {
        super(workspace);
    }

    public CompositeActor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActorFiringListener(ActorFiringListener listener) {
        Cloneable cloneable = this;
        synchronized (cloneable) {
            if (this._actorFiringListeners == null) {
                this._actorFiringListeners = new LinkedList();
            }
        }
        cloneable = this._actorFiringListeners;
        synchronized (cloneable) {
            if (this._actorFiringListeners.contains(listener)) {
                return;
            }
            this._actorFiringListeners.add(listener);
            this._notifyingActorFiring = true;
        }
    }

    public void addInitializable(Initializable initializable) {
        if (this._initializables == null) {
            this._initializables = new LinkedList<Initializable>();
        }
        this._initializables.add(initializable);
    }

    public void addPiggyback(Executable piggyback) {
        if (this._piggybacks == null) {
            this._piggybacks = new LinkedList();
        }
        this._piggybacks.add(piggyback);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        CompositeActor newObject = (CompositeActor)super.clone(workspace);
        newObject._inputPortsVersion = -1L;
        newObject._outputPortsVersion = -1L;
        newObject._functionDependency = null;
        return newObject;
    }

    public void connectionsChanged(Port port) {
        IOPort castPort;
        if (this._debugging) {
            this._debug("Connections changed on port: " + port.getName());
        }
        super.connectionsChanged(port);
        if (port instanceof ComponentPort) {
            Iterator insidePorts = ((ComponentPort)port).insidePortList().iterator();
            try {
                this._inConnectionsChanged = true;
                while (insidePorts.hasNext()) {
                    ComponentPort insidePort = (ComponentPort)insidePorts.next();
                    Entity portContainer = (Entity)insidePort.getContainer();
                    if (portContainer instanceof CompositeActor && ((CompositeActor)portContainer)._inConnectionsChanged) continue;
                    portContainer.connectionsChanged(insidePort);
                }
            }
            finally {
                this._inConnectionsChanged = false;
            }
        }
        if (port instanceof IOPort && (castPort = (IOPort)port).isOpaque()) {
            if (castPort.isOutput() && this.getDirector() != null) {
                try {
                    castPort.createReceivers();
                }
                catch (IllegalActionException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "Cannot create receivers");
                }
            }
            if (castPort.isInput() && this.getExecutiveDirector() != null) {
                try {
                    castPort.createReceivers();
                }
                catch (IllegalActionException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, "Cannot create receivers");
                }
            }
            if (this.getDirector() != null) {
                this.getDirector().invalidateSchedule();
                this.getDirector().invalidateResolvedTypes();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling fire()");
        }
        try {
            IOPort p;
            this._workspace.getReadAccess();
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    piggyback.fire();
                }
            }
            if (!this.isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Cannot fire a non-opaque actor.");
            }
            Iterator inputPorts = this.inputPortList().iterator();
            while (inputPorts.hasNext() && !this._stopRequested) {
                p = (IOPort)inputPorts.next();
                if (!(p instanceof ParameterPort)) continue;
                ((ParameterPort)p).getParameter().update();
            }
            inputPorts = this.inputPortList().iterator();
            while (inputPorts.hasNext() && !this._stopRequested) {
                p = (IOPort)inputPorts.next();
                if (p instanceof ParameterPort) continue;
                this._director.transferInputs(p);
            }
            if (this._stopRequested) {
                return;
            }
            this._director.fire();
            if (this._stopRequested) {
                return;
            }
            Iterator outports = this.outputPortList().iterator();
            while (outports.hasNext() && !this._stopRequested) {
                p = (IOPort)outports.next();
                this._director.transferOutputs(p);
            }
        }
        finally {
            this._workspace.doneReading();
        }
        if (!this._debugging) return;
        this._debug("Called fire()");
    }

    public Director getDirector() {
        try {
            this._workspace.getReadAccess();
            if (this._director != null) {
                Director director = this._director;
                return director;
            }
            NamedObj container = this.getContainer();
            if (container instanceof Actor) {
                Director director = ((Actor)((Object)container)).getDirector();
                return director;
            }
            return null;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public Director getExecutiveDirector() {
        try {
            this._workspace.getReadAccess();
            NamedObj container = this.getContainer();
            if (container instanceof Actor) {
                Director director = ((Actor)((Object)container)).getDirector();
                return director;
            }
            return null;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public FunctionDependency getFunctionDependency() {
        if (this._functionDependency == null) {
            try {
                this._functionDependency = new FunctionDependencyOfCompositeActor(this);
            }
            catch (NameDuplicationException nameDuplicationException) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
            catch (IllegalActionException illegalActionException) {
                throw new InternalErrorException("Failed to construct a function dependency object for " + this.getFullName());
            }
        }
        return this._functionDependency;
    }

    public Manager getManager() {
        try {
            this._workspace.getReadAccess();
            if (this._manager != null) {
                Manager manager = this._manager;
                return manager;
            }
            NamedObj container = this.getContainer();
            if (container instanceof Actor) {
                Manager manager = ((Actor)((Object)container)).getManager();
                return manager;
            }
            return null;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void initialize() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called initialize()");
        }
        this._receiversVersion = this.workspace().getVersion();
        try {
            this._workspace.getReadAccess();
            if (this._initializables != null) {
                for (Initializable initializable : this._initializables) {
                    initializable.initialize();
                }
            }
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    piggyback.initialize();
                }
            }
            if (!this.isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Cannot initialize a non-opaque actor.");
            }
            for (Entity actor : this.deepEntityList()) {
                for (IOPort port : actor.portList()) {
                    if (!port.isInput()) continue;
                    Receiver[][] receivers = port.getReceivers();
                    if (receivers == null) {
                        throw new InternalErrorException(this, null, "port.getReceivers() returned null! This should never happen. port was '" + port + "'");
                    }
                    int i = 0;
                    while (i < receivers.length) {
                        Receiver[] receivers2 = receivers[i];
                        int j = 0;
                        while (j < receivers2.length) {
                            receivers2[j].reset();
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            for (IOPort port : this.portList()) {
                if (!port.isOutput()) continue;
                Receiver[][] receivers = port.getInsideReceivers();
                int i = 0;
                while (i < receivers.length) {
                    Receiver[] receivers2 = receivers[i];
                    int j = 0;
                    while (j < receivers2.length) {
                        receivers2[j].reset();
                        ++j;
                    }
                    ++i;
                }
            }
            this.getDirector().initialize();
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public List inputPortList() {
        try {
            this._workspace.getReadAccess();
            if (this._inputPortsVersion != this._workspace.getVersion()) {
                LinkedList<IOPort> inputPorts = new LinkedList<IOPort>();
                for (IOPort p : this.portList()) {
                    if (!p.isInput()) continue;
                    inputPorts.add(p);
                }
                this._cachedInputPorts = inputPorts;
                this._inputPortsVersion = this._workspace.getVersion();
            }
            List list = this._cachedInputPorts;
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean isFireFunctional() {
        if (this.isOpaque()) {
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    if (piggyback.isFireFunctional()) continue;
                    return false;
                }
            }
            return this.getDirector().isFireFunctional();
        }
        return true;
    }

    public boolean isOpaque() {
        return this._director != null;
    }

    public boolean isStrict() {
        if (this.isOpaque()) {
            return this.getDirector().isStrict();
        }
        return true;
    }

    public int iterate(int count) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called iterate(" + count + ")");
        }
        boolean stopIterating = false;
        if (this._piggybacks != null) {
            for (Executable piggyback : this._piggybacks) {
                int result = piggyback.iterate(count);
                if (result == 1) {
                    return 1;
                }
                if (result != 2) continue;
                stopIterating = true;
            }
        }
        int n = 0;
        while (n++ < count && !this._stopRequested) {
            if (this._notifyingActorFiring) {
                this._actorFiring(FiringEvent.BEFORE_PREFIRE, n);
            }
            if (this.prefire()) {
                if (this._notifyingActorFiring) {
                    this._actorFiring(FiringEvent.AFTER_PREFIRE, n);
                    this._actorFiring(FiringEvent.BEFORE_FIRE, n);
                }
                this.fire();
                if (this._notifyingActorFiring) {
                    this._actorFiring(FiringEvent.AFTER_FIRE, n);
                    this._actorFiring(FiringEvent.BEFORE_POSTFIRE, n);
                }
                boolean pfire = this.postfire();
                if (this._notifyingActorFiring) {
                    this._actorFiring(FiringEvent.AFTER_POSTFIRE, n);
                }
                if (pfire) continue;
                return 2;
            }
            if (this._notifyingActorFiring) {
                this._actorFiring(FiringEvent.AFTER_PREFIRE, n);
            }
            return 1;
        }
        if (this._stopRequested || stopIterating) {
            return 2;
        }
        return 0;
    }

    public Receiver newInsideReceiver() throws IllegalActionException {
        if (this._director == null) {
            throw new IllegalActionException((Nameable)this, "Cannot create a receiver without a director.");
        }
        return this._director.newReceiver();
    }

    public Port newPort(String name) throws NameDuplicationException {
        try {
            IOPort port;
            this._workspace.getWriteAccess();
            IOPort iOPort = port = new IOPort(this, name);
            return iOPort;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public Receiver newReceiver() throws IllegalActionException {
        Director director = this.getExecutiveDirector();
        if (director == null) {
            throw new IllegalActionException((Nameable)this, "Cannot create a receiver without an executive director.");
        }
        return director.newReceiver();
    }

    public ComponentRelation newRelation(String name) throws IllegalActionException, NameDuplicationException {
        try {
            IORelation relation;
            this._workspace.getWriteAccess();
            IORelation iORelation = relation = new IORelation(this, name);
            return iORelation;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public List outputPortList() {
        try {
            this._workspace.getReadAccess();
            if (this._outputPortsVersion != this._workspace.getVersion()) {
                this._cachedOutputPorts = new LinkedList();
                for (IOPort p : this.portList()) {
                    if (!p.isOutput()) continue;
                    this._cachedOutputPorts.add(p);
                }
                this._outputPortsVersion = this._workspace.getVersion();
            }
            List list = this._cachedOutputPorts;
            return list;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean postfire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling postfire()");
        }
        try {
            this._workspace.getReadAccess();
            if (!this.isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Cannot postfire a non-opaque actor.");
            }
            boolean result = true;
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    boolean bl = result = result && piggyback.postfire();
                }
            }
            boolean bl = result = result && this.getDirector().postfire();
            if (this._debugging) {
                this._debug("Postfire returns " + result);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("CompositeActor: Calling prefire()");
        }
        try {
            this._workspace.getReadAccess();
            if (!this.isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Cannot invoke prefire on a non-opaque actor,  please add a director.");
            }
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    if (piggyback.prefire()) continue;
                    if (this._debugging) {
                        this._debug("CompositeActor: prefire returns false due to piggybacked object.");
                    }
                    return false;
                }
            }
            boolean result = this.getDirector().prefire();
            if (this._debugging) {
                this._debug("CompositeActor: prefire returns: " + result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void preinitialize() throws IllegalActionException {
        this._functionDependency = null;
        this._stopRequested = false;
        if (this._debugging) {
            this._debug("Called preinitialize()");
        }
        try {
            this._workspace.getReadAccess();
            if (this._initializables != null) {
                for (Initializable initializable : this._initializables) {
                    initializable.preinitialize();
                }
            }
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    piggyback.preinitialize();
                }
            }
            if (this.workspace().getVersion() != this._receiversVersion) {
                this._createReceivers();
            }
            if (!this.isOpaque()) {
                if (this.getContainer() == null && this.deepEntityList().size() == 0) {
                    throw new IllegalActionException((Nameable)this, "Cannot preinitialize an empty model, please add actors and a director.");
                }
                throw new IllegalActionException((Nameable)this, "Cannot preinitialize a non-opaque actor, please add a director.");
            }
            if (this._director == null) {
                throw new InternalErrorException("Actor says it is opaque, but it has no director: " + this.getFullName());
            }
            this.getDirector().preinitialize();
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void recordFiring(FiringEvent.FiringEventType type) {
        this._actorFiring(new FiringEvent(null, this, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActorFiringListener(ActorFiringListener listener) {
        if (this._actorFiringListeners == null) {
            return;
        }
        LinkedList linkedList = this._actorFiringListeners;
        synchronized (linkedList) {
            this._actorFiringListeners.remove(listener);
            if (this._actorFiringListeners.size() == 0) {
                this._notifyingActorFiring = false;
            }
            return;
        }
    }

    public void removeInitializable(Initializable initializable) {
        if (this._initializables != null) {
            this._initializables.remove(initializable);
            if (this._initializables.size() == 0) {
                this._initializables = null;
            }
        }
    }

    public void removePiggyback(Executable piggyback) {
        if (this._piggybacks != null) {
            this._piggybacks.remove(piggyback);
            if (this._piggybacks.size() == 0) {
                this._piggybacks = null;
            }
        }
    }

    public void requestChange(ChangeRequest change) {
        Manager manager = this.getManager();
        if (manager != null) {
            this.stopFire();
        }
        super.requestChange(change);
    }

    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        Director oldDirector = this.getDirector();
        if (oldDirector != null) {
            oldDirector.invalidateSchedule();
            oldDirector.invalidateResolvedTypes();
        }
        super.setContainer(container);
        Director director = this.getDirector();
        if (director != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        }
    }

    public void setDirector(Director director) throws IllegalActionException, NameDuplicationException {
        if (director != null) {
            director.setContainer(this);
        } else {
            this._setDirector(null);
        }
    }

    public void setManager(Manager manager) throws IllegalActionException {
        if (manager != null && this._workspace != manager.workspace()) {
            throw new IllegalActionException((Nameable)this, manager, "Cannot set manager because workspaces are different.manager: " + manager.workspace() + ", " + this._workspace);
        }
        try {
            this._workspace.getWriteAccess();
            if (this.getContainer() != null && manager != null) {
                throw new IllegalActionException((Nameable)this, manager, "Cannot set the Manager of an actor with a container.");
            }
            if (this._manager != null) {
                this._manager.removeDebugListener(this);
                this._manager._makeManagerOf(null);
            }
            if (manager != null) {
                manager.addDebugListener(this);
                manager._makeManagerOf(this);
            }
            this._manager = manager;
            return;
        }
        finally {
            this._workspace.doneWriting();
        }
    }

    public void stop() {
        if (this._debugging) {
            this._debug("Called stop()");
        }
        try {
            this._workspace.getReadAccess();
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    piggyback.stop();
                }
            }
            this._stopRequested = true;
            if (!this.isOpaque()) {
                return;
            }
            Director director = this.getDirector();
            if (director != null) {
                director.stop();
            }
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void stopFire() {
        if (this._debugging) {
            this._debug("Called stopFire()");
        }
        try {
            this._workspace.getReadAccess();
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    piggyback.stopFire();
                }
            }
            if (!this.isOpaque()) {
                return;
            }
            Director director = this.getDirector();
            if (director != null) {
                director.stopFire();
            }
        }
        finally {
            this._workspace.doneReading();
        }
    }

    public void terminate() {
        if (this._debugging) {
            this._debug("Called terminate()");
        }
        if (this._piggybacks != null) {
            for (Executable piggyback : this._piggybacks) {
                piggyback.terminate();
            }
        }
        if (!this.isOpaque()) {
            return;
        }
        this.getDirector().terminate();
    }

    public void wrapup() throws IllegalActionException {
        if (this._debugging) {
            this._debug("Called wrapup()");
        }
        try {
            this._workspace.getReadAccess();
            if (this._initializables != null) {
                for (Initializable initializable : this._initializables) {
                    initializable.wrapup();
                }
            }
            if (this._piggybacks != null) {
                for (Executable piggyback : this._piggybacks) {
                    piggyback.wrapup();
                }
            }
            if (!this.isOpaque()) {
                throw new IllegalActionException((Nameable)this, "Missing director.");
            }
            Director director = this.getDirector();
            if (director != null) {
                director.wrapup();
            }
        }
        finally {
            this._workspace.doneReading();
        }
    }

    protected final void _actorFiring(FiringEvent event) {
        if (this._notifyingActorFiring) {
            Iterator listeners = this._actorFiringListeners.iterator();
            while (listeners.hasNext()) {
                ((ActorFiringListener)listeners.next()).firingEvent(event);
            }
        }
    }

    protected final void _actorFiring(FiringEvent.FiringEventType type, int multiplicity) {
        this._actorFiring(new FiringEvent(null, this, type, multiplicity));
    }

    protected void _addEntity(ComponentEntity entity) throws IllegalActionException, NameDuplicationException {
        if (!(entity instanceof Actor)) {
            throw new IllegalActionException((Nameable)this, entity, "CompositeActor can only contain entities that  implement the Actor interface.");
        }
        super._addEntity(entity);
    }

    protected void _addPort(Port port) throws IllegalActionException, NameDuplicationException {
        if (!(port instanceof IOPort)) {
            throw new IllegalActionException((Nameable)this, port, "CompositeActor can only contain instances of IOPort.");
        }
        super._addPort(port);
    }

    protected void _addRelation(ComponentRelation relation) throws IllegalActionException, NameDuplicationException {
        if (!(relation instanceof IORelation)) {
            throw new IllegalActionException((Nameable)this, relation, "CompositeActor can only contain instances of IORelation.");
        }
        super._addRelation(relation);
    }

    protected void _createReceivers() throws IllegalActionException {
        Iterator ports = this.portList().iterator();
        try {
            this.workspace().getWriteAccess();
            while (ports.hasNext()) {
                IOPort onePort = (IOPort)ports.next();
                onePort.createReceivers();
            }
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    protected void _finishedAddEntity(ComponentEntity entity) {
        Director director = this.getDirector();
        if (director != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
            director.requestInitialization((Actor)((Object)entity));
        }
    }

    protected void _setDirector(Director director) throws IllegalActionException, NameDuplicationException {
        Director oldDirector = this.getDirector();
        if (oldDirector != null) {
            oldDirector.invalidateSchedule();
            oldDirector.invalidateResolvedTypes();
        }
        this._director = director;
        if (director != null) {
            director.invalidateSchedule();
            director.invalidateResolvedTypes();
        } else {
            Director executiveDirector = this.getExecutiveDirector();
            if (executiveDirector != null) {
                executiveDirector.invalidateSchedule();
            }
        }
    }
}

