/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.util.Time;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public abstract class AbstractReceiver
implements Receiver {
    private IOPort _container;
    private Token[] _tokenCache;

    public AbstractReceiver() {
    }

    public AbstractReceiver(IOPort container) throws IllegalActionException {
        this.setContainer(container);
    }

    public void clear() throws IllegalActionException {
        throw new IllegalActionException((Nameable)this.getContainer(), "Receiver class " + this.getClass().getName() + " does not support clear().");
    }

    public abstract Token get() throws NoTokenException;

    public Token[] getArray(int numberOfTokens) throws NoTokenException {
        if (this._tokenCache == null || numberOfTokens != this._tokenCache.length) {
            this._tokenCache = new Token[numberOfTokens];
        }
        int i = 0;
        while (i < numberOfTokens) {
            this._tokenCache[i] = this.get();
            ++i;
        }
        return this._tokenCache;
    }

    public IOPort getContainer() {
        return this._container;
    }

    public double getCurrentTime() {
        return this.getModelTime().getDoubleValue();
    }

    public Time getModelTime() {
        IOPort containerPort = this.getContainer();
        Actor containerActor = (Actor)((Object)containerPort.getContainer());
        Director containerDirector = containerActor.getDirector();
        return containerDirector.getModelTime();
    }

    public abstract boolean hasRoom();

    public abstract boolean hasRoom(int var1);

    public abstract boolean hasToken();

    public abstract boolean hasToken(int var1);

    public boolean isKnown() {
        return true;
    }

    public abstract void put(Token var1) throws NoRoomException, IllegalActionException;

    public void putArray(Token[] tokenArray, int numberOfTokens) throws NoRoomException, IllegalActionException {
        IOPort container = this.getContainer();
        if (container == null) {
            int i = 0;
            while (i < numberOfTokens) {
                this.put(tokenArray[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numberOfTokens) {
                this.put(container.convert(tokenArray[i]));
                ++i;
            }
        }
    }

    public void putArrayToAll(Token[] tokens, int numberOfTokens, Receiver[] receivers) throws NoRoomException, IllegalActionException {
        if (numberOfTokens > tokens.length) {
            IOPort container = this.getContainer();
            throw new IllegalActionException((Nameable)container, "Not enough tokens supplied.");
        }
        int j = 0;
        while (j < receivers.length) {
            receivers[j].putArray(tokens, numberOfTokens);
            ++j;
        }
    }

    public void putToAll(Token token, Receiver[] receivers) throws NoRoomException, IllegalActionException {
        int j = 0;
        while (j < receivers.length) {
            IOPort container = receivers[j].getContainer();
            if (container == null) {
                receivers[j].put(token);
            } else {
                receivers[j].put(container.convert(token));
            }
            ++j;
        }
    }

    public void reset() throws IllegalActionException {
        this.clear();
    }

    public void setContainer(IOPort port) throws IllegalActionException {
        this._container = port;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " {" + this.getContainer().getFullName() + ".receiver }";
    }
}

