/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.api.tools.internal.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.StringMatcher;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiToolingSetupRefactoring;
import org.eclipse.pde.api.tools.ui.internal.wizards.ProjectUpdateChange;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ApiToolingSetupWizardPage
extends UserInputWizardPage {
    private static final String SETTINGS_SECTION = "ApiToolingSetupWizardPage";
    private static final String SETTINGS_REMOVECXML = "remove_componentxml";
    private CheckboxTableViewer tableviewer = null;
    private HashSet checkedset = new HashSet();
    private Button removecxml = null;
    private UpdateJob updatejob = new UpdateJob();
    private StringFilter filter = new StringFilter();
    private Text checkcount = null;
    static /* synthetic */ Class class$0;

    protected ApiToolingSetupWizardPage() {
        super(WizardMessages.UpdateJavadocTagsWizardPage_4);
        this.setTitle(WizardMessages.UpdateJavadocTagsWizardPage_4);
        this.setMessage(WizardMessages.UpdateJavadocTagsWizardPage_7);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_TOOLING_SETUP_WIZARD_PAGE);
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_6, 1, 100);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiToolingSetupWizardPage_6, 1, 50);
        final Text text = SWTFactory.createText(comp, 2048, 1);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApiToolingSetupWizardPage.this.updatejob.setFilter(text.getText().trim());
                ApiToolingSetupWizardPage.this.updatejob.cancel();
                ApiToolingSetupWizardPage.this.updatejob.schedule();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && ApiToolingSetupWizardPage.this.tableviewer != null) {
                    ApiToolingSetupWizardPage.this.tableviewer.getTable().setFocus();
                }
            }
        });
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_8, 1, 50);
        Table table = new Table(comp, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableviewer.setInput((Object)this.getInputProjects());
        this.tableviewer.setComparator(new ViewerComparator());
        this.tableviewer.addFilter((ViewerFilter)this.filter);
        this.tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ApiToolingSetupWizardPage.this.checkedset.add(event.getElement());
                } else {
                    ApiToolingSetupWizardPage.this.checkedset.remove(event.getElement());
                }
                ApiToolingSetupWizardPage.this.setPageComplete(ApiToolingSetupWizardPage.this.pageValid());
            }
        });
        Composite bcomp = SWTFactory.createComposite(comp, 3, 1, 771, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_10, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiToolingSetupWizardPage.this.tableviewer.setAllChecked(true);
                ApiToolingSetupWizardPage.this.checkedset.addAll(Arrays.asList(ApiToolingSetupWizardPage.this.tableviewer.getCheckedElements()));
                ApiToolingSetupWizardPage.this.setPageComplete(ApiToolingSetupWizardPage.this.pageValid());
            }
        });
        button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_11, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiToolingSetupWizardPage.this.tableviewer.setAllChecked(false);
                TableItem[] items = ApiToolingSetupWizardPage.this.tableviewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    ApiToolingSetupWizardPage.this.checkedset.remove(items[i].getData());
                    ++i;
                }
                ApiToolingSetupWizardPage.this.setPageComplete(ApiToolingSetupWizardPage.this.pageValid());
            }
        });
        this.checkcount = SWTFactory.createText(bcomp, 0x800008, 1, 640);
        Object[] selected = this.getWorkbenchSelection();
        if (selected.length > 0) {
            this.tableviewer.setCheckedElements(selected);
            this.checkedset.addAll(Arrays.asList(selected));
        }
        this.setPageComplete(this.checkedset.size() > 0);
        SWTFactory.createVerticalSpacer(comp, 1);
        this.removecxml = SWTFactory.createCheckButton(comp, WizardMessages.ApiToolingSetupWizardPage_0, null, true, 1);
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.removecxml.setSelection(settings.getBoolean(SETTINGS_REMOVECXML));
        }
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        this.updateCheckStatus(this.checkedset.size());
    }

    private void updateCheckStatus(int count) {
        if (this.checkcount == null) {
            return;
        }
        this.checkcount.setText(MessageFormat.format((String)WizardMessages.ApiToolingSetupWizardPage_n_items_checked, (Object[])new String[]{Integer.toString(count)}));
    }

    private IProject[] getInputProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> pjs = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                IProject project = projects[i];
                if (this.acceptProject(project)) {
                    pjs.add(project);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return pjs.toArray(new IProject[pjs.size()]);
    }

    private boolean acceptProject(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        return project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature") && !project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") && !Util.isBinaryProject((IProject)project);
    }

    protected Object[] getWorkbenchSelection() {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            Object[] jps = ((IStructuredSelection)provider.getSelection()).toArray();
            ArrayList<IProject> pjs = new ArrayList<IProject>();
            int i = 0;
            while (i < jps.length) {
                if (jps[i] instanceof IAdaptable) {
                    IAdaptable adapt = (IAdaptable)jps[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IProject");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    IProject pj = (IProject)adapt.getAdapter((Class)clazz);
                    try {
                        if (this.acceptProject(pj)) {
                            pjs.add(pj);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
            return pjs.toArray();
        }
        return new Object[0];
    }

    protected boolean pageValid() {
        if (this.checkedset.size() < 1) {
            this.setErrorMessage(WizardMessages.UpdateJavadocTagsWizardPage_12);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IWizardPage getNextPage() {
        this.collectChanges();
        IWizardPage page = super.getNextPage();
        if (page != null) {
            page.setDescription(WizardMessages.ApiToolingSetupWizardPage_5);
        }
        return page;
    }

    private void createTagChanges(CompositeChange projectchange, IJavaProject project, File cxml) {
        try {
            HashMap map = new HashMap();
            ApiDescriptionProcessor.collectTagUpdates((IJavaProject)project, (File)cxml, map);
            IFile file = null;
            TextFileChange change = null;
            MultiTextEdit multiedit = null;
            HashSet alledits = null;
            TextEdit edit = null;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                file = (IFile)entry.getKey();
                change = new TextFileChange(MessageFormat.format((String)WizardMessages.JavadocTagRefactoring_2, (Object[])new String[]{file.getName()}), file);
                multiedit = new MultiTextEdit();
                change.setEdit((TextEdit)multiedit);
                alledits = (HashSet)entry.getValue();
                if (alledits != null) {
                    Iterator iter2 = alledits.iterator();
                    while (iter2.hasNext()) {
                        edit = (TextEdit)iter2.next();
                        multiedit.addChild(edit);
                    }
                }
                if (change == null) continue;
                projectchange.add((Change)change);
            }
        }
        catch (CoreException e) {
            ApiUIPlugin.log(e);
        }
        catch (IOException e) {
            ApiUIPlugin.log(e);
        }
    }

    private void collectChanges() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IProject[] projects = ApiToolingSetupWizardPage.this.checkedset.toArray(new IProject[ApiToolingSetupWizardPage.this.checkedset.size()]);
                IProject project = null;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", projects.length);
                monitor.setTaskName(WizardMessages.ApiToolingSetupWizardPage_7);
                ApiToolingSetupRefactoring refactoring = (ApiToolingSetupRefactoring)ApiToolingSetupWizardPage.this.getRefactoring();
                refactoring.resetRefactoring();
                boolean remove = ApiToolingSetupWizardPage.this.removecxml.getSelection();
                CompositeChange pchange = null;
                int i = 0;
                while (i < projects.length) {
                    project = projects[i];
                    pchange = new CompositeChange(project.getName());
                    refactoring.addChange((Change)pchange);
                    pchange.add((Change)new ProjectUpdateChange(project));
                    monitor.subTask(MessageFormat.format((String)WizardMessages.ApiToolingSetupWizardPage_4, (Object[])new String[]{project.getName()}));
                    IResource cxml = project.findMember("component.xml");
                    if (cxml != null) {
                        ApiToolingSetupWizardPage.this.createTagChanges(pchange, JavaCore.create((IProject)project), new File(cxml.getLocationURI()));
                        if (remove) {
                            pchange.add((Change)new DeleteResourceChange(cxml.getFullPath(), true));
                        }
                    }
                    if (monitor.isCanceled()) break;
                    monitor.worked(1);
                    ++i;
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InvocationTargetException e) {
            ApiUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            ApiUIPlugin.log(e);
        }
    }

    protected boolean performFinish() {
        this.collectChanges();
        return super.performFinish();
    }

    public boolean finish() {
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION);
        settings.put(SETTINGS_REMOVECXML, this.removecxml.getSelection());
        this.notifyNoDefaultProfile();
        return true;
    }

    private void notifyNoDefaultProfile() {
        if (ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline() == null) {
            UIJob job = new UIJob("No default API profile detected"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean doit = MessageDialog.openQuestion((Shell)ApiToolingSetupWizardPage.this.getShell(), (String)WizardMessages.ApiToolingSetupWizardPage_1, (String)(String.valueOf(WizardMessages.ApiToolingSetupWizardPage_2) + WizardMessages.ApiToolingSetupWizardPage_3));
                    if (doit) {
                        SWTFactory.showPreferencePage(ApiToolingSetupWizardPage.this.getShell(), "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage", null);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    static class StringFilter
    extends ViewerFilter {
        private String pattern = null;
        StringMatcher matcher = null;

        StringFilter() {
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.pattern == null) {
                return true;
            }
            if (this.pattern.trim().length() == 0) {
                return true;
            }
            String name = null;
            if (element instanceof IResource) {
                name = ((IResource)element).getName();
            }
            if (name == null) {
                return false;
            }
            this.matcher = new StringMatcher(this.pattern, true, false);
            return this.matcher.match(name, 0, name.length());
        }
    }

    class UpdateJob
    extends WorkbenchJob {
        private String pattern = null;

        public UpdateJob() {
            super(WizardMessages.ApiToolingSetupWizardPage_filter_update_job);
            this.setSystem(true);
        }

        public synchronized void setFilter(String pattern) {
            this.pattern = pattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (ApiToolingSetupWizardPage.this.tableviewer != null) {
                try {
                    ApiToolingSetupWizardPage.this.tableviewer.getTable().setRedraw(false);
                    UpdateJob updateJob = this;
                    synchronized (updateJob) {
                        ApiToolingSetupWizardPage.this.filter.setPattern(String.valueOf(this.pattern) + '*');
                    }
                    ApiToolingSetupWizardPage.this.tableviewer.refresh(true);
                    ApiToolingSetupWizardPage.this.tableviewer.setCheckedElements(ApiToolingSetupWizardPage.this.checkedset.toArray());
                }
                finally {
                    ApiToolingSetupWizardPage.this.tableviewer.getTable().setRedraw(true);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

