/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.xspress;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.ElementCountsData;
import uk.ac.gda.beans.xspress.DetectorElement;

public class XspressParameters
implements Serializable {
    private String detectorName;
    private String resGrade;
    private List<DetectorElement> detectorList = new ArrayList<DetectorElement>();
    private ElementCountsData[] data;
    private String readoutMode;
    private boolean editIndividualElements;
    public static final URL mappingURL = XspressParameters.class.getResource("XspressMapping.xml");
    public static final URL schemaURL = XspressParameters.class.getResource("XspressMapping.xsd");

    public void clear() {
        if (this.detectorList != null) {
            this.detectorList.clear();
        }
        this.editIndividualElements = true;
    }

    public void addDetectorElement(DetectorElement detectorElement) {
        this.detectorList.add(detectorElement);
    }

    public List<DetectorElement> getDetectorList() {
        return this.detectorList;
    }

    public void setDetectorList(List<DetectorElement> list) {
        this.detectorList = list;
    }

    public DetectorElement getDetector(int n) {
        return this.detectorList.get(n);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.detectorList == null ? 0 : this.detectorList.hashCode());
        n = 31 * n + (this.detectorName == null ? 0 : this.detectorName.hashCode());
        n = 31 * n + (this.readoutMode == null ? 0 : this.readoutMode.hashCode());
        n = 31 * n + (this.resGrade == null ? 0 : this.resGrade.hashCode());
        n = 31 * n + (this.editIndividualElements ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XspressParameters xspressParameters = (XspressParameters)object;
        if (this.editIndividualElements != xspressParameters.editIndividualElements) {
            return false;
        }
        if (this.detectorList == null ? xspressParameters.detectorList != null : !this.detectorList.equals(xspressParameters.detectorList)) {
            return false;
        }
        if (this.detectorName == null ? xspressParameters.detectorName != null : !this.detectorName.equals(xspressParameters.detectorName)) {
            return false;
        }
        if (this.readoutMode == null ? xspressParameters.readoutMode != null : !this.readoutMode.equals(xspressParameters.readoutMode)) {
            return false;
        }
        return !(this.resGrade == null ? xspressParameters.resGrade != null : !this.resGrade.equals(xspressParameters.resGrade));
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String getDetectorName() {
        return this.detectorName;
    }

    public void setDetectorName(String string) {
        this.detectorName = string;
    }

    public String getResGrade() {
        return this.resGrade;
    }

    public void setResGrade(String string) {
        this.resGrade = string;
    }

    public ElementCountsData[] getData() {
        return this.data;
    }

    public void setData(ElementCountsData[] elementCountsDataArray) {
        this.data = elementCountsDataArray;
    }

    public String getReadoutMode() {
        return this.readoutMode;
    }

    public void setReadoutMode(String string) {
        this.readoutMode = string;
    }

    public void setEditIndividualElements(boolean bl) {
        this.editIndividualElements = bl;
    }

    public boolean isEditIndividualElements() {
        return this.editIndividualElements;
    }
}

