/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.vortex;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.ElementCountsData;
import uk.ac.gda.beans.vortex.DetectorElement;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class VortexParameters
implements Serializable {
    private List<DetectorElement> detectorList = new ArrayList<DetectorElement>();
    private String countType;
    private double collectionTime;
    private double deadTime;
    private ElementCountsData[] data;
    private String detectorName;
    private String tfgName;
    public static final URL mappingURL = VortexParameters.class.getResource("VortexMapping.xml");
    public static final URL schemaURL = VortexParameters.class.getResource("VortexMapping.xsd");

    public static VortexParameters createFromXML(String string) throws Exception {
        return (VortexParameters)XMLHelpers.createFromXML((URL)mappingURL, VortexParameters.class, (URL)schemaURL, (String)string);
    }

    public static void writeToXML(VortexParameters vortexParameters, String string) throws Exception {
        XMLHelpers.writeToXML((URL)mappingURL, (Object)vortexParameters, (String)string);
    }

    public void clear() {
        if (this.detectorList != null) {
            this.detectorList.clear();
        }
    }

    public void addDetectorElement(DetectorElement detectorElement) {
        this.detectorList.add(detectorElement);
    }

    public List<DetectorElement> getDetectorList() {
        return this.detectorList;
    }

    public void setDetectorList(List<DetectorElement> list) {
        this.detectorList = list;
    }

    public DetectorElement getDetector(int n) {
        return this.detectorList.get(n);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.collectionTime);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.countType == null ? 0 : this.countType.hashCode());
        n = 31 * n + Arrays.hashCode(this.data);
        l = Double.doubleToLongBits(this.deadTime);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.detectorList == null ? 0 : this.detectorList.hashCode());
        n = 31 * n + (this.detectorName == null ? 0 : this.detectorName.hashCode());
        n = 31 * n + (this.tfgName == null ? 0 : this.tfgName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VortexParameters vortexParameters = (VortexParameters)object;
        if (Double.doubleToLongBits(this.collectionTime) != Double.doubleToLongBits(vortexParameters.collectionTime)) {
            return false;
        }
        if (this.countType == null ? vortexParameters.countType != null : !this.countType.equals(vortexParameters.countType)) {
            return false;
        }
        if (!Arrays.equals(this.data, vortexParameters.data)) {
            return false;
        }
        if (Double.doubleToLongBits(this.deadTime) != Double.doubleToLongBits(vortexParameters.deadTime)) {
            return false;
        }
        if (this.detectorList == null ? vortexParameters.detectorList != null : !this.detectorList.equals(vortexParameters.detectorList)) {
            return false;
        }
        if (this.detectorName == null ? vortexParameters.detectorName != null : !this.detectorName.equals(vortexParameters.detectorName)) {
            return false;
        }
        return !(this.tfgName == null ? vortexParameters.tfgName != null : !this.tfgName.equals(vortexParameters.tfgName));
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public String getCountType() {
        return this.countType;
    }

    public void setCountType(String string) {
        this.countType = string;
    }

    public double getCollectionTime() {
        return this.collectionTime;
    }

    public void setCollectionTime(double d) {
        this.collectionTime = d;
    }

    public double getDeadTime() {
        return this.deadTime;
    }

    public void setDeadTime(double d) {
        this.deadTime = d;
    }

    public void setData(ElementCountsData[] elementCountsDataArray) {
        this.data = elementCountsDataArray;
    }

    public ElementCountsData[] getData() {
        return this.data;
    }

    public String getDetectorName() {
        return this.detectorName;
    }

    public void setDetectorName(String string) {
        this.detectorName = string;
    }

    public String getTfgName() {
        return this.tfgName;
    }

    public void setTfgName(String string) {
        this.tfgName = string;
    }
}

