/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.exafs;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.exafs.IScanParameters;
import uk.ac.gda.beans.exafs.Region;
import uk.ac.gda.beans.exafs.RegionEnergyException;
import uk.ac.gda.beans.exafs.RegionException;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class XanesScanParameters
implements Serializable,
IScanParameters {
    private String scannableName;
    private String element;
    private Double finalEnergy;
    private boolean shouldValidate = true;
    private String edge;
    private List<Region> regions = new ArrayList<Region>(11);
    public static final URL mappingURL = XanesScanParameters.class.getResource("ExafsParameterMapping.xml");
    public static final URL schemaUrl = XanesScanParameters.class.getResource("ExafsParameterMapping.xsd");

    public Double getFinalEnergy() {
        return this.finalEnergy;
    }

    public void setFinalEnergy(Double d) {
        this.finalEnergy = d;
    }

    public void clear() {
        this.element = null;
        this.edge = null;
        this.regions.clear();
    }

    public static XanesScanParameters createFromXML(String string) throws Exception {
        return (XanesScanParameters)XMLHelpers.createFromXML((URL)mappingURL, XanesScanParameters.class, (URL)schemaUrl, (String)string);
    }

    public static void writeToXML(XanesScanParameters xanesScanParameters, String string) throws Exception {
        XMLHelpers.writeToXML((URL)mappingURL, (Object)xanesScanParameters, (String)string);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String string) {
        this.element = string;
    }

    public String getEdge() {
        return this.edge;
    }

    public void setEdge(String string) {
        this.edge = string;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public void setRegions(List<Region> list) {
        this.regions = list;
    }

    public void addRegion(Region region) {
        this.regions.add(region);
    }

    public void checkRegions() throws Exception {
        if (this.regions.isEmpty()) {
            throw new RegionException("No regions added to scan.");
        }
        if (this.regions.size() > 1) {
            int n = 1;
            while (n < this.regions.size()) {
                Region region = this.regions.get(n - 1);
                Region region2 = this.regions.get(n);
                this.checkEngergyIncrease(region.getEnergy(), region2.getEnergy());
                if (n == this.regions.size() - 1) {
                    this.checkEngergyIncrease(region2.getEnergy(), this.finalEnergy);
                }
                ++n;
            }
        } else {
            this.checkEngergyIncrease(this.regions.get(0).getEnergy(), this.finalEnergy);
        }
    }

    public void checkEngergyIncrease(double d, double d2) throws Exception {
        if (d >= d2) {
            throw new RegionEnergyException("The start energy " + d + " is greater than or equal to the stop energy " + d2);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.edge == null ? 0 : this.edge.hashCode());
        n = 31 * n + (this.element == null ? 0 : this.element.hashCode());
        n = 31 * n + (this.finalEnergy == null ? 0 : this.finalEnergy.hashCode());
        n = 31 * n + (this.regions == null ? 0 : this.regions.hashCode());
        n = 31 * n + (this.scannableName == null ? 0 : this.scannableName.hashCode());
        n = 31 * n + (this.shouldValidate ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XanesScanParameters xanesScanParameters = (XanesScanParameters)object;
        if (this.edge == null ? xanesScanParameters.edge != null : !this.edge.equals(xanesScanParameters.edge)) {
            return false;
        }
        if (this.element == null ? xanesScanParameters.element != null : !this.element.equals(xanesScanParameters.element)) {
            return false;
        }
        if (this.finalEnergy == null ? xanesScanParameters.finalEnergy != null : !this.finalEnergy.equals(xanesScanParameters.finalEnergy)) {
            return false;
        }
        if (this.regions == null ? xanesScanParameters.regions != null : !this.regions.equals(xanesScanParameters.regions)) {
            return false;
        }
        if (this.scannableName == null ? xanesScanParameters.scannableName != null : !this.scannableName.equals(xanesScanParameters.scannableName)) {
            return false;
        }
        return this.shouldValidate == xanesScanParameters.shouldValidate;
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public String getScannableName() {
        return this.scannableName;
    }

    public void setScannableName(String string) {
        this.scannableName = string;
    }

    public boolean isShouldValidate() {
        return this.shouldValidate;
    }

    public void setShouldValidate(boolean bl) {
        this.shouldValidate = bl;
    }
}

