/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.beans.exafs;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import uk.ac.gda.beans.exafs.DetectorGroup;
import uk.ac.gda.beans.exafs.ElectronYieldParameters;
import uk.ac.gda.beans.exafs.FluorescenceParameters;
import uk.ac.gda.beans.exafs.IDetectorParameters;
import uk.ac.gda.beans.exafs.IonChamberParameters;
import uk.ac.gda.beans.exafs.SoftXRaysParameters;
import uk.ac.gda.beans.exafs.TransmissionParameters;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class DetectorParameters
implements Serializable,
IDetectorParameters {
    private List<DetectorGroup> detectorGroups = new ArrayList<DetectorGroup>(3);
    private String experimentType;
    private boolean shouldValidate = true;
    private TransmissionParameters transmissionParameters;
    private FluorescenceParameters fluorescenceParameters;
    private FluorescenceParameters xesParameters;
    private SoftXRaysParameters softXRaysParameters;
    private ElectronYieldParameters electronYieldParameters;
    public static final URL mappingURL = DetectorParameters.class.getResource("ExafsParameterMapping.xml");
    public static final URL schemaUrl = DetectorParameters.class.getResource("ExafsParameterMapping.xsd");

    @Override
    public String getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(String string) {
        this.experimentType = string;
    }

    public static DetectorParameters createFromXML(String string) throws Exception {
        return (DetectorParameters)XMLHelpers.createFromXML((URL)mappingURL, DetectorParameters.class, (URL)schemaUrl, (String)string);
    }

    public static void writeToXML(DetectorParameters detectorParameters, String string) throws Exception {
        XMLHelpers.writeToXML((URL)mappingURL, (Object)detectorParameters, (String)string);
    }

    public void clear() {
        if (this.transmissionParameters != null) {
            this.transmissionParameters.clear();
        }
        if (this.fluorescenceParameters != null) {
            this.fluorescenceParameters.clear();
        }
        if (this.softXRaysParameters != null) {
            this.softXRaysParameters.clear();
        }
        if (this.electronYieldParameters != null) {
            this.electronYieldParameters.clear();
        }
        if (this.detectorGroups != null) {
            this.detectorGroups.clear();
        }
    }

    @Override
    public TransmissionParameters getTransmissionParameters() {
        return this.transmissionParameters;
    }

    public void setTransmissionParameters(TransmissionParameters transmissionParameters) {
        this.transmissionParameters = transmissionParameters;
    }

    @Override
    public FluorescenceParameters getFluorescenceParameters() {
        return this.fluorescenceParameters;
    }

    public void setFluorescenceParameters(FluorescenceParameters fluorescenceParameters) {
        this.fluorescenceParameters = fluorescenceParameters;
    }

    @Override
    public FluorescenceParameters getXesParameters() {
        return this.xesParameters;
    }

    public void setXesParameters(FluorescenceParameters fluorescenceParameters) {
        this.xesParameters = fluorescenceParameters;
    }

    @Override
    public SoftXRaysParameters getSoftXRaysParameters() {
        return this.softXRaysParameters;
    }

    public void setSoftXRaysParameters(SoftXRaysParameters softXRaysParameters) {
        this.softXRaysParameters = softXRaysParameters;
    }

    @Override
    public ElectronYieldParameters getElectronYieldParameters() {
        return this.electronYieldParameters;
    }

    public void setElectronYieldParameters(ElectronYieldParameters electronYieldParameters) {
        this.electronYieldParameters = electronYieldParameters;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.detectorGroups == null ? 0 : this.detectorGroups.hashCode());
        n = 31 * n + (this.experimentType == null ? 0 : this.experimentType.hashCode());
        n = 31 * n + (this.fluorescenceParameters == null ? 0 : this.fluorescenceParameters.hashCode());
        n = 31 * n + (this.softXRaysParameters == null ? 0 : this.softXRaysParameters.hashCode());
        n = 31 * n + (this.shouldValidate ? 1231 : 1237);
        n = 31 * n + (this.transmissionParameters == null ? 0 : this.transmissionParameters.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DetectorParameters detectorParameters = (DetectorParameters)object;
        if (this.detectorGroups == null ? detectorParameters.detectorGroups != null : !this.detectorGroups.equals(detectorParameters.detectorGroups)) {
            return false;
        }
        if (this.experimentType == null ? detectorParameters.experimentType != null : !this.experimentType.equals(detectorParameters.experimentType)) {
            return false;
        }
        if (this.fluorescenceParameters == null ? detectorParameters.fluorescenceParameters != null : !this.fluorescenceParameters.equals(detectorParameters.fluorescenceParameters)) {
            return false;
        }
        if (this.softXRaysParameters == null ? detectorParameters.softXRaysParameters != null : !this.softXRaysParameters.equals(detectorParameters.softXRaysParameters)) {
            return false;
        }
        if (this.shouldValidate != detectorParameters.shouldValidate) {
            return false;
        }
        return !(this.transmissionParameters == null ? detectorParameters.transmissionParameters != null : !this.transmissionParameters.equals(detectorParameters.transmissionParameters));
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public List<DetectorGroup> getDetectorGroups() {
        return this.detectorGroups;
    }

    public void setDetectorGroups(List<DetectorGroup> list) {
        this.detectorGroups = list;
    }

    public void addDetectorGroup(DetectorGroup detectorGroup) {
        this.detectorGroups.add(detectorGroup);
    }

    @Override
    public List<IonChamberParameters> getIonChambers() throws Exception {
        List<IonChamberParameters> list;
        if (this.getExperimentType().equalsIgnoreCase("transmission")) {
            list = this.getTransmissionParameters().getIonChamberParameters();
        } else if (this.getExperimentType().equalsIgnoreCase("fluorescence")) {
            list = this.getFluorescenceParameters().getIonChamberParameters();
        } else if (this.getExperimentType().equalsIgnoreCase("soft x-rays")) {
            list = Collections.emptyList();
        } else if (this.getExperimentType().equalsIgnoreCase("xes")) {
            list = this.getXesParameters().getIonChamberParameters();
        } else {
            throw new Exception("Cannot determine detector parameters '" + this.getExperimentType() + "'.");
        }
        return list;
    }

    @Override
    public boolean isShouldValidate() {
        return this.shouldValidate;
    }

    public void setShouldValidate(boolean bl) {
        this.shouldValidate = bl;
    }
}

