/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.launch;

import com.isencia.passerelle.model.util.IMomlClassLoader;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.workbench.model.utils.OSGClassLoader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;

public class ModelRunner
implements IApplication {
    private static Logger logger = LoggerFactory.getLogger(ModelRunner.class);

    public Logger getLogger() {
        return logger;
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        logger.info("Starting EDNA Server");
        String string = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        System.setProperty("eclipse.workspace.home", string);
        logger.info("Workspace folder set to: " + string);
        String string2 = System.getProperty("model");
        this.runModel(string2);
        return IApplication.EXIT_OK;
    }

    public void stop() {
        logger.info("Stopping EDNA Server");
    }

    private void runModel(String string) {
        block19: {
            Reader reader = null;
            try {
                if (string == null) {
                    throw new IllegalArgumentException("No model specified", null);
                }
                logger.info("Running model : " + string);
                reader = new FileReader(string);
                MoMLParser moMLParser = new MoMLParser(null, (IMomlClassLoader)new OSGClassLoader());
                CompositeActor compositeActor = (CompositeActor)moMLParser.parse(null, reader);
                ModelRunner.executeModel(compositeActor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.info(illegalArgumentException.getMessage());
                logger.info("End model : " + string);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                break block19;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    logger.error("Cannot read " + string, throwable);
                }
                catch (Throwable throwable2) {
                    logger.info("End model : " + string);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable2;
                }
                logger.info("End model : " + string);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                break block19;
            }
            logger.info("End model : " + string);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.stop();
    }

    private static void executeModel(CompositeActor compositeActor) throws Exception {
        Manager manager = new Manager(compositeActor.workspace(), "model");
        compositeActor.setManager(manager);
        manager.execute();
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0 && "-model".equals(stringArray[n - 1])) {
                string = stringArray[n];
                break;
            }
            ++n;
        }
        ModelRunner modelRunner = new ModelRunner();
        modelRunner.runModel(string);
    }
}

