/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import java.io.Serializable;
import uk.ac.diamond.scisoft.analysis.coords.RotatedCoords;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;

public class RectangularROI
extends ROIBase
implements Serializable {
    private double[] len;
    private double ang;
    private boolean clippingCompensation;
    private double cang;
    private double sang;

    public void setClippingCompensation(boolean bl) {
        this.clippingCompensation = bl;
    }

    public boolean isClippingCompensation() {
        return this.clippingCompensation;
    }

    public RectangularROI() {
        this(10.0, 0.0);
    }

    public RectangularROI(double d, double d2) {
        this(0.0, 0.0, d, d, d2);
    }

    public RectangularROI(double d, double d2, double d3) {
        this(0.0, 0.0, d, d2, d3);
    }

    public RectangularROI(double d, double d2, double d3, double d4, double d5) {
        this(d, d2, d3, d4, d5, false);
    }

    public RectangularROI(double d, double d2, double d3, double d4, double d5, boolean bl) {
        this.spt = new double[]{d, d2};
        this.len = new double[]{d3, d4};
        this.ang = d5;
        this.calcTrig();
        this.clippingCompensation = bl;
    }

    public void setLengths(double[] dArray) {
        this.len[0] = dArray[0];
        this.len[1] = dArray[1];
    }

    public void setLengths(double d, double d2) {
        this.len[0] = d;
        this.len[1] = d2;
    }

    private double[] getPoint(double d, double d2) {
        return new double[]{this.spt[0] + d * this.len[0] * this.cang - d2 * this.len[1] * this.sang, this.spt[1] + d * this.len[0] * this.sang + d2 * this.len[1] * this.cang};
    }

    private double[] getRelativePoint(double d, double d2) {
        return new double[]{d * this.len[0] * this.cang - d2 * this.len[1] * this.sang, d * this.len[0] * this.sang + d2 * this.len[1] * this.cang};
    }

    public int[] getIntPoint(double d, double d2) {
        return new int[]{(int)(this.spt[0] + d * this.len[0] * this.cang - d2 * this.len[1] * this.sang), (int)(this.spt[1] + d * this.len[0] * this.sang + d2 * this.len[1] * this.cang)};
    }

    public double[] getEndPoint() {
        return this.getPoint(1.0, 1.0);
    }

    public double[] getMidPoint() {
        return this.getPoint(0.5, 0.5);
    }

    public void setMidPoint(double[] dArray) {
        this.spt[0] = dArray[0] - 0.5 * this.len[0] * this.cang + 0.5 * this.len[1] * this.sang;
        this.spt[1] = dArray[1] - 0.5 * this.len[0] * this.sang - 0.5 * this.len[1] * this.cang;
    }

    public double[] getLengths() {
        return this.len;
    }

    public int[] getIntLengths() {
        return new int[]{(int)this.len[0], (int)this.len[1]};
    }

    public double getAngle() {
        return this.ang;
    }

    public void setAngle(double d) {
        this.ang = d;
        if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        this.calcTrig();
    }

    public double getAngleDegrees() {
        return Math.toDegrees(this.ang);
    }

    public void setAngleDegrees(double d) {
        if (d < 0.0) {
            d += 360.0;
        }
        this.ang = Math.toRadians(d);
        this.calcTrig();
    }

    private void calcTrig() {
        this.cang = Math.cos(this.ang);
        this.sang = Math.sin(this.ang);
    }

    @Override
    public RectangularROI copy() {
        return new RectangularROI(this.spt[0], this.spt[1], this.len[0], this.len[1], this.ang, this.clippingCompensation);
    }

    public double getAngleRelativeToMidPoint(int[] nArray) {
        return this.getAngleRelativeToPoint(0.5, 0.5, nArray);
    }

    public double getAngleRelativeToPoint(double d, double d2, int[] nArray) {
        double[] dArray = this.getPoint(d, d2);
        dArray[0] = (double)nArray[0] - dArray[0];
        dArray[1] = (double)nArray[1] - dArray[1];
        return Math.atan2(dArray[1], dArray[0]);
    }

    public void setEndPointKeepLengths(double[] dArray) {
        RotatedCoords rotatedCoords = null;
        double[] dArray2 = null;
        rotatedCoords = new RotatedCoords(this.ang, false);
        dArray2 = rotatedCoords.transformToRotated(dArray[0], dArray[1]);
        this.spt = rotatedCoords.transformToOriginal(dArray2[0] - this.len[0], dArray2[1] - this.len[1]);
    }

    public void setEndPoint(int[] nArray) {
        this.setEndPoint(new double[]{nArray[0], nArray[1]});
    }

    public void setEndPoint(double[] dArray) {
        double d;
        RotatedCoords rotatedCoords = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        rotatedCoords = new RotatedCoords(this.ang, false);
        dArray2 = rotatedCoords.transformToRotated(this.spt[0], this.spt[1]);
        if (dArray2[0] > (dArray3 = rotatedCoords.transformToRotated(dArray[0], dArray[1]))[0]) {
            d = dArray2[0];
            dArray2[0] = dArray3[0];
            dArray3[0] = d;
        }
        if (dArray2[1] > dArray3[1]) {
            d = dArray2[1];
            dArray2[1] = dArray3[1];
            dArray3[1] = d;
        }
        this.len[0] = dArray3[0] - dArray2[0];
        this.len[1] = dArray3[1] - dArray2[1];
        this.spt = rotatedCoords.transformToOriginal(dArray2[0], dArray2[1]);
    }

    public void setEndPoint(int[] nArray, boolean bl, boolean bl2) {
        RotatedCoords rotatedCoords = null;
        double[] dArray = null;
        double[] dArray2 = null;
        rotatedCoords = new RotatedCoords(this.ang, false);
        dArray = rotatedCoords.transformToRotated(this.spt[0], this.spt[1]);
        dArray2 = rotatedCoords.transformToRotated(nArray[0], nArray[1]);
        if (bl) {
            this.len[0] = dArray2[0] - dArray[0];
            if (this.len[0] < 0.0) {
                this.len[0] = 0.0;
            }
        }
        if (bl2) {
            this.len[1] = dArray2[1] - dArray[1];
            if (this.len[1] < 0.0) {
                this.len[1] = 0.0;
            }
        }
    }

    public void addAngle(double d) {
        this.ang += d;
        if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        if (this.ang > Math.PI * 2) {
            this.ang -= Math.PI * 2;
        }
        this.calcTrig();
    }

    public void subPoint(int[] nArray) {
        this.spt[0] = this.spt[0] - (double)nArray[0];
        this.spt[1] = this.spt[1] - (double)nArray[1];
    }

    public void translate(double d, double d2) {
        double[] dArray = this.getRelativePoint(d, d2);
        this.spt[0] = this.spt[0] + dArray[0];
        this.spt[1] = this.spt[1] + dArray[1];
    }

    public void setPointKeepEndPoint(int[] nArray, boolean bl, boolean bl2) {
        RotatedCoords rotatedCoords = null;
        double[] dArray = null;
        double[] dArray2 = null;
        rotatedCoords = new RotatedCoords(this.ang, false);
        dArray2 = rotatedCoords.transformToRotated(nArray[0], nArray[1]);
        if (bl) {
            dArray = rotatedCoords.transformToOriginal(dArray2[0], 0.0);
            if (this.len[0] > dArray2[0]) {
                this.len[0] = this.len[0] - dArray2[0];
                this.spt[0] = this.spt[0] + dArray[0];
                this.spt[1] = this.spt[1] + dArray[1];
            } else {
                this.len[0] = 0.0;
            }
        }
        if (bl2) {
            dArray = rotatedCoords.transformToOriginal(0.0, dArray2[1]);
            if (this.len[1] > dArray2[1]) {
                this.len[1] = this.len[1] - dArray2[1];
                this.spt[0] = this.spt[0] + dArray[0];
                this.spt[1] = this.spt[1] + dArray[1];
            } else {
                this.len[1] = 0.0;
            }
        }
    }

    public void adjustKeepDiagonalPoint(int[] nArray, double[] dArray, int[] nArray2, boolean bl) {
        RotatedCoords rotatedCoords = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        rotatedCoords = new RotatedCoords(this.ang, false);
        dArray2 = rotatedCoords.transformToRotated(this.spt[0], this.spt[1]);
        dArray3 = rotatedCoords.transformToRotated((double)(nArray2[0] - nArray[0]) + dArray[0], (double)(nArray2[1] - nArray[1]) + dArray[1]);
        if (bl) {
            this.len[0] = dArray3[0] - dArray2[0];
            if (this.len[0] < 0.0) {
                this.len[0] = 0.0;
            }
            dArray3 = rotatedCoords.transformToRotated(nArray2[0] - nArray[0], nArray2[1] - nArray[1]);
            dArray2 = rotatedCoords.transformToOriginal(0.0, dArray3[1]);
            if (this.len[1] > dArray3[1]) {
                this.len[1] = this.len[1] - dArray3[1];
                this.spt[0] = this.spt[0] + dArray2[0];
                this.spt[1] = this.spt[1] + dArray2[1];
            } else {
                this.len[1] = 0.0;
            }
        } else {
            this.len[1] = dArray3[1] - dArray2[1];
            if (this.len[1] < 0.0) {
                this.len[1] = 0.0;
            }
            dArray3 = rotatedCoords.transformToRotated(nArray2[0] - nArray[0], nArray2[1] - nArray[1]);
            dArray2 = rotatedCoords.transformToOriginal(dArray3[0], 0.0);
            if (this.len[0] > dArray3[0]) {
                this.len[0] = this.len[0] - dArray3[0];
                this.spt[0] = this.spt[0] + dArray2[0];
                this.spt[1] = this.spt[1] + dArray2[1];
            } else {
                this.len[0] = 0.0;
            }
        }
    }

    @Override
    public void downsample(double d) {
        this.spt[0] = this.spt[0] / d;
        this.spt[1] = this.spt[1] / d;
        this.len[0] = this.len[0] / d;
        this.len[1] = this.len[1] / d;
    }

    public String toString() {
        return String.format("Start (%g, %g) Size (%g,%g) Angle %g", this.spt[0], this.spt[1], this.len[0], this.len[1], this.getAngleDegrees());
    }
}

