/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import gda.analysis.DataSet;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.roi.GridPreferences;
import uk.ac.diamond.scisoft.analysis.roi.GridROI;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.ROIProfile;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;

public class ROIProfileTest {
    @Test
    public void testLine() {
        DataSet dataSet = new DataSet(new double[]{1.0, 2.0, 3.0, 4.0}, 2, 2);
        LinearROI linearROI = new LinearROI(new double[]{0.0, 0.0}, new double[]{0.0, 1.0});
        DataSet[] dataSetArray = ROIProfile.line(dataSet, linearROI, 1.0);
        int n = 0;
        while (n < dataSetArray.length) {
            if (dataSetArray[n] != null) {
                int n2 = 0;
                while (n2 < dataSetArray[n].getBuffer().length) {
                    Assert.assertTrue((String)"positive numbers expected in integration over positive dataset", (dataSetArray[n].getBuffer()[n2] > 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Test
    public void testBox() {
        DataSet dataSet = new DataSet(new double[]{0.0, 1.0, 2.0, 3.0}, 2, 2);
        RectangularROI rectangularROI = new RectangularROI(0.0, 0.0, 1.0, 1.0, 0.0);
        DataSet[] dataSetArray = ROIProfile.box(dataSet, rectangularROI);
        int n = 0;
        while (n < dataSetArray.length) {
            if (dataSetArray[n] != null) {
                int n2 = 0;
                while (n2 < dataSetArray[n].getBuffer().length) {
                    Assert.assertTrue((String)"negative number in integration over non-negative dataset", (dataSetArray[n].getBuffer()[n2] >= 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Test
    public void testSector() {
        DataSet dataSet = new DataSet(new double[]{0.0, 1.0, 1.0, 1.0}, 2, 2);
        SectorROI sectorROI = new SectorROI(0.0, 0.0, 0.0, 3.0, 0.0, Math.PI * 2);
        DataSet[] dataSetArray = ROIProfile.sector(dataSet, sectorROI);
        int n = 0;
        while (n < dataSetArray.length) {
            if (dataSetArray[n] != null) {
                int n2 = 0;
                while (n2 < dataSetArray[n].getBuffer().length) {
                    Assert.assertTrue((String)"negative number in integration over non-negative dataset", (dataSetArray[n].getBuffer()[n2] >= 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Test
    public void testGrid() {
        DataSet dataSet = new DataSet(new double[]{0.0, 1.0, 2.0, 3.0}, 2, 2);
        GridROI gridROI = new GridROI(0.0, 0.0, 1.0, 1.0, 0.0, 10.0, 10.0, false, false, new GridPreferences());
        DataSet[] dataSetArray = ROIProfile.box(dataSet, gridROI);
        int n = 0;
        while (n < dataSetArray.length) {
            if (dataSetArray[n] != null) {
                int n2 = 0;
                while (n2 < dataSetArray[n].getBuffer().length) {
                    Assert.assertTrue((String)"negative number in integration over non-negative dataset", (dataSetArray[n].getBuffer()[n2] >= 0.0 ? 1 : 0) != 0);
                    ++n2;
                }
            }
            ++n;
        }
    }
}

