/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import gda.analysis.functions.dataset.Integrate2D;
import gda.analysis.functions.dataset.LineSample;
import gda.analysis.functions.dataset.MapToPolarAndIntegrate;
import gda.analysis.functions.dataset.MapToRotatedCartesianAndIntegrate;
import gda.analysis.utils.DatasetMaths;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;

public class ROIProfile {
    public static DataSet[] line(DataSet dataSet, LinearROI linearROI, double d) {
        LineSample lineSample;
        int[] nArray = linearROI.getIntPoint();
        int[] nArray2 = linearROI.getIntEndPoint();
        DataSet[] dataSetArray = new DataSet[2];
        LineSample lineSample2 = new LineSample(nArray[0], nArray[1], nArray2[0], nArray2[1], d);
        List<DataSet> list = dataSet.exec(lineSample2);
        if (list == null) {
            return null;
        }
        dataSetArray[0] = list.get(0);
        if (linearROI.isCrossHair() && (list = dataSet.exec(lineSample = new LineSample((nArray = linearROI.getPerpendicularBisectorIntPoint(0.0))[0], nArray[1], (nArray2 = linearROI.getPerpendicularBisectorIntPoint(1.0))[0], nArray2[1], d))) != null) {
            dataSetArray[1] = list.get(0);
        }
        return dataSetArray;
    }

    private static void clippingCompensate(DataSet dataSet, DataSet dataSet2, DataSet[] dataSetArray, IDataSetFunction iDataSetFunction) {
        if (dataSet2 == null) {
            dataSet2 = DataSet.ones(dataSet.getShape());
        }
        List<DataSet> list = iDataSetFunction.execute(dataSet2);
        DataSet dataSet3 = list.get(1);
        DataSet dataSet4 = list.get(0);
        dataSet3 = DatasetMaths.dividez(dataSet3, list.get(3));
        dataSet4 = DatasetMaths.dividez(dataSet4, list.get(2));
        dataSetArray[0] = DatasetMaths.dividez(dataSetArray[0], dataSet3);
        dataSetArray[1] = DatasetMaths.dividez(dataSetArray[1], dataSet4);
    }

    public static DataSet[] box(DataSet dataSet, RectangularROI rectangularROI) {
        return ROIProfile.box(dataSet, null, rectangularROI);
    }

    public static DataSet[] box(DataSet dataSet, DataSet dataSet2, RectangularROI rectangularROI) {
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntLengths();
        double d = rectangularROI.getAngle();
        boolean bl = rectangularROI.isClippingCompensation();
        DataSet[] dataSetArray = new DataSet[2];
        if (dataSet2 != null) {
            dataSet.checkCompatibility(dataSet2);
        }
        if (nArray2[0] == 0) {
            nArray2[0] = 1;
        }
        if (nArray2[1] == 0) {
            nArray2[1] = 1;
        }
        if (d == 0.0) {
            Integrate2D integrate2D = new Integrate2D(nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
            List<DataSet> list = dataSet.exec(integrate2D);
            if (list == null) {
                return null;
            }
            dataSetArray[0] = list.get(1);
            dataSetArray[1] = list.get(0);
        } else {
            MapToRotatedCartesianAndIntegrate mapToRotatedCartesianAndIntegrate = new MapToRotatedCartesianAndIntegrate(nArray[0], nArray[1], nArray2[0], nArray2[1], d, false);
            List<DataSet> list = dataSet.exec(mapToRotatedCartesianAndIntegrate);
            if (list == null) {
                return null;
            }
            dataSetArray[0] = list.get(1);
            dataSetArray[1] = list.get(0);
            if (bl) {
                ROIProfile.clippingCompensate(dataSet, dataSet2, dataSetArray, mapToRotatedCartesianAndIntegrate);
            }
        }
        return dataSetArray;
    }

    public static DataSet[] sector(DataSet dataSet, SectorROI sectorROI) {
        return ROIProfile.sector(dataSet, null, sectorROI);
    }

    public static DataSet[] sector(DataSet dataSet, DataSet dataSet2, SectorROI sectorROI) {
        double[] dArray = sectorROI.getPoint();
        double[] dArray2 = sectorROI.getRadii();
        double[] dArray3 = sectorROI.getAngles();
        boolean bl = sectorROI.isClippingCompensation();
        int n = sectorROI.getSymmetry();
        DataSet[] dataSetArray = new DataSet[4];
        if (Math.abs(dArray2[0] - dArray2[1]) < 1.0 || Math.abs(dArray3[0] - dArray3[1]) < 0.01) {
            return null;
        }
        if (dataSet2 != null) {
            dataSet.checkCompatibility(dataSet2);
        }
        if (n == 1) {
            MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(dArray[0], dArray[1], dArray2[0], dArray3[0], dArray2[1], dArray3[0] + Math.PI * 2, false);
            List<DataSet> list = dataSet.exec(mapToPolarAndIntegrate);
            if (list == null) {
                return null;
            }
            dataSetArray[0] = list.get(1);
            dataSetArray[1] = list.get(0);
            if (bl) {
                ROIProfile.clippingCompensate(dataSet, dataSet2, dataSetArray, mapToPolarAndIntegrate);
            }
            return dataSetArray;
        }
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(dArray[0], dArray[1], dArray2[0], dArray3[0], dArray2[1], dArray3[1], false);
        List<DataSet> list = dataSet.exec(mapToPolarAndIntegrate);
        if (list == null) {
            return null;
        }
        dataSetArray[0] = list.get(1);
        dataSetArray[1] = list.get(0);
        if (bl) {
            ROIProfile.clippingCompensate(dataSet, dataSet2, dataSetArray, mapToPolarAndIntegrate);
        }
        if (n != 0) {
            double[] dArray4 = sectorROI.getSymmetryAngles();
            DataSet[] dataSetArray2 = new DataSet[2];
            MapToPolarAndIntegrate mapToPolarAndIntegrate2 = new MapToPolarAndIntegrate(dArray[0], dArray[1], dArray2[0], dArray4[0], dArray2[1], dArray4[1], false);
            List<DataSet> list2 = dataSet.exec(mapToPolarAndIntegrate2);
            if (list2 != null) {
                dataSetArray2[0] = list2.get(1);
                dataSetArray2[1] = list2.get(0);
                if (bl) {
                    ROIProfile.clippingCompensate(dataSet, dataSet2, dataSetArray2, mapToPolarAndIntegrate2);
                }
                if (sectorROI.isCombineSymmetry()) {
                    dataSetArray[0] = DatasetMaths.add(dataSetArray[0], dataSetArray2[0]);
                    dataSetArray[1] = DatasetMaths.add(dataSetArray[1], dataSetArray2[1]);
                } else {
                    dataSetArray[2] = dataSetArray2[0];
                    dataSetArray[3] = dataSetArray2[1];
                }
            }
        }
        return dataSetArray;
    }
}

