/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.roi;

import java.io.Serializable;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;

public class LinearROI
extends ROIBase
implements Serializable {
    private double len;
    private double ang;
    private boolean crossHair;
    private double cang;
    private double sang;

    public LinearROI() {
        this(1.0);
    }

    public LinearROI(double d) {
        this(d, 0.0);
    }

    public LinearROI(double d, double d2) {
        this.spt = new double[]{0.0, 0.0};
        this.len = d;
        this.ang = d2;
        this.calcTrig();
        this.crossHair = false;
    }

    public LinearROI(double[] dArray) {
        this(dArray, new double[]{0.0, 0.0});
    }

    public LinearROI(double[] dArray, double[] dArray2) {
        this.spt = new double[]{dArray[0], dArray[1]};
        double d = dArray2[0] - dArray[0];
        double d2 = dArray2[1] - dArray[1];
        this.len = Math.sqrt(d * d + d2 * d2);
        this.ang = Math.atan2(d2, d);
        if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        this.calcTrig();
        this.crossHair = false;
    }

    public void setPointKeepEndPoint(int[] nArray) {
        double[] dArray = this.getEndPoint();
        this.spt[0] = nArray[0];
        this.spt[1] = nArray[1];
        double d = dArray[0] - (double)nArray[0];
        double d2 = dArray[1] - (double)nArray[1];
        this.len = Math.sqrt(d * d + d2 * d2);
        this.ang = Math.atan2(d2, d);
        if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        this.calcTrig();
    }

    public double[] getPoint(double d) {
        return new double[]{this.spt[0] + d * this.len * this.cang, this.spt[1] + d * this.len * this.sang};
    }

    public double[] getEndPoint() {
        return this.getPoint(1.0);
    }

    public int[] getIntPoint(double d) {
        double[] dArray = this.getPoint(d);
        return new int[]{(int)dArray[0], (int)dArray[1]};
    }

    public int[] getIntEndPoint() {
        double[] dArray = this.getPoint(1.0);
        return new int[]{(int)dArray[0], (int)dArray[1]};
    }

    public void setEndPoint(double d, double d2) {
        double d3 = d - this.spt[0];
        double d4 = d2 - this.spt[1];
        this.len = Math.sqrt(d3 * d3 + d4 * d4);
        this.ang = Math.atan2(d4, d3);
        if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        this.calcTrig();
    }

    public void setEndPoint(double[] dArray) {
        this.setEndPoint(dArray[0], dArray[1]);
    }

    public void setEndPoint(int[] nArray) {
        double d = (double)nArray[0] - this.spt[0];
        double d2 = (double)nArray[1] - this.spt[1];
        this.len = Math.sqrt(d * d + d2 * d2);
        this.ang = Math.atan2(d2, d);
        if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        this.calcTrig();
    }

    public double[] getMidPoint() {
        return this.getPoint(0.5);
    }

    public void setMidPoint(double[] dArray) {
        this.spt[0] = dArray[0] - 0.5 * this.len * this.cang;
        this.spt[1] = dArray[1] - 0.5 * this.len * this.sang;
    }

    public void setAngle(double d) {
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        this.ang = d;
        this.calcTrig();
    }

    public double getAngle() {
        return this.ang;
    }

    public void setAngleDegrees(double d) {
        if (d < 0.0) {
            d += 360.0;
        }
        this.ang = Math.toRadians(d);
        this.calcTrig();
    }

    private void calcTrig() {
        this.cang = Math.cos(this.ang);
        this.sang = Math.sin(this.ang);
    }

    public double getAngleDegrees() {
        return Math.toDegrees(this.ang);
    }

    public void setLength(double d) {
        this.len = d;
    }

    public double getLength() {
        return this.len;
    }

    public double getAngleRelativeToMidPoint(int[] nArray) {
        double[] dArray = this.getMidPoint();
        dArray[0] = (double)nArray[0] - dArray[0];
        dArray[1] = (double)nArray[1] - dArray[1];
        return Math.atan2(dArray[1], dArray[0]);
    }

    @Override
    public LinearROI copy() {
        LinearROI linearROI = new LinearROI(this.getPoint());
        linearROI.setAngle(this.getAngle());
        linearROI.setLength(this.getLength());
        linearROI.setCrossHair(this.isCrossHair());
        return linearROI;
    }

    public void subPoint(int[] nArray) {
        this.spt[0] = this.spt[0] - (double)nArray[0];
        this.spt[1] = this.spt[1] - (double)nArray[1];
    }

    public void translateAlongLength(double d) {
        this.spt[0] = this.spt[0] + d * this.cang;
        this.spt[1] = this.spt[1] + d * this.sang;
    }

    public int[] getPerpendicularBisectorIntPoint(double d) {
        double[] dArray = this.getMidPoint();
        double d2 = (d - 0.5) * this.len;
        double d3 = this.ang + 1.5707963267948966;
        return new int[]{(int)(dArray[0] + d2 * Math.cos(d3)), (int)(dArray[1] + d2 * Math.sin(d3))};
    }

    public void setCrossHair(boolean bl) {
        this.crossHair = bl;
    }

    public boolean isCrossHair() {
        return this.crossHair;
    }

    public String toString() {
        return String.format("Start (%g, %g) Length %g Angle %g", this.spt[0], this.spt[1], this.len, this.getAngleDegrees());
    }
}

