/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeWriter;
import java.util.Enumeration;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Nexus;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class SimpleNexusSaver
implements IFileSaver {
    private static final transient Logger logger = LoggerFactory.getLogger(SimpleNexusSaver.class);
    private String fileName = "";

    public SimpleNexusSaver(String string) {
        this.fileName = string;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        boolean bl = false;
        try {
            NexusFile nexusFile = new NexusFile(this.fileName, 5);
            nexusFile.makegroup("ScanFileHolder", "NXentry");
            nexusFile.opengroup("ScanFileHolder", "NXentry");
            nexusFile.makegroup("datasets", "NXdata");
            nexusFile.opengroup("datasets", "NXdata");
            String[] stringArray = dataHolder.getNames();
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                Enumeration enumeration = nexusFile.groupdir().keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (!((String)object).equalsIgnoreCase(stringArray[n])) continue;
                    bl = true;
                }
                if (bl) {
                    logger.warn("Duplicate headings found - only writing the first one.");
                } else {
                    object = dataHolder.getDataset(stringArray[n]);
                    int[] nArray = ((AbstractDataset)object).getShape();
                    nexusFile.makedata(stringArray[n], Nexus.getGroupDataType(((AbstractDataset)object).getDtype()), nArray.length, nArray);
                    nexusFile.opendata(stringArray[n]);
                    nexusFile.putdata(((AbstractDataset)object).getBuffer());
                    nexusFile.closedata();
                }
                ++n;
            }
            if (dataHolder.getNexusTree() != null) {
                NexusTreeWriter.writeHere((NexusFile)nexusFile, (INexusTree)dataHolder.getNexusTree());
            }
            nexusFile.close();
        }
        catch (NexusException nexusException) {
            logger.error("Problem writing to NeXus file {}", (Object)this.fileName);
            throw new ScanFileHolderException("Problem writing to NeXus file " + this.fileName);
        }
    }
}

