/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.MetaDataAdapter;
import uk.ac.gda.monitor.IMonitor;

public class PilatusEdfLoader
extends AbstractFileLoader
implements IMetaLoader {
    private String fileName;
    private Map<String, String> textMetadata = new HashMap<String, String>();

    public PilatusEdfLoader(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        IntegerDataset integerDataset = null;
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                if (!string.trim().startsWith("{")) {
                    throw new ScanFileHolderException("EDF File should start with {");
                }
                if (string.contains("{")) {
                    int n = this.readMetaData(bufferedReader, string.length() + 1, iMonitor);
                    int n2 = Integer.parseInt(this.textMetadata.get("Dim_1"));
                    int n3 = Integer.parseInt(this.textMetadata.get("Dim_2"));
                    int n4 = n2 * n3;
                    int[] nArray = new int[]{n3, n2};
                    integerDataset = new IntegerDataset(nArray);
                    int[] nArray2 = integerDataset.getData();
                    if ("LowByteFirst".equals(this.textMetadata.get("ByteOrder"))) {
                        this.readLeInt(fileInputStream, nArray2, n, n4);
                    } else {
                        this.readBeInt(fileInputStream, nArray2, n, n4);
                    }
                }
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("File failed to load " + this.fileName, exception);
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                fileInputStream = null;
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            fileInputStream = null;
        }
        dataHolder.addDataset("ESRF Pilatus Data", integerDataset);
        return dataHolder;
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.fileName)));
        try {
            String string = bufferedReader.readLine();
            this.readMetaData(bufferedReader, string.length() + 1, iMonitor);
        }
        finally {
            bufferedReader.close();
        }
    }

    @Override
    public IMetaData getMetaData() {
        return new MetaDataAdapter(){

            @Override
            public String getMetaValue(String string) {
                return (String)PilatusEdfLoader.this.textMetadata.get(string);
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(Arrays.asList("ESRF Pilatus Data"));
            }
        };
    }

    private int readMetaData(BufferedReader bufferedReader, int n, IMonitor iMonitor) throws Exception {
        this.textMetadata.clear();
        while (true) {
            if (iMonitor != null) {
                iMonitor.worked(1);
            }
            if (iMonitor != null && iMonitor.isCancelled()) {
                throw new ScanFileHolderException("Loader cancelled during reading!");
            }
            String string = bufferedReader.readLine();
            n += string.length() + 1;
            if (string.contains("}")) break;
            String[] stringArray = string.split("=");
            if (stringArray.length == 1) {
                this.textMetadata.put(stringArray[0].trim(), "");
                continue;
            }
            int n2 = stringArray[1].endsWith(";") ? stringArray[1].length() - 1 : stringArray[1].length();
            String string2 = stringArray[1].substring(0, n2);
            this.textMetadata.put(stringArray[0].trim(), string2.trim());
        }
        return n;
    }

    private void readLeInt(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[4 * n2 + n];
        inputStream.read(byArray);
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = PilatusEdfLoader.leInt(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], byArray[n3 + 3]);
            n3 += 4;
            ++n4;
        }
    }

    private void readBeInt(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[4 * n2 + n];
        inputStream.read(byArray);
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = PilatusEdfLoader.beInt(byArray[n3], byArray[n3 + 1], byArray[n3 + 2], byArray[n3 + 3]);
            n3 += 4;
            ++n4;
        }
    }

    public static int leInt(int n, int n2, int n3, int n4) {
        return (n4 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n2 & 0xFF) << 8 | n & 0xFF;
    }

    public static int beInt(int n, int n2, int n3, int n4) {
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }
}

