/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.PNGLoader;
import uk.ac.diamond.scisoft.analysis.io.PNGSaver;
import uk.ac.diamond.scisoft.analysis.io.PNGScaledSaver;

public class PNGTest {
    static final String TestFileFolder = "testfiles/images/";
    static String testScratchDirectoryName = null;
    AbstractDataset data;
    DataHolder dh = new DataHolder();
    int sizex = 500;
    int sizey = 500;
    int range = this.sizex * this.sizey;
    double abserr = 1.0;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)PNGTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testSaveFile() throws Exception {
        String string = "testSaveFile.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 65000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new PNGLoader(String.valueOf(testScratchDirectoryName) + string, false, true).loadFile();
        short[] sArray = (short[])this.data.getBuffer();
        AbstractDataset abstractDataset = dataHolder2.getDataset(0);
        short[] sArray2 = (short[])abstractDataset.getBuffer();
        Assert.assertEquals((long)sArray.length, (long)sArray2.length);
        int n = 0;
        while (n < sArray.length) {
            Assert.assertEquals((String)("" + n), (long)sArray[n], (long)sArray2[n]);
            ++n;
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        String string = "testLoaderFactory.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 65000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = LoaderFactory.getData(String.valueOf(testScratchDirectoryName) + string, null);
        if (dataHolder2 == null || dataHolder2.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void testPNGLoader2() throws Exception {
        new PNGLoader("testfiles/images/test.png", true).loadFile();
    }

    @Test
    public void manyImages() throws ScanFileHolderException {
        String string = "manyImages.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 65000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
    }

    @Test
    public void manyImagesScaled() throws ScanFileHolderException {
        String string = "manyImagesScaled.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 3);
        this.data.setShape(this.sizex, this.sizey);
        int n = 0;
        while (n < 5) {
            dataHolder.addDataset("testing data " + n, this.data);
            ++n;
        }
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
    }

    @Test
    public void compareDataset() throws ScanFileHolderException {
        String string = "compareDataset.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 65000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new PNGLoader(String.valueOf(testScratchDirectoryName) + string, false, true).loadFile();
        double[] dArray = dataHolder.getDataSet(0).getBuffer();
        double[] dArray2 = dataHolder2.getDataSet(0).getBuffer();
        int[] nArray = dataHolder.getDataSet(0).getShape();
        int n = nArray[0];
        int n2 = nArray[1];
        int[] nArray2 = dataHolder2.getDataSet(0).getShape();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        Assert.assertEquals((long)(n * n2), (long)(n3 * n4));
        int n5 = 0;
        while (n5 < n * n2) {
            Assert.assertEquals((double)Math.floor(dArray[n5]), (double)dArray2[n5], (double)this.abserr);
            ++n5;
        }
    }

    @Test
    public void compareScaledDataset() throws ScanFileHolderException {
        String string = "compareScaledDataset.png";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 250000.0, this.range, 3);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        DataHolder dataHolder2 = new PNGLoader(String.valueOf(testScratchDirectoryName) + string, false, true).loadFile();
        AbstractDataset abstractDataset = dataHolder.getDataset(0);
        double d = abstractDataset.min().doubleValue();
        double d2 = abstractDataset.max().doubleValue();
        abstractDataset = Maths.multiply(Maths.subtract((Object)abstractDataset, d), 65535.0 / (d2 - d));
        short[] sArray = (short[])dataHolder2.getDataset(0).getBuffer();
        int[] nArray = abstractDataset.getShape();
        int n = nArray[0];
        int n2 = nArray[1];
        int[] nArray2 = dataHolder2.getDataset(0).getShape();
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        Assert.assertEquals((long)(n * n2), (long)(n3 * n4));
        int n5 = 0;
        while (n5 < n * n2) {
            Assert.assertEquals((String)("" + n5), (long)((short)abstractDataset.getElementLongAbs(n5)), (long)sArray[n5]);
            ++n5;
        }
    }

    @Test
    public void noEnding() throws Exception {
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 65000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + "noEnding.png").saveFile(dataHolder);
        this.dh = new PNGLoader(String.valueOf(testScratchDirectoryName) + "noEnding").loadFile();
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + "noEnding1").saveFile(this.dh);
    }

    @Test
    public void incorrectEnding() throws Exception {
        String string = "incorrectEnding.txt";
        String string2 = "incorrectEnding1.txt";
        DataHolder dataHolder = new DataHolder();
        this.data = DatasetUtils.linSpace(0.0, 65000.0, this.range, 2);
        this.data.setShape(this.sizex, this.sizey);
        dataHolder.addDataset("testing data", this.data);
        new PNGScaledSaver(String.valueOf(testScratchDirectoryName) + string).saveFile(dataHolder);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + string2).saveFile(dataHolder);
        new PNGLoader(String.valueOf(testScratchDirectoryName) + string).loadFile();
        new PNGLoader(String.valueOf(testScratchDirectoryName) + string2).loadFile();
    }

    @Test
    public void testNoFile() throws ScanFileHolderException {
        block2: {
            try {
                new PNGLoader(String.valueOf(testScratchDirectoryName) + "NoFile.png").loadFile();
            }
            catch (ScanFileHolderException scanFileHolderException) {
                if (scanFileHolderException.getCause() instanceof FileNotFoundException) break block2;
                throw scanFileHolderException;
            }
        }
    }
}

