/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.data.nexus.extractor.NexusExtractor;
import gda.util.TestUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import junitx.framework.FileAssert;
import org.junit.Assert;
import org.junit.Test;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.NexusLoader;

public class NexusLoaderTest {
    static final String TestFileFolder = "testfiles/gda/analysis/io/NexusLoaderTest/";
    static String testScratchDirectoryName = null;

    public void setUp(String string) throws Exception {
        testScratchDirectoryName = TestUtils.setUpTest(NexusLoaderTest.class, (String)string, (boolean)true);
    }

    private void makeTestFile(String string, int[] nArray) throws NexusException {
        NexusFile nexusFile = null;
        nexusFile = new NexusFile(string, 5);
        nexusFile.makegroup("dummy", "dummy");
        nexusFile.opengroup("dummy", "dummy");
        nexusFile.makedata("heading1", 6, nArray.length, nArray);
        nexusFile.opendata("heading1");
        int n = NexusExtractor.calcTotalLength((int[])nArray);
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2;
            ++n2;
        }
        nexusFile.putdata((Object)dArray);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.makegroup("ScanFileHolder", "NXentry");
        nexusFile.opengroup("ScanFileHolder", "NXentry");
        nexusFile.makegroup("datasets", "NXdata");
        nexusFile.opengroup("datasets", "NXdata");
        nexusFile.makedata("heading1", 6, nArray.length, nArray);
        nexusFile.opendata("heading1");
        n = NexusExtractor.calcTotalLength((int[])nArray);
        dArray = new double[n];
        n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2;
            ++n2;
        }
        nexusFile.putdata((Object)dArray);
        nexusFile.closedata();
        nexusFile.makedata("heading2", 6, nArray.length, nArray);
        nexusFile.opendata("heading2");
        n = NexusExtractor.calcTotalLength((int[])nArray);
        dArray = new double[n];
        n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2 * 2;
            ++n2;
        }
        nexusFile.putdata((Object)dArray);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.closegroup();
        nexusFile.close();
    }

    @Test
    public void testconvertToAscii1() throws Exception {
        this.setUp("testconvertToAscii1");
        System.out.println("LD path is " + System.getenv("LD_LIBRARY_PATH"));
        String string = String.valueOf(testScratchDirectoryName) + "/NexusLoaderTest_convertToAscii1_Actual.txt";
        NexusLoader.convertToAscii("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest.nxs", "testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTestSelection1.xml", null, string, null);
        FileAssert.assertEquals((File)new File("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest_convertToAscii1_Expected.txt"), (File)new File(string));
    }

    @Test
    public void testconvertToAscii2() throws Exception {
        this.setUp("testconvertToAscii2");
        this.makeTestFile(String.valueOf(testScratchDirectoryName) + "/testconvertToAscii2.nxs", new int[]{5, 10});
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("datasets.heading1");
        linkedList.add("datasets.heading2");
        String string = String.valueOf(testScratchDirectoryName) + "/NexusLoaderTest_convertToAscii2_Actual.txt";
        NexusLoader.convertToAscii(String.valueOf(testScratchDirectoryName) + "/testconvertToAscii2.nxs", null, null, string, linkedList);
        FileAssert.assertEquals((File)new File("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest_convertToAscii2_Expected.txt"), (File)new File(string));
        new File("testfiles/gda/analysis/io/NexusLoaderTest/testconvertToAscii2.nxs").delete();
    }

    @Test
    public void testconvertToAscii3() throws Exception {
        this.setUp("testconvertToAscii3");
        this.makeTestFile("testfiles/gda/analysis/io/NexusLoaderTest/testconvertToAscii3.nxs", new int[]{5, 10});
        String string = String.valueOf(testScratchDirectoryName) + "/NexusLoaderTest_convertToAscii3_Actual.txt";
        NexusLoader.convertToAscii("testfiles/gda/analysis/io/NexusLoaderTest/testconvertToAscii3.nxs", "", "", string, null);
        FileAssert.assertEquals((File)new File("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest_convertToAscii3_Expected.txt"), (File)new File(string));
        new File("testfiles/gda/analysis/io/NexusLoaderTest/testconvertToAscii3.nxs").delete();
    }

    @Test
    public void testconvertToAscii4() throws Exception {
        this.setUp("testconvertToAscii4");
        String string = String.valueOf(testScratchDirectoryName) + "/NexusLoaderTest_convertToAscii4_Actual.txt";
        NexusLoader.convertToAscii("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest.nxs", "testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTestSelection2.xml", "testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTestSelection2.xml", string, null);
        FileAssert.assertEquals((File)new File("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest_convertToAscii4_Expected.txt"), (File)new File(string));
    }

    @Test
    public void testconvertToSRS1() throws Exception {
        this.setUp("testconvertToSRS1");
        String string = String.valueOf(testScratchDirectoryName) + "/NexusLoaderTest_convertToSRS1_Actual.txt";
        NexusLoader.convertToSRS("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest.nxs", "testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTestSelection2.xml", "testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTestSelection2.xml", string, null);
        FileAssert.assertEquals((File)new File("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest_convertToSRS1_Expected.txt"), (File)new File(string));
    }

    @Test
    public void testDataHolderUsage() throws Exception {
        this.setUp("testScanFileHolderUsage");
        this.makeTestFile(String.valueOf(testScratchDirectoryName) + "/testScanFileHolderUsage.nxs", new int[]{5, 10});
        Vector<String> vector = new Vector<String>();
        vector.add("datasets.heading1");
        vector.add("datasets.heading2");
        DataHolder dataHolder = new NexusLoader(String.valueOf(testScratchDirectoryName) + "/testScanFileHolderUsage.nxs", vector).loadFile();
        AbstractDataset abstractDataset = dataHolder.getDataset("datasets.heading1");
        AbstractDataset abstractDataset2 = dataHolder.getDataset("datasets.heading2");
        Assert.assertEquals((Object)"datasets.heading1", (Object)abstractDataset.getName());
        Assert.assertEquals((double)0.0, (double)abstractDataset.getDouble(0), (double)1.0E-4);
        Assert.assertEquals((double)49.0, (double)abstractDataset.getDouble(4, 9), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)abstractDataset2.getDouble(0), (double)1.0E-4);
        Assert.assertEquals((double)98.0, (double)abstractDataset2.getDouble(4, 9), (double)1.0E-4);
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/NexusLoaderTest/NexusLoaderTest.nxs", null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void testMultipleDetectorSameDataElements() throws Exception {
        String string = TestUtils.getGDALargeTestFilesLocation();
        if (string != null) {
            DataHolder dataHolder = new NexusLoader(String.valueOf(string) + "/multiDetector.nxs").loadFile();
            String[] stringArray = dataHolder.getNames();
            Assert.assertEquals((String)"Number of headings is incorrect", (long)120L, (long)stringArray.length);
            Assert.assertEquals((Object)"EDXD_Element_23.edxd_q", (Object)stringArray[71]);
            Assert.assertEquals((Object)"EDXD_Element_23.data", (Object)stringArray[69]);
            Assert.assertEquals((Object)"bottom", (Object)stringArray[72]);
            Assert.assertEquals((Object)"scaler1.scaler1-9", (Object)stringArray[113]);
            Assert.assertEquals((Object)"scaler1.I0 EH1", (Object)stringArray[82]);
        }
    }

    @Test
    public void testMultipleDetectorSameDataElementsNameDataSets() throws Exception {
        String string = TestUtils.getGDALargeTestFilesLocation();
        if (string != null) {
            Vector<String> vector = new Vector<String>();
            vector.add("bottom");
            vector.add("EDXD_Element_23.edxd_q");
            vector.add("EDXD_Element_23.data");
            vector.add("scaler1.scaler1-9");
            vector.add("scaler1.I0 EH1");
            DataHolder dataHolder = new NexusLoader(String.valueOf(string) + "/multiDetector.nxs", vector).loadFile();
            String[] stringArray = dataHolder.getNames();
            Assert.assertEquals((String)"Number of headings is incorrect", (long)5L, (long)stringArray.length);
            Assert.assertEquals((Object)"bottom", (Object)stringArray[0]);
            Assert.assertEquals((Object)"EDXD_Element_23.edxd_q", (Object)stringArray[1]);
            Assert.assertEquals((Object)"EDXD_Element_23.data", (Object)stringArray[2]);
            Assert.assertEquals((Object)"scaler1.scaler1-9", (Object)stringArray[3]);
            Assert.assertEquals((Object)"scaler1.I0 EH1", (Object)stringArray[4]);
        }
    }

    @Test
    public void testMultipleDetectorGetDataSetNames() throws Exception {
        String string = TestUtils.getGDALargeTestFilesLocation();
        if (string != null) {
            List<String> list = NexusLoader.getDatasetNames(String.valueOf(string) + "/multiDetector.nxs", null);
            String[] stringArray = list.toArray(new String[0]);
            Assert.assertEquals((String)"Number of headings is incorrect", (long)120L, (long)stringArray.length);
            Assert.assertEquals((Object)"EDXD_Element_23.edxd_q", (Object)stringArray[71]);
            Assert.assertEquals((Object)"EDXD_Element_23.data", (Object)stringArray[69]);
            Assert.assertEquals((Object)"bottom", (Object)stringArray[72]);
            Assert.assertEquals((Object)"scaler1.scaler1-9", (Object)stringArray[113]);
            Assert.assertEquals((Object)"scaler1.I0 EH1", (Object)stringArray[82]);
        }
    }

    @Test
    public void testLoaderFactory2() throws Exception {
        String string = TestUtils.getGDALargeTestFilesLocation();
        DataHolder dataHolder = LoaderFactory.getData(String.valueOf(string) + "/multiDetector.nxs", null);
        String[] stringArray = dataHolder.getNames();
        Assert.assertEquals((String)"Number of headings is incorrect", (long)120L, (long)stringArray.length);
        Assert.assertEquals((Object)"EDXD_Element_23.edxd_q", (Object)stringArray[71]);
        Assert.assertEquals((Object)"EDXD_Element_23.data", (Object)stringArray[69]);
        Assert.assertEquals((Object)"bottom", (Object)stringArray[72]);
        Assert.assertEquals((Object)"scaler1.scaler1-9", (Object)stringArray[113]);
        Assert.assertEquals((Object)"scaler1.I0 EH1", (Object)stringArray[82]);
    }

    @Test
    public void testLoaderFactoryMeta() throws Exception {
        String string = TestUtils.getGDALargeTestFilesLocation();
        IMetaData iMetaData = LoaderFactory.getMetaData(String.valueOf(string) + "/multiDetector.nxs", null);
        String[] stringArray = iMetaData.getDataNames().toArray(new String[iMetaData.getDataNames().size()]);
        Assert.assertEquals((String)"Number of headings is incorrect", (long)120L, (long)stringArray.length);
        Assert.assertEquals((Object)"EDXD_Element_23.edxd_q", (Object)stringArray[71]);
        Assert.assertEquals((Object)"EDXD_Element_23.data", (Object)stringArray[69]);
        Assert.assertEquals((Object)"bottom", (Object)stringArray[72]);
        Assert.assertEquals((Object)"scaler1.scaler1-9", (Object)stringArray[113]);
        Assert.assertEquals((Object)"scaler1.I0 EH1", (Object)stringArray[82]);
    }
}

